/*
 * Decompiled with CFR 0.152.
 */
package com.eprobiti.trs;

import com.eprobiti.trs.TRSConnection;
import com.eprobiti.trs.TRSDataBase;
import com.eprobiti.trs.TRSException;
import com.eprobiti.trs.TRSFormat;
import com.eprobiti.trs.TRSGroup;
import com.eprobiti.trs.TRSJNIV61;
import com.eprobiti.trs.TRSUser;
import com.eprobiti.trs.TRSView;

public class TRSMetaData {
    private TRSConnection m_conn = null;

    public TRSMetaData(TRSConnection conn) throws TRSException {
        if (conn == null) {
            throw TRSException.New(500002, "");
        }
        this.m_conn = conn;
    }

    public int getBeanJNIid() {
        return TRSJNIV61.getBeanVersion();
    }

    public TRSDataBase[] getDataBases(String strNames) throws TRSException {
        return this.getDataBases(strNames, 0);
    }

    public TRSDataBase[] getDataBases(String strNames, int iRightCode) throws TRSException {
        return this.m_conn.getDataBases(strNames, iRightCode);
    }

    public TRSFormat[] getFormats(String strNames) throws TRSException {
        return this.m_conn.getFormats(strNames);
    }

    public TRSGroup[] getGroups(String strNames) throws TRSException {
        return this.m_conn.getGroups(strNames);
    }

    public TRSUser[] getUsers(String strNames, int iUserType) throws TRSException {
        return this.m_conn.getUsers(strNames, iUserType);
    }

    public TRSView[] getViews(String strNames) throws TRSException {
        return this.getViews(strNames, 0);
    }

    public TRSView[] getViews(String strNames, int iRightCode) throws TRSException {
        return this.m_conn.getViews(strNames, iRightCode);
    }

    public int recoverDatabases(String strDatabases, String strDevice, String strDirectory) throws TRSException {
        return this.m_conn.recoverDatabases(strDatabases, strDevice, strDirectory);
    }

    public String getFullVersion() throws TRSException {
        return this.m_conn.getVersion("Full");
    }

    public String getBeanVersion() throws TRSException {
        return this.m_conn.getVersion("Bean");
    }
}

