/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.file.IProgressListener;
import com.trs.dev4.jdk16.utils.AssertUtil;
import com.trs.dev4.jdk16.utils.CloseUtil;
import com.trs.dev4.jdk16.utils.FileUtil;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class IOUtil {
    private static final int BUF_SIZE = 4096;

    public static void copy(InputStream is, OutputStream os) throws IOException {
        IOUtil.copy(is, os, null, 0L);
    }

    public static long copy(InputStream is, OutputStream os, IProgressListener listener, long totalSize) throws IOException {
        return IOUtil.copy(is, os, 4096, listener, totalSize);
    }

    public static long copy(InputStream is, OutputStream os, int bufSize, IProgressListener listener, long totalSize) throws IOException {
        AssertUtil.notNull(is, "input stream is null!");
        AssertUtil.notNull(os, "output stream is null!");
        long totalTransferred = 0L;
        BufferedInputStream bis = new BufferedInputStream(is, bufSize);
        BufferedOutputStream bos = new BufferedOutputStream(os, bufSize);
        int len = 0;
        byte[] buf = new byte[bufSize];
        try {
            while ((len = bis.read(buf)) > 0) {
                bos.write(buf, 0, len);
                totalTransferred += (long)len;
                if (listener == null) continue;
                listener.bytesTransferred(totalTransferred, len, totalSize);
            }
        }
        finally {
            bos.flush();
        }
        return totalTransferred;
    }

    public static void copy(File file, OutputStream os) throws IOException {
        FileUtil.assertFileCanRead(file);
        FileInputStream is = new FileInputStream(file);
        try {
            IOUtil.copy(is, os);
        }
        finally {
            CloseUtil.closeInputStream(is);
        }
    }

    public static List<String> loadText(InputStream is, String encoding) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        InputStreamReader isr = new InputStreamReader(is, StringHelper.avoidEmpty(encoding, "UTF-8"));
        BufferedReader br = new BufferedReader(isr);
        String line = br.readLine();
        while (line != null) {
            result.add(line);
            line = br.readLine();
        }
        return result;
    }
}

