/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.verifycode;

import com.trs.dev4.verifycode.VerifyCodeConst;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class VerifyCodeGenerator {
    private final int pictureHeight;
    private final int pictureWidth;
    private int fontSize;
    private final Random imgGenerator = new Random();
    private final Map verifyCodeTypeMap = new HashMap();

    public VerifyCodeGenerator(int pictureHeight, int pictureWidth) {
        this.verifyCodeTypeMap.put("1", VerifyCodeConst.numbers);
        this.verifyCodeTypeMap.put("2", VerifyCodeConst.smallLetters);
        this.verifyCodeTypeMap.put("3", VerifyCodeConst.bigLetters);
        this.verifyCodeTypeMap.put("4", VerifyCodeConst.numbers_smallLetters);
        this.verifyCodeTypeMap.put("5", VerifyCodeConst.numbers_bigLetters);
        this.verifyCodeTypeMap.put("6", VerifyCodeConst.smallLetters_bigLetters);
        this.verifyCodeTypeMap.put("7", VerifyCodeConst.numbers_smallLetters_bigLetters);
        this.pictureHeight = pictureHeight;
        this.pictureWidth = pictureWidth;
    }

    private char getSingalVerifyCode(String verifyCodeType) {
        Object contentObj = this.verifyCodeTypeMap.get(verifyCodeType);
        if (contentObj == null) {
            contentObj = this.verifyCodeTypeMap.get("1");
        }
        char[] verifyCodeStrs = (char[])contentObj;
        int car = verifyCodeStrs.length - 1;
        return verifyCodeStrs[this.imgGenerator.nextInt(car) + 1];
    }

    public Serializable generateVerifyCode(int length, String verifyCodeType) {
        String verifyCode = "";
        int i = 0;
        while (i < length) {
            verifyCode = String.valueOf(verifyCode) + this.getSingalVerifyCode(verifyCodeType);
            ++i;
        }
        return verifyCode;
    }

    public void drawVerifyCodeToPicture(HttpServletRequest request, HttpServletResponse response, Serializable verifyCode, int noiseLevel, int torsionResistance, int fontSize) throws IOException {
        this.fontSize = fontSize;
        response.setContentType("image/jpeg");
        ImageIO.write((RenderedImage)this.drawChar(verifyCode.toString(), null, noiseLevel, torsionResistance), "JPEG", (OutputStream)response.getOutputStream());
    }

    private BufferedImage drawChar(String verifyCode, Font font, int noiseLevel, int torsionResistance) {
        BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 13);
        Graphics2D graphics = bi.createGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        graphics.setColor(Color.black);
        int i = 0;
        while (i < noiseLevel) {
            graphics.setColor(this.getRandColor());
            graphics.drawRect(this.imgGenerator.nextInt(320), this.imgGenerator.nextInt(100), 1, 1);
            ++i;
        }
        AffineTransform fontAT = new AffineTransform();
        fontAT.shear(3.0, -2.0);
        fontAT.rotate(Math.toRadians(this.imgGenerator.nextInt(10)));
        fontAT.scale(0.8, 2.0);
        AttributedString as = new AttributedString(verifyCode);
        int i2 = 0;
        while (i2 < verifyCode.length()) {
            Font actualFont = font == null ? this.getRandomFontFromSelectedOnLinux() : font;
            as.addAttribute(TextAttribute.FONT, actualFont, i2, i2 + 1);
            as.addAttribute(TextAttribute.FOREGROUND, this.getRandColor(), i2, i2 + 1);
            as.addAttribute(TextAttribute.TRANSFORM, fontAT, i2, i2 + 1);
            as.addAttribute(TextAttribute.WIDTH, new Integer(this.imgGenerator.nextInt(1) * 10 + 20), i2, i2 + 1);
            as.addAttribute(TextAttribute.STRIKETHROUGH, new Boolean(this.imgGenerator.nextInt(2) == 1), i2, i2 + 1);
            as.addAttribute(TextAttribute.SUPERSCRIPT, this.imgGenerator.nextInt(2) == 1 ? TextAttribute.SUPERSCRIPT_SUB : TextAttribute.SUPERSCRIPT_SUPER, i2, i2 + 1);
            ++i2;
        }
        int w = bi.getWidth();
        int h = bi.getHeight();
        graphics.drawString(as.getIterator(), 10 + this.imgGenerator.nextInt(1) * 10, h / 2 + 15);
        this.shear(graphics, w, h, Color.white, torsionResistance);
        return bi;
    }

    private Font getRandomFontFromSelectedOnLinux() {
        Random random = new Random();
        Font[] font = this.getAllSelectedFontsOnLinux();
        Font result = font[random.nextInt(font.length)];
        return result;
    }

    private Color getRandColor() {
        Random random = new Random();
        Color[] color = new Color[10];
        color[0] = new Color(32, 158, 25);
        color[1] = new Color(218, 42, 19);
        color[2] = new Color(31, 75, 208);
        return color[random.nextInt(3)];
    }

    private void shear(Graphics g, int w1, int h1, Color color, int torsionResistance) {
        this.shearX(g, w1, h1, color);
        this.shearY(g, w1, h1, color, torsionResistance);
    }

    private void shearX(Graphics g, int w1, int h1, Color color) {
        int period = this.imgGenerator.nextInt(2);
        boolean borderGap = true;
        int frames = 10;
        int phase = this.imgGenerator.nextInt(2);
        int i = 0;
        while (i < h1) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(0, i, w1, 1, (int)d, 0);
            if (borderGap) {
                g.setColor(color);
                g.drawLine((int)d, i, 0, i);
                g.drawLine((int)d + w1, i, w1, i);
            }
            ++i;
        }
    }

    private void shearY(Graphics g, int w1, int h1, Color color, int torsionResistance) {
        int period = this.imgGenerator.nextInt(torsionResistance) + 20;
        boolean borderGap = true;
        int frames = 20;
        int phase = 10;
        int i = 0;
        while (i < w1) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(i, 0, 1, h1, 0, (int)d);
            if (borderGap) {
                g.setColor(color);
                g.drawLine(i, (int)d, i, 0);
                g.drawLine(i, (int)d + h1, i, h1);
            }
            ++i;
        }
    }

    private Font[] getAllSelectedFontsOnLinux() {
        int fontStyle = 0;
        Font[] font = new Font[]{new Font("AR PL ShanHeiSun Uni", fontStyle, this.fontSize), new Font("AR PL ZenKai Uni", fontStyle, this.fontSize), new Font("Bitstream Charter Bold", fontStyle, this.fontSize), new Font("Bitstream Charter Italic", fontStyle, this.fontSize), new Font("Bitstream Vera Sans", fontStyle, this.fontSize), new Font("Bitstream Vera Sans Bold1", fontStyle, this.fontSize), new Font("Bitstream Vera Sans Bold Oblique", fontStyle, this.fontSize), new Font("Bitstream Vera Sans Mono1", fontStyle, this.fontSize), new Font("Bitstream Vera Sans Mono Bold", fontStyle, this.fontSize), new Font("Bitstream Vera Sans Mono Bold Oblique", fontStyle, this.fontSize), new Font("Bitstream Vera Sans Mono Oblique", fontStyle, this.fontSize), new Font("Bitstream Vera Serif Bold", fontStyle, this.fontSize), new Font("Century Schoolbook L Bold", fontStyle, this.fontSize), new Font("Century Schoolbook L Italic", fontStyle, this.fontSize), new Font("Century Schoolbook L Bold Italic", fontStyle, this.fontSize), new Font("Courier 10 Pitch Bold", fontStyle, this.fontSize), new Font("Courier Italic", fontStyle, this.fontSize), new Font("Courier Bold Italic", fontStyle, this.fontSize), new Font("DejaVu LGC Sans ExtraLight", fontStyle, this.fontSize), new Font("DejaVu LGC Sans Mono", fontStyle, this.fontSize), new Font("DejaVu LGC Serif Bold", fontStyle, this.fontSize), new Font("DejaVu LGC Serif Condensed Bold Oblique", fontStyle, this.fontSize), new Font("DialogInput.italic", fontStyle, this.fontSize), new Font("Luxi Serif Bold", fontStyle, this.fontSize), new Font("Monospaced.bold", fontStyle, this.fontSize), new Font("Nimbus Mono L Regular", fontStyle, this.fontSize), new Font("Nimbus Roman No9 L Bold", fontStyle, this.fontSize), new Font("Nimbus Sans L Bold Italic", fontStyle, this.fontSize), new Font("URW Bookman L Demi Bold Italic", fontStyle, this.fontSize), new Font("URW Chancery L Medium Italic", fontStyle, this.fontSize), new Font("URW Palladio L Bold Italic", 0, this.fontSize)};
        return font;
    }

    private int getHeight() {
        return this.pictureHeight < 40 || this.pictureHeight > 80 ? 80 : this.pictureHeight;
    }

    private int getWidth() {
        return this.pictureWidth < 80 || this.pictureWidth > 195 ? 195 : this.pictureWidth;
    }
}

