/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class TransportTracer {
    private static final Logger s_logger;
    private final File file;
    private OutputStream os;
    private byte[] srcAddr;
    private byte[] srcPort;
    private byte[] dstAddr;
    private byte[] dstPort;
    private static final byte[] MAGICK_HEADER;
    private final byte[] BUFF_FOR_LONG = new byte[8];
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.io.TransportTracer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
        MAGICK_HEADER = new byte[]{85, 85, 85, 85, 85, 85, 85, 85};
    }

    public static final TransportTracer newTracer(String path, String filename) {
        try {
            File directory = new File(path);
            if (!directory.isDirectory()) {
                throw new IOException("path:" + path + " not directory");
            }
            if (!directory.exists()) {
                directory.mkdirs();
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("");
            filename = String.valueOf(dateFormat.format(new Date())) + filename;
            File file = new File(directory, filename);
            FileOutputStream os = new FileOutputStream(file);
            return new TransportTracer(file, os);
        }
        catch (Exception e) {
            s_logger.error((Object)"Create new tracer failed", (Throwable)e);
            return null;
        }
    }

    private static final byte[] short2bytes(int value) {
        byte[] result = new byte[]{(byte)(value >>> 8), (byte)(value >>> 0)};
        return result;
    }

    private TransportTracer(File file, OutputStream os) {
        this.file = file;
        this.os = os;
    }

    public final File getFile() {
        return this.file;
    }

    public final TransportTracer initialize(DatagramSocket socket, boolean send) {
        try {
            if (send) {
                this.srcAddr = socket.getLocalAddress().getAddress();
                this.srcPort = TransportTracer.short2bytes(socket.getLocalPort());
            } else {
                this.dstAddr = socket.getLocalAddress().getAddress();
                this.dstPort = TransportTracer.short2bytes(socket.getLocalPort());
            }
        }
        catch (Exception e) {
            s_logger.error((Object)"initialize tracer failed", (Throwable)e);
            return null;
        }
        if (this.srcAddr == null || this.srcAddr.length != 4) {
            this.srcAddr = new byte[4];
            this.srcAddr[0] = 0;
            this.srcAddr[1] = 0;
            this.srcAddr[2] = 0;
            this.srcAddr[3] = 0;
        }
        if (this.srcPort == null || this.srcPort.length != 2) {
            this.srcPort = new byte[2];
            this.srcPort[0] = 0;
            this.srcPort[1] = 0;
        }
        if (this.dstAddr == null || this.dstAddr.length != 4) {
            this.dstAddr = new byte[4];
            this.dstAddr[0] = 0;
            this.dstAddr[1] = 0;
            this.dstAddr[2] = 0;
            this.dstAddr[3] = 0;
        }
        if (this.dstPort == null || this.dstPort.length != 2) {
            this.dstPort = new byte[2];
            this.dstPort[0] = 0;
            this.dstPort[1] = 0;
        }
        return this;
    }

    public final TransportTracer initialize(Socket socket, boolean send) {
        try {
            if (send) {
                this.srcAddr = socket.getLocalAddress().getAddress();
                this.srcPort = TransportTracer.short2bytes(socket.getLocalPort());
                this.dstAddr = socket.getInetAddress().getAddress();
                this.dstPort = TransportTracer.short2bytes(socket.getPort());
            } else {
                this.srcAddr = socket.getInetAddress().getAddress();
                this.srcPort = TransportTracer.short2bytes(socket.getPort());
                this.dstAddr = socket.getLocalAddress().getAddress();
                this.dstPort = TransportTracer.short2bytes(socket.getLocalPort());
            }
        }
        catch (Exception e) {
            s_logger.error((Object)"initialize tracer failed", (Throwable)e);
            return null;
        }
        if (this.srcAddr == null || this.srcAddr.length != 4) {
            return null;
        }
        if (this.srcPort == null || this.srcPort.length != 2) {
            return null;
        }
        if (this.dstAddr == null || this.dstAddr.length != 4) {
            return null;
        }
        if (this.dstPort == null || this.dstPort.length != 2) {
            return null;
        }
        return this;
    }

    private void writeHead() {
        this.writeData(MAGICK_HEADER, 0, MAGICK_HEADER.length);
    }

    private void writeAddress(byte[] addr) {
        this.writeData(addr, 0, 4);
    }

    private void writePort(byte[] port) {
        this.writeData(port, 0, 2);
    }

    private void writePort(int value) {
        byte[] buffer = this.BUFF_FOR_LONG;
        buffer[0] = (byte)(value >>> 8);
        buffer[1] = (byte)(value >>> 0);
        this.writeData(buffer, 0, 2);
    }

    private void writeLong(long value) {
        byte[] buffer = this.BUFF_FOR_LONG;
        buffer[0] = (byte)(value >>> 56);
        buffer[1] = (byte)(value >>> 48);
        buffer[2] = (byte)(value >>> 40);
        buffer[3] = (byte)(value >>> 32);
        buffer[4] = (byte)(value >>> 24);
        buffer[5] = (byte)(value >>> 16);
        buffer[6] = (byte)(value >>> 8);
        buffer[7] = (byte)(value >>> 0);
        this.writeData(buffer, 0, 8);
    }

    private void writeInt(int value) {
        byte[] buffer = this.BUFF_FOR_LONG;
        buffer[0] = (byte)(value >>> 24);
        buffer[1] = (byte)(value >>> 16);
        buffer[2] = (byte)(value >>> 8);
        buffer[3] = (byte)(value >>> 0);
        this.writeData(buffer, 0, 4);
    }

    public void writeData(byte[] data, int offet, int length) {
        try {
            this.os.write(data, offet, length);
        }
        catch (Exception e) {
            s_logger.error((Object)"write data failed", (Throwable)e);
        }
    }

    public void trace(byte[] data, int offet, int length) {
        this.writeHead();
        this.writeLong(System.currentTimeMillis());
        this.writeAddress(this.srcAddr);
        this.writePort(this.srcPort);
        this.writeAddress(this.dstAddr);
        this.writePort(this.dstPort);
        this.writeInt(length);
        this.writeData(data, offet, length);
    }

    public void trace(byte[] data, int offet, int length, InetAddress toAddress, int toPort) {
        this.writeHead();
        this.writeLong(System.currentTimeMillis());
        this.writeAddress(this.srcAddr);
        this.writePort(this.srcPort);
        this.writeAddress(toAddress.getAddress());
        this.writePort(toPort);
        this.writeInt(length);
        this.writeData(data, offet, length);
    }

    public void trace(DatagramPacket packet) {
        this.writeHead();
        this.writeLong(System.currentTimeMillis());
        this.writeAddress(packet.getAddress().getAddress());
        this.writePort(packet.getPort());
        this.writeAddress(this.dstAddr);
        this.writePort(this.dstPort);
        this.writeInt(packet.getLength());
        this.writeData(packet.getData(), packet.getOffset(), packet.getLength());
    }

    public void flush() {
        try {
            this.os.flush();
        }
        catch (Exception e) {
            s_logger.error((Object)"flush tracer failed", (Throwable)e);
        }
    }

    public void close() {
        try {
            this.os.close();
        }
        catch (Exception e) {
            s_logger.error((Object)"close tracer failed", (Throwable)e);
        }
    }
}

