/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.Serializable;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.ExtendedNode;
import org.apache.batik.dom.events.EventSupport;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.util.DOMUtilities;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.MutationEvent;

public abstract class AbstractNode
implements ExtendedNode,
Serializable {
    protected static final NodeList EMPTY_NODE_LIST = new NodeList(){

        public Node item(int n) {
            return null;
        }

        public int getLength() {
            return 0;
        }
    };
    protected AbstractDocument ownerDocument;
    protected transient EventSupport eventSupport;

    public void setNodeName(String string) {
    }

    public void setOwnerDocument(Document document) {
        this.ownerDocument = (AbstractDocument)document;
    }

    public void setSpecified(boolean bl) {
        throw this.createDOMException((short)11, "node.type", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String string) throws DOMException {
    }

    public Node getParentNode() {
        return null;
    }

    public void setParentNode(Node node) {
        throw this.createDOMException((short)3, "parent.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    public NodeList getChildNodes() {
        return EMPTY_NODE_LIST;
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public void setPreviousSibling(Node node) {
        throw this.createDOMException((short)3, "sibling.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    public Node getPreviousSibling() {
        return null;
    }

    public void setNextSibling(Node node) {
        throw this.createDOMException((short)3, "sibling.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    public Node getNextSibling() {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    public String getNamespaceURI() {
        return null;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        throw this.createDOMException((short)3, "children.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        throw this.createDOMException((short)3, "children.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    public Node removeChild(Node node) throws DOMException {
        throw this.createDOMException((short)3, "children.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    public Node appendChild(Node node) throws DOMException {
        throw this.createDOMException((short)3, "children.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    public boolean hasChildNodes() {
        return false;
    }

    public Node cloneNode(boolean bl) {
        return bl ? this.deepCopyInto(this.newNode()) : this.copyInto(this.newNode());
    }

    public void normalize() {
    }

    public boolean isSupported(String string, String string2) {
        return this.getCurrentDocument().getImplementation().hasFeature(string, string2);
    }

    public String getPrefix() {
        return this.getNamespaceURI() == null ? null : DOMUtilities.getPrefix(this.getNodeName());
    }

    public void setPrefix(String string) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        String string2 = this.getNamespaceURI();
        if (string2 == null) {
            throw this.createDOMException((short)14, "namespace", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        String string3 = this.getLocalName();
        if (string == null) {
            this.setNodeName(string3);
        }
        if (!string.equals("") && !DOMUtilities.isValidName(string)) {
            throw this.createDOMException((short)5, "prefix", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), string});
        }
        if (!DOMUtilities.isValidPrefix(string)) {
            throw this.createDOMException((short)14, "prefix", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), string});
        }
        if (string.equals("xml") && !"http://www.w3.org/XML/1998/namespace".equals(string2) || string.equals("xmlns") && !"http://www.w3.org/2000/xmlns/".equals(string2)) {
            throw this.createDOMException((short)14, "namespace.uri", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), string2});
        }
        this.setNodeName(string + ":" + string3);
    }

    public String getLocalName() {
        return this.getNamespaceURI() == null ? null : DOMUtilities.getLocalName(this.getNodeName());
    }

    public DOMException createDOMException(short s, String string, Object[] objectArray) {
        try {
            return new DOMException(s, this.getCurrentDocument().formatMessage(string, objectArray));
        }
        catch (Exception exception) {
            return new DOMException(s, string);
        }
    }

    public void addEventListener(String string, EventListener eventListener, boolean bl) {
        if (this.eventSupport == null) {
            this.eventSupport = new EventSupport();
            this.getCurrentDocument().setEventsEnabled(true);
        }
        this.eventSupport.addEventListener(string, eventListener, bl);
    }

    public void removeEventListener(String string, EventListener eventListener, boolean bl) {
        if (this.eventSupport != null) {
            this.eventSupport.removeEventListener(string, eventListener, bl);
        }
    }

    public NodeEventTarget getParentNodeEventTarget() {
        return (NodeEventTarget)((Object)this.getParentNode());
    }

    public boolean dispatchEvent(Event event) throws EventException {
        return EventSupport.dispatchEvent(this, event);
    }

    public EventSupport getEventSupport() {
        return this.eventSupport;
    }

    public void fireDOMNodeInsertedIntoDocumentEvent() {
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument.getEventsEnabled()) {
            AbstractDocument abstractDocument2 = abstractDocument;
            MutationEvent mutationEvent = (MutationEvent)abstractDocument2.createEvent("MutationEvents");
            mutationEvent.initMutationEvent("DOMNodeInsertedIntoDocument", true, false, null, null, null, null, (short)2);
            this.dispatchEvent(mutationEvent);
        }
    }

    public void fireDOMNodeRemovedFromDocumentEvent() {
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument.getEventsEnabled()) {
            AbstractDocument abstractDocument2 = abstractDocument;
            MutationEvent mutationEvent = (MutationEvent)abstractDocument2.createEvent("MutationEvents");
            mutationEvent.initMutationEvent("DOMNodeRemovedFromDocument", true, false, null, null, null, null, (short)3);
            this.dispatchEvent(mutationEvent);
        }
    }

    protected void fireDOMCharacterDataModifiedEvent(String string, String string2) {
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument.getEventsEnabled()) {
            AbstractDocument abstractDocument2 = abstractDocument;
            MutationEvent mutationEvent = (MutationEvent)abstractDocument2.createEvent("MutationEvents");
            mutationEvent.initMutationEvent("DOMCharacterDataModified", true, false, null, string, string2, null, (short)1);
            this.dispatchEvent(mutationEvent);
        }
    }

    protected AbstractDocument getCurrentDocument() {
        return this.ownerDocument;
    }

    protected abstract Node newNode();

    protected Node export(Node node, AbstractDocument abstractDocument) {
        AbstractNode abstractNode = (AbstractNode)node;
        abstractNode.ownerDocument = abstractDocument;
        abstractNode.setReadonly(false);
        return node;
    }

    protected Node deepExport(Node node, AbstractDocument abstractDocument) {
        AbstractNode abstractNode = (AbstractNode)node;
        abstractNode.ownerDocument = abstractDocument;
        abstractNode.setReadonly(false);
        return node;
    }

    protected Node copyInto(Node node) {
        AbstractNode abstractNode = (AbstractNode)node;
        abstractNode.ownerDocument = this.ownerDocument;
        return node;
    }

    protected Node deepCopyInto(Node node) {
        AbstractNode abstractNode = (AbstractNode)node;
        abstractNode.ownerDocument = this.ownerDocument;
        return node;
    }

    protected void checkChildType(Node node) {
        throw this.createDOMException((short)3, "children.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    public abstract void setReadonly(boolean var1);

    public abstract boolean isReadonly();

    public abstract short getNodeType();

    public abstract String getNodeName();
}

