/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ckm.soap;

import com.trs.ckm.soap.CkmSoapException;
import com.trs.ckm.soap.PTools;
import com.trs.ckm.soap.RuleCATClass;
import com.trs.ckm.soap.RuleCATRule;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class RuleCATModel {
    private Hashtable m_hClass = new Hashtable();
    private Hashtable m_hWordsFrq = new Hashtable();

    public int setWordsFrq(int _iWords, int _iFrq) {
        this.m_hWordsFrq.put(String.valueOf(_iWords), String.valueOf(_iFrq));
        return 0;
    }

    public int getWordsFrq(int _iWords) {
        String sRet = (String)this.m_hWordsFrq.get(String.valueOf(_iWords));
        if (sRet != null) {
            return Integer.parseInt(sRet);
        }
        return 0;
    }

    public int delWordsFrq(int _iWords) {
        this.m_hWordsFrq.remove(String.valueOf(_iWords));
        return 0;
    }

    public int[] getAllWords() {
        if (this.m_hWordsFrq == null || this.m_hWordsFrq.size() == 0) {
            return null;
        }
        int iWords = 0;
        int[] aWords = new int[this.m_hWordsFrq.size()];
        Enumeration emWords = this.m_hWordsFrq.keys();
        while (emWords.hasMoreElements()) {
            String sWord = (String)emWords.nextElement();
            aWords[iWords++] = Integer.parseInt(sWord);
        }
        return aWords;
    }

    public int addClass(String _sClass, RuleCATClass _tClass) {
        if (_tClass.getName() == null) {
            _tClass.setName(_sClass);
        }
        this.m_hClass.put(_sClass, _tClass);
        return 0;
    }

    public int modClass(String _sClass, RuleCATClass _tClass) {
        return this.addClass(_sClass, _tClass);
    }

    public int delClass(String _sClass) {
        this.m_hClass.remove(_sClass);
        return 0;
    }

    public RuleCATClass[] getAllClasses() {
        if (this.m_hClass == null || this.m_hClass.size() == 0) {
            return null;
        }
        int iClass = 0;
        RuleCATClass[] aClass = new RuleCATClass[this.m_hClass.size()];
        Enumeration emRule = this.m_hClass.keys();
        while (emRule.hasMoreElements()) {
            String sClass = (String)emRule.nextElement();
            aClass[iClass++] = (RuleCATClass)this.m_hClass.get(sClass);
        }
        return aClass;
    }

    public RuleCATModel loadFromDir(String _sDirPath) throws CkmSoapException {
        String sLine;
        InputStreamReader fis = null;
        BufferedReader isr = null;
        this.m_hClass.clear();
        this.m_hWordsFrq.clear();
        try {
            try {
                fis = new FileReader(String.valueOf(_sDirPath) + "/\u5b57\u6570.txt");
                isr = new BufferedReader(fis);
                while ((sLine = isr.readLine()) != null) {
                    int iPos = sLine.indexOf(32);
                    if (iPos == -1) continue;
                    String sWords = sLine.substring(0, iPos);
                    String sFrq = sLine.substring(iPos + 1);
                    int iWords = Integer.parseInt(sWords);
                    int iFrq = Integer.parseInt(sFrq);
                    this.setWordsFrq(iWords, iFrq);
                }
            }
            catch (Exception ex) {
                throw new CkmSoapException(ex);
            }
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        try {
            try {
                fis = new FileReader(String.valueOf(_sDirPath) + "/\u7c7b\u522b.lst");
                isr = new BufferedReader(fis);
                while ((sLine = isr.readLine()) != null) {
                    if (sLine.length() <= 0) continue;
                    this.addClass(sLine, new RuleCATClass(sLine));
                }
            }
            catch (Exception ex) {
                throw new CkmSoapException(ex);
            }
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception sFrq) {}
        }
        RuleCATClass[] aClasses = this.getAllClasses();
        if (aClasses == null) {
            throw new CkmSoapException("\u4e0d\u542b\u4efb\u4f55\u5206\u7c7b\u4fe1\u606f");
        }
        int i = 0;
        while (i < aClasses.length) {
            try {
                try {
                    fis = new FileReader(String.valueOf(_sDirPath) + "/" + aClasses[i].getName() + ".rul");
                    isr = new BufferedReader(fis);
                    while ((sLine = isr.readLine()) != null) {
                        if (sLine.length() <= 0) continue;
                        aClasses[i].addRule(sLine, new RuleCATRule(sLine, sLine));
                    }
                }
                catch (Exception ex) {
                    throw new CkmSoapException(ex);
                }
            }
            finally {
                try {
                    if (isr != null) {
                        isr.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        return this;
    }

    public int saveToDir(String _sDirPath) throws CkmSoapException {
        int i;
        OutputStreamWriter fos = null;
        BufferedWriter osw = null;
        if (_sDirPath == null) {
            throw new CkmSoapException("\u53c2\u6570\u4e3a\u7a7a");
        }
        RuleCATClass[] aClasses = this.getAllClasses();
        int[] aWords = this.getAllWords();
        if (aClasses == null || aWords == null) {
            throw new CkmSoapException("\u8be5\u6a21\u677f\u4e0d\u542b\u4efb\u4f55\u5206\u7c7b\u6216\u6ca1\u6709\u8bbe\u7f6e\u5b57\u6570/\u8bcd\u9891\u9650\u5236");
        }
        PTools.createDir(true, _sDirPath);
        if (aWords != null) {
            try {
                try {
                    fos = new FileWriter(String.valueOf(_sDirPath) + "/\u5b57\u6570.txt");
                    osw = new BufferedWriter(fos);
                    i = 0;
                    while (i < aWords.length) {
                        osw.write(String.valueOf(aWords[i]) + " " + String.valueOf(this.getWordsFrq(aWords[i])) + "\n");
                        ++i;
                    }
                }
                catch (Exception ex) {
                    throw new CkmSoapException(ex);
                }
            }
            finally {
                try {
                    if (osw != null) {
                        osw.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        try {
            try {
                fos = new FileWriter(String.valueOf(_sDirPath) + "/\u7c7b\u522b.lst");
                osw = new BufferedWriter(fos);
                i = 0;
                while (i < aClasses.length) {
                    PTools.createDir(false, String.valueOf(_sDirPath) + "/" + aClasses[i].getName());
                    osw.write(String.valueOf(aClasses[i].getName()) + "\n");
                    ++i;
                }
            }
            catch (Exception ex) {
                throw new CkmSoapException(ex);
            }
        }
        finally {
            try {
                if (osw != null) {
                    osw.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
        i = 0;
        while (i < aClasses.length) {
            try {
                try {
                    fos = new FileWriter(String.valueOf(_sDirPath) + "/" + aClasses[i].getName() + ".rul");
                    osw = new BufferedWriter(fos);
                    RuleCATRule[] aRules = aClasses[i].getAllRules();
                    if (aRules != null) {
                        int j = 0;
                        while (j < aRules.length) {
                            String sContent = aRules[j].getContent();
                            if (sContent != null) {
                                osw.write(String.valueOf(sContent) + "\n");
                            }
                            ++j;
                        }
                    }
                }
                catch (Exception ex) {
                    throw new CkmSoapException(ex);
                }
            }
            finally {
                try {
                    if (osw != null) {
                        osw.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        try {
            PTools.copyFile(String.valueOf(_sDirPath) + "/\u5b57\u6570.txt", String.valueOf(_sDirPath) + "/words.txt");
            PTools.copyFile(String.valueOf(_sDirPath) + "/\u7c7b\u522b.lst", String.valueOf(_sDirPath) + "/total.lst");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }
}

