/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.scanners;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLReader;
import org.htmlparser.scanners.HTMLImageScanner;
import org.htmlparser.scanners.HTMLInputTagScanner;
import org.htmlparser.scanners.HTMLLinkScanner;
import org.htmlparser.scanners.HTMLOptionTagScanner;
import org.htmlparser.scanners.HTMLSelectTagScanner;
import org.htmlparser.scanners.HTMLTagScanner;
import org.htmlparser.scanners.HTMLTextareaTagScanner;
import org.htmlparser.tags.HTMLEndTag;
import org.htmlparser.tags.HTMLFormTag;
import org.htmlparser.tags.HTMLInputTag;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.tags.HTMLTextareaTag;
import org.htmlparser.util.HTMLLinkProcessor;
import org.htmlparser.util.HTMLParserException;

public class HTMLFormScanner
extends HTMLTagScanner {
    public static final String PREVIOUS_DIRTY_LINK_MESSAGE = "Encountered a form tag after an open link tag.\nThere should have been an end tag for the link before the form tag began.\nCorrecting this..";
    private Vector textAreaVector;
    private boolean linkScannerAlreadyOpen = false;

    public HTMLFormScanner() {
    }

    public HTMLFormScanner(String filter) {
        super(filter);
    }

    public String extractFormLocn(HTMLTag tag, String url) throws HTMLParserException {
        try {
            String formURL = tag.getParameter("ACTION");
            if (formURL == null) {
                String string = "";
                return string;
            }
            String string = new HTMLLinkProcessor().extract(formURL, url);
            return string;
        }
        catch (Exception e) {
            String msg = tag != null ? tag.getText() : "";
            throw new HTMLParserException(String.valueOf(String.valueOf(new StringBuffer("HTMLFormScanner.extractFormLocn() : Error in extracting form location, tag = ").append(msg).append(", url = ").append(url))), e);
        }
    }

    public String extractFormName(HTMLTag tag) {
        return tag.getParameter("NAME");
    }

    public String extractFormMethod(HTMLTag tag) {
        String method = tag.getParameter("METHOD");
        if (method == null) {
            method = "GET";
        }
        return method.toUpperCase();
    }

    public HTMLTag scan(HTMLTag tag, String url, HTMLReader reader, String currentLine) throws HTMLParserException {
        if (this.linkScannerAlreadyOpen) {
            String newLine = this.insertEndTagBeforeNode(tag, currentLine);
            reader.changeLine(newLine);
            return new HTMLEndTag(tag.elementBegin(), tag.elementBegin() + 3, "A", currentLine, tag.getLine());
        }
        try {
            HTMLFormTag formTag;
            HTMLNode node;
            Vector<HTMLNode> inputVector = new Vector<HTMLNode>();
            Vector<HTMLNode> textAreaVector = new Vector<HTMLNode>();
            Vector<HTMLNode> nodeVector = new Vector<HTMLNode>();
            String name = "";
            String method = "GET";
            int linkBegin = -1;
            int linkEnd = -1;
            String link = this.extractFormLocn(tag, url);
            name = this.extractFormName(tag);
            method = this.extractFormMethod(tag);
            linkBegin = tag.elementBegin();
            boolean endFlag = false;
            nodeVector.addElement(tag);
            HTMLLinkScanner linkScanner = (HTMLLinkScanner)reader.getParser().getScanner("A");
            HTMLImageScanner imageScanner = (HTMLImageScanner)reader.getParser().getScanner("IMG");
            Hashtable oldScanners = HTMLTagScanner.adjustScanners(reader);
            reader.getParser().addScanner(new HTMLInputTagScanner(""));
            reader.getParser().addScanner(new HTMLSelectTagScanner(""));
            reader.getParser().addScanner(new HTMLOptionTagScanner(""));
            reader.getParser().addScanner(new HTMLTextareaTagScanner(""));
            reader.getParser().addScanner(linkScanner);
            reader.getParser().addScanner(imageScanner);
            do {
                if ((node = reader.readElement()) instanceof HTMLEndTag) {
                    HTMLEndTag endTag = (HTMLEndTag)node;
                    if (endTag.getText().toUpperCase().equals("FORM")) {
                        endFlag = true;
                        linkEnd = endTag.elementEnd();
                    }
                } else if (node instanceof HTMLInputTag) {
                    inputVector.addElement(node);
                } else if (node instanceof HTMLTextareaTag) {
                    textAreaVector.addElement(node);
                }
                nodeVector.addElement(node);
            } while (!endFlag && node != null);
            HTMLTagScanner.restoreScanners(reader, oldScanners);
            if (node == null && !endFlag) {
                StringBuffer msg = new StringBuffer();
                Enumeration e = inputVector.elements();
                while (e.hasMoreElements()) {
                    msg.append(String.valueOf(String.valueOf((HTMLNode)e.nextElement())).concat("\n"));
                }
                throw new HTMLParserException("HTMLFormScanner.scan() : Went into a potential infinite loop - tags must be malformed.\nInput Vector contents : ".concat(String.valueOf(String.valueOf(msg.toString()))));
            }
            HTMLFormTag hTMLFormTag = formTag = new HTMLFormTag(link, name, method, linkBegin, linkEnd, currentLine, inputVector, textAreaVector, nodeVector, tag.getLine());
            return hTMLFormTag;
        }
        catch (Exception e) {
            throw new HTMLParserException("HTMLFormScanner.scan() : Error while scanning the form tag, current line = ".concat(String.valueOf(String.valueOf(currentLine))), e);
        }
    }

    public String[] getID() {
        String[] ids = new String[]{"FORM"};
        return ids;
    }

    public boolean evaluate(String s, HTMLTagScanner previousOpenScanner) {
        if (previousOpenScanner instanceof HTMLLinkScanner) {
            this.linkScannerAlreadyOpen = true;
            StringBuffer msg = new StringBuffer();
            msg.append("<");
            msg.append(s);
            msg.append(">");
            msg.append(PREVIOUS_DIRTY_LINK_MESSAGE);
            this.feedback.warning(msg.toString());
        } else {
            this.linkScannerAlreadyOpen = false;
        }
        return super.evaluate(s, previousOpenScanner);
    }

    static {
        PREVIOUS_DIRTY_LINK_MESSAGE = PREVIOUS_DIRTY_LINK_MESSAGE;
    }
}

