/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dl.util;

import com.trs.dl.util.CloseUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class FilesUtil {
    public static String checkPathExistAnd2NativeForm(String path) {
        try {
            return FilesUtil.assertPathExistAnd2NativeForm(path);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static String assertPathExistAnd2NativeForm(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null!");
        }
        File f = new File(path);
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        throw new IllegalArgumentException("the path [" + path + "] not exist!");
    }

    public static String getFileExtension(File f) {
        if (f == null) {
            throw new NullPointerException("the file object is null!");
        }
        String filename = f.getName();
        int lastDotPosition = filename.lastIndexOf(46);
        if (lastDotPosition == -1) {
            return null;
        }
        return filename.substring(lastDotPosition + 1);
    }

    public static String getFileNameWithoutExt(File f) {
        if (f == null) {
            throw new NullPointerException("the file object is null!");
        }
        String filename = f.getName();
        int lastDotPosition = filename.lastIndexOf(46);
        if (lastDotPosition == -1) {
            return filename;
        }
        return filename.substring(0, lastDotPosition);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFileUsingBinaryMode(File fSrc, File fDst) throws IOException {
        if (fSrc == null) throw new IllegalArgumentException("the file object is null!");
        if (fDst == null) {
            throw new IllegalArgumentException("the file object is null!");
        }
        if (!fSrc.isFile()) {
            throw new IllegalArgumentException("the fSrc [ " + fSrc + " ] is NOT a file!");
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        int BUF_SIZE = 4096;
        int len = 0;
        byte[] buf = new byte[4096];
        try {
            fis = new FileInputStream(fSrc);
            fos = new FileOutputStream(fDst);
            bis = new BufferedInputStream(fis, 4096);
            bos = new BufferedOutputStream(fos, 4096);
            while ((len = bis.read(buf)) > 0) {
                bos.write(buf, 0, len);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            CloseUtil.closeOutputStream(bos);
            CloseUtil.closeOutputStream(fos);
            CloseUtil.closeInputStream(bis);
            CloseUtil.closeInputStream(fis);
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        CloseUtil.closeOutputStream(bos);
        CloseUtil.closeOutputStream(fos);
        CloseUtil.closeInputStream(bis);
        CloseUtil.closeInputStream(fis);
    }

    public static String loadFirstLine(File file, String charsetName) throws IOException {
        String string;
        if (file == null || !file.isFile()) {
            throw new IllegalArgumentException("the file [ " + file + " ] is NOT a file!");
        }
        if (file.length() > 32767L) {
            throw new IllegalArgumentException("the file too large! size(in bytes): " + file.length());
        }
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = new InputStreamReader((InputStream)new FileInputStream(file), charsetName);
            br = new BufferedReader(isr);
            string = br.readLine();
            Object var5_5 = null;
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                CloseUtil.closeReader(br);
                CloseUtil.closeReader(isr);
                throw throwable;
            }
        }
        CloseUtil.closeReader(br);
        CloseUtil.closeReader(isr);
        return string;
    }
}

