/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dl.util;

public class Duration {
    public static final int UNIT_AS_MS = 1;
    public static final int UNIT_AS_SECOND = 10;
    private int msEstimated;
    private int secEstimated;

    public Duration(int estimated) {
        this.init(estimated, 10);
    }

    public Duration(String sEstimated) {
        if (sEstimated == null || sEstimated.trim().length() == 0) {
            throw new IllegalArgumentException("the string: [" + sEstimated + "] cannot convert to a integer!");
        }
        int estimated = Integer.parseInt(sEstimated);
        this.init(estimated, 10);
    }

    public Duration(int estimated, int unit) {
        this.init(estimated, unit);
    }

    private void init(int estimated, int unit) {
        if (estimated < 0) {
            throw new IllegalArgumentException("the integer: " + estimated + " not a positive number!");
        }
        switch (unit) {
            case 1: {
                this.msEstimated = estimated;
                this.secEstimated = estimated / 1000;
                break;
            }
            case 10: {
                this.msEstimated = estimated * 1000;
                this.secEstimated = estimated;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupport unit: " + unit);
            }
        }
    }

    public String defaultShow() {
        int nHour = this.secEstimated / 3600;
        int nMin = (this.secEstimated - nHour * 3600) / 60;
        int nSec = this.secEstimated - nHour * 3600 - nMin * 60;
        StringBuffer sb = new StringBuffer();
        if (nHour > 0) {
            sb.append(nHour > 9 ? String.valueOf(nHour) : "0" + nHour).append(":");
        }
        sb.append(nMin > 9 ? String.valueOf(nMin) : "0" + nMin).append(":");
        sb.append(nSec > 9 ? String.valueOf(nSec) : "0" + nSec);
        return sb.toString();
    }

    public String hmsShow() {
        int nHour = this.secEstimated / 3600;
        int nMin = (this.secEstimated - nHour * 3600) / 60;
        int nSec = this.secEstimated - nHour * 3600 - nMin * 60;
        StringBuffer sb = new StringBuffer();
        sb.append(nHour > 9 ? String.valueOf(nHour) : "0" + nHour).append(":");
        sb.append(nMin > 9 ? String.valueOf(nMin) : "0" + nMin).append(":");
        sb.append(nSec > 9 ? String.valueOf(nSec) : "0" + nSec);
        return sb.toString();
    }

    public int getMsEstimated() {
        return this.msEstimated;
    }

    public int getSecEstimated() {
        return this.secEstimated;
    }
}

