/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.verifycode;

import com.trs.dev4.verifycode.VerifyCodeGenerator;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class MixVerifyCodeServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG;
    private int torsionResistance;
    private int noiseLevel;
    private int length;
    private int pictureWidth;
    private int pictureHeight;
    private String verifyCodeType;
    private int fontSize;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.dev4.verifycode.MixVerifyCodeServlet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String torsionResistanceStrTag = config.getInitParameter("torsionResistance");
        this.torsionResistance = this.getTorsionResistance(torsionResistanceStrTag);
        String noiseLevelStrTag = config.getInitParameter("noiseLevel");
        this.noiseLevel = this.getNoiseLevel(noiseLevelStrTag);
        String fontSizeStr = config.getInitParameter("fontSize");
        this.fontSize = this.getFontSize(fontSizeStr);
        String lengthStr = config.getInitParameter("length");
        this.length = this.getLength(lengthStr);
        String pictureWidthStr = config.getInitParameter("pictureWidth");
        this.pictureWidth = this.getPictureWidth(pictureWidthStr);
        String pictureHeightStr = config.getInitParameter("pictureHeight");
        this.pictureHeight = this.getPictureHeight(pictureHeightStr);
        this.verifyCodeType = config.getInitParameter("verifyCodeType");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MixVerifyCodeServlet initing finished\uff01torsionResistance=[" + this.torsionResistance + "],noiseLevel=[" + this.noiseLevel + "],length=[" + this.length + "],content=[" + this.verifyCodeType + "]"));
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("image/jpeg");
        VerifyCodeGenerator vcg = new VerifyCodeGenerator(this.pictureHeight, this.pictureWidth);
        Serializable verifyCode = vcg.generateVerifyCode(this.length, this.verifyCodeType);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("verifyCode=[" + verifyCode + "]"));
        }
        req.getSession().setAttribute("verifyCode", (Object)verifyCode.toString());
        vcg.drawVerifyCodeToPicture(req, resp, verifyCode, this.noiseLevel, this.torsionResistance, this.fontSize);
    }

    private int getTorsionResistance(String torsionResistance) {
        if (torsionResistance == null || "".equals(torsionResistance)) {
            return 10;
        }
        if ("high".equals(torsionResistance)) {
            return 30;
        }
        if ("mid".equals(torsionResistance)) {
            return 20;
        }
        if ("low".equals(torsionResistance)) {
            return 10;
        }
        return 10;
    }

    private int getNoiseLevel(String noiseLevel) {
        if (noiseLevel == null || "".equals(noiseLevel)) {
            return 400;
        }
        if ("high".equals(noiseLevel)) {
            return 1000;
        }
        if ("mid".equals(noiseLevel)) {
            return 600;
        }
        if ("low".equals(noiseLevel)) {
            return 400;
        }
        return 400;
    }

    private int getLength(String length) {
        if (length == null || "".equals(length)) {
            return 4;
        }
        int lengthInt = new Integer(length);
        if (lengthInt > 3 && lengthInt < 10) {
            return lengthInt;
        }
        return 4;
    }

    private int getPictureWidth(String pictureWidth) {
        if (pictureWidth == null || "".equals(pictureWidth)) {
            return 195;
        }
        int pictureWidthInt = new Integer(pictureWidth);
        if (pictureWidthInt > 195 || pictureWidthInt < 80) {
            return 195;
        }
        return pictureWidthInt;
    }

    private int getPictureHeight(String pictureHeight) {
        if (pictureHeight == null || "".equals(pictureHeight)) {
            return 80;
        }
        int pictureHeightInt = new Integer(pictureHeight);
        if (pictureHeightInt > 80 || pictureHeightInt < 40) {
            return 80;
        }
        return pictureHeightInt;
    }

    private int getFontSize(String fontSize) {
        if (fontSize == null || "".equals(fontSize)) {
            return 27;
        }
        return new Integer(fontSize);
    }
}

