/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.license;

import com.trs.dev4.exception.LicenseException;
import com.trs.dev4.license.IKeyHolder;
import com.trs.dev4.license.IKeyVerifier;
import com.trs.dev4.license.ILicenseKey;
import com.trs.dev4.license.LicenseInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VerifyManager {
    private Map verifiers = new HashMap();
    private Map finders = new HashMap();
    private IKeyVerifier primaryKeyVerifier;
    private IKeyHolder primaryKeyHolder;

    public LicenseInfo verify() {
        ILicenseKey key = this.findKey();
        return this.verifyKey(key);
    }

    public void writeKey(String licenseCode) {
        if (this.primaryKeyHolder == null) {
            throw new LicenseException("No primary KeyHolder.");
        }
        ILicenseKey key = this.primaryKeyHolder.loadToKey(licenseCode);
        this.verifyKey(key);
        this.primaryKeyHolder.writeKey(licenseCode);
    }

    private ILicenseKey findKey() {
        ILicenseKey key;
        if (this.primaryKeyHolder != null && (key = this.primaryKeyHolder.findKey()) != null) {
            return key;
        }
        Iterator iter = this.finders.keySet().iterator();
        while (iter.hasNext()) {
            IKeyHolder finder = (IKeyHolder)this.finders.get(iter.next());
            ILicenseKey key2 = finder.findKey();
            if (key2 == null) continue;
            return key2;
        }
        throw new LicenseException("Not found any key!");
    }

    LicenseInfo verifyKey(ILicenseKey key) {
        if (this.verifiers.size() == 0) {
            throw new LicenseException("No any of IKeyVerifier!");
        }
        IKeyVerifier propVerifier = this.attemptFindProperKeyVerifier(key);
        if (propVerifier != null) {
            return propVerifier.verify(key);
        }
        Iterator iter = this.verifiers.keySet().iterator();
        while (iter.hasNext()) {
            IKeyVerifier verifier = (IKeyVerifier)this.verifiers.get(iter.next());
            LicenseInfo ll = verifier.verify(key);
            if (!ll.isValid()) continue;
            return ll;
        }
        throw new LicenseException("Invalid License!");
    }

    IKeyVerifier attemptFindProperKeyVerifier(ILicenseKey key) {
        Iterator iter = this.verifiers.keySet().iterator();
        while (iter.hasNext()) {
            IKeyVerifier verifier = (IKeyVerifier)this.verifiers.get(iter.next());
            if (!verifier.canVerify(key)) continue;
            return verifier;
        }
        return null;
    }

    public void registerKeyVerifier(IKeyVerifier verifier) {
        if (verifier == null) {
            return;
        }
        this.verifiers.put(verifier.getClass(), verifier);
    }

    public void registerPrimaryKeyVerifier(IKeyVerifier verifier) {
        this.primaryKeyVerifier = verifier;
        this.registerKeyVerifier(verifier);
    }

    public void registerPrimaryKeyFinder(IKeyHolder keyFinder) {
        this.primaryKeyHolder = keyFinder;
    }

    public void registerKeyFinder(IKeyHolder keyFinder) {
        if (keyFinder == null) {
            return;
        }
        this.finders.put(keyFinder.getClass(), keyFinder);
    }

    public boolean containsVerifier(IKeyVerifier verifier) {
        if (verifier == null) {
            return false;
        }
        return this.verifiers.containsKey(verifier.getClass());
    }

    public String generateMachineCode() {
        if (this.primaryKeyVerifier == null) {
            throw new LicenseException("No primary KeyVerifier.");
        }
        return this.primaryKeyVerifier.generateMachineCode();
    }

    public boolean isValidMachineCode(String machineCode) {
        Iterator iter = this.verifiers.keySet().iterator();
        while (iter.hasNext()) {
            IKeyVerifier verifier = (IKeyVerifier)this.verifiers.get(iter.next());
            if (!verifier.isValidMachineCode(machineCode)) continue;
            return true;
        }
        return false;
    }

    public List listKeyVeriferClass() {
        ArrayList<IKeyVerifier> list = new ArrayList<IKeyVerifier>();
        list.add(this.primaryKeyVerifier);
        list.addAll(this.verifiers.keySet());
        return list;
    }

    public List listKeyFinderClass() {
        ArrayList<IKeyHolder> list = new ArrayList<IKeyHolder>();
        list.add(this.primaryKeyHolder);
        list.addAll(this.finders.keySet());
        return list;
    }

    public void start() {
    }

    public void stop() {
        this.verifiers.clear();
    }

    public IKeyVerifier getPrimaryKeyVerifier() {
        return this.primaryKeyVerifier;
    }

    public IKeyHolder getPrimaryKeyFinder() {
        return this.primaryKeyHolder;
    }
}

