/*
 * Decompiled with CFR 0.152.
 */
package trs.org.objectweb.asm.util;

import trs.org.objectweb.asm.AnnotationVisitor;
import trs.org.objectweb.asm.Type;
import trs.org.objectweb.asm.util.TraceAbstractVisitor;

public class TraceAnnotationVisitor
extends TraceAbstractVisitor
implements AnnotationVisitor {
    protected AnnotationVisitor av;
    private int valueNumber = 0;

    public void visit(String name, Object value) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (name != null) {
            this.buf.append(name).append('=');
        }
        if (value instanceof String) {
            this.visitString((String)value);
        } else if (value instanceof Type) {
            this.visitType((Type)value);
        } else if (value instanceof Byte) {
            this.visitByte((Byte)value);
        } else if (value instanceof Boolean) {
            this.visitBoolean((Boolean)value);
        } else if (value instanceof Short) {
            this.visitShort((Short)value);
        } else if (value instanceof Character) {
            this.visitChar(((Character)value).charValue());
        } else if (value instanceof Integer) {
            this.visitInt((Integer)value);
        } else if (value instanceof Float) {
            this.visitFloat(((Float)value).floatValue());
        } else if (value instanceof Long) {
            this.visitLong((Long)value);
        } else if (value instanceof Double) {
            this.visitDouble((Double)value);
        } else if (value.getClass().isArray()) {
            this.buf.append('{');
            if (value instanceof byte[]) {
                byte[] v = (byte[])value;
                int i = 0;
                while (i < v.length) {
                    this.appendComa(i);
                    this.visitByte(v[i]);
                    ++i;
                }
            } else if (value instanceof boolean[]) {
                boolean[] v = (boolean[])value;
                int i = 0;
                while (i < v.length) {
                    this.appendComa(i);
                    this.visitBoolean(v[i]);
                    ++i;
                }
            } else if (value instanceof short[]) {
                short[] v = (short[])value;
                int i = 0;
                while (i < v.length) {
                    this.appendComa(i);
                    this.visitShort(v[i]);
                    ++i;
                }
            } else if (value instanceof char[]) {
                char[] v = (char[])value;
                int i = 0;
                while (i < v.length) {
                    this.appendComa(i);
                    this.visitChar(v[i]);
                    ++i;
                }
            } else if (value instanceof int[]) {
                int[] v = (int[])value;
                int i = 0;
                while (i < v.length) {
                    this.appendComa(i);
                    this.visitInt(v[i]);
                    ++i;
                }
            } else if (value instanceof long[]) {
                long[] v = (long[])value;
                int i = 0;
                while (i < v.length) {
                    this.appendComa(i);
                    this.visitLong(v[i]);
                    ++i;
                }
            } else if (value instanceof float[]) {
                float[] v = (float[])value;
                int i = 0;
                while (i < v.length) {
                    this.appendComa(i);
                    this.visitFloat(v[i]);
                    ++i;
                }
            } else if (value instanceof double[]) {
                double[] v = (double[])value;
                int i = 0;
                while (i < v.length) {
                    this.appendComa(i);
                    this.visitDouble(v[i]);
                    ++i;
                }
            }
            this.buf.append('}');
        } else {
            this.buf.append(value);
        }
        this.text.add(this.buf.toString());
        if (this.av != null) {
            this.av.visit(name, value);
        }
    }

    private void visitInt(int value) {
        this.buf.append(value);
    }

    private void visitLong(long value) {
        this.buf.append(value).append('L');
    }

    private void visitFloat(float value) {
        this.buf.append(value).append('F');
    }

    private void visitDouble(double value) {
        this.buf.append(value).append('D');
    }

    private void visitChar(char value) {
        this.buf.append("(char)").append((int)value);
    }

    private void visitShort(short value) {
        this.buf.append("(short)").append(value);
    }

    private void visitByte(byte value) {
        this.buf.append("(byte)").append(value);
    }

    private void visitBoolean(boolean value) {
        this.buf.append(value);
    }

    private void visitString(String value) {
        TraceAnnotationVisitor.appendString(this.buf, value);
    }

    private void visitType(Type value) {
        this.buf.append(value.getClassName()).append(".class");
    }

    public void visitEnum(String name, String desc, String value) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (name != null) {
            this.buf.append(name).append('=');
        }
        this.appendDescriptor(1, desc);
        this.buf.append('.').append(value);
        this.text.add(this.buf.toString());
        if (this.av != null) {
            this.av.visitEnum(name, desc, value);
        }
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (name != null) {
            this.buf.append(name).append('=');
        }
        this.buf.append('@');
        this.appendDescriptor(1, desc);
        this.buf.append('(');
        this.text.add(this.buf.toString());
        TraceAnnotationVisitor tav = this.createTraceAnnotationVisitor();
        this.text.add(tav.getText());
        this.text.add(")");
        if (this.av != null) {
            tav.av = this.av.visitAnnotation(name, desc);
        }
        return tav;
    }

    public AnnotationVisitor visitArray(String name) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (name != null) {
            this.buf.append(name).append('=');
        }
        this.buf.append('{');
        this.text.add(this.buf.toString());
        TraceAnnotationVisitor tav = this.createTraceAnnotationVisitor();
        this.text.add(tav.getText());
        this.text.add("}");
        if (this.av != null) {
            tav.av = this.av.visitArray(name);
        }
        return tav;
    }

    public void visitEnd() {
        if (this.av != null) {
            this.av.visitEnd();
        }
    }

    protected TraceAnnotationVisitor createTraceAnnotationVisitor() {
        return new TraceAnnotationVisitor();
    }

    private void appendComa(int i) {
        if (i != 0) {
            this.buf.append(", ");
        }
    }
}

