/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.TdsCursor;
import com.sybase.jdbc2.tds.TdsDataOutputStream;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.tds.Token;
import java.io.IOException;
import java.sql.SQLException;

public class CurDeclareToken
extends Token {
    protected TdsCursor _cursor;
    protected String _query;
    protected int _nameLen;
    protected long _queryLen;
    protected int _colLen;

    protected CurDeclareToken() {
    }

    public CurDeclareToken(TdsCursor tdsCursor, String string) throws SQLException {
        this._query = string;
        this._cursor = tdsCursor;
    }

    protected String getTokenNameAsString() {
        return "CurDeclareToken";
    }

    public void send(TdsDataOutputStream tdsDataOutputStream) throws IOException {
        byte[] byArray;
        int n;
        int n2 = this._cursor._type;
        byte[] byArray2 = tdsDataOutputStream.stringToByte(this._cursor.getName());
        this._nameLen = byArray2.length;
        byte[] byArray3 = tdsDataOutputStream.stringToByte(this._query);
        this._queryLen = byArray3.length;
        this._colLen = 0;
        if (this._cursor._columns != null) {
            this._colLen = this._cursor._columns.length;
            n = 0;
            while (n < this._cursor._columns.length) {
                byArray = tdsDataOutputStream.stringToByte(this._cursor._columns[n]);
                this._colLen += byArray.length;
                ++n;
            }
        }
        try {
            this.sendTokenName(tdsDataOutputStream);
            this.sendTokenLength(tdsDataOutputStream);
            tdsDataOutputStream.writeByte(this._nameLen);
            tdsDataOutputStream.write(byArray2);
            tdsDataOutputStream.writeByte(n2);
            tdsDataOutputStream.writeByte(this._cursor._hasArgs);
            this.sendQueryLen(tdsDataOutputStream);
            tdsDataOutputStream.write(byArray3);
            if (this._cursor._columns != null) {
                this.sendNumColumns(tdsDataOutputStream, this._cursor._columns.length);
                n = 0;
                while (n < this._cursor._columns.length) {
                    byArray = tdsDataOutputStream.stringToByte(this._cursor._columns[n]);
                    int n3 = byArray.length;
                    tdsDataOutputStream.writeByte(n3);
                    tdsDataOutputStream.write(byArray);
                    ++n;
                }
            } else {
                this.sendNumColumns(tdsDataOutputStream, 0);
            }
        }
        catch (IOException iOException) {
            Token.writeSQE(iOException);
        }
    }

    protected void sendNumColumns(TdsOutputStream tdsOutputStream, int n) throws IOException {
        tdsOutputStream.writeByte(n);
    }

    protected void sendQueryLen(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeShort((int)this._queryLen);
    }

    protected void sendTokenLength(TdsOutputStream tdsOutputStream) throws IOException {
        long l = (long)(1 + this._nameLen + 1 + 1 + 2) + this._queryLen + 1L + (long)this._colLen;
        tdsOutputStream.writeShort((int)l);
    }

    protected void sendTokenName(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeByte(134);
    }
}

