/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.Convert;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.JdbcDataObject;
import com.sybase.jdbc2.jdbc.Param;
import com.sybase.jdbc2.jdbc.Protocol;
import com.sybase.jdbc2.jdbc.ProtocolContext;
import com.sybase.jdbc2.jdbc.SybStatement;
import com.sybase.jdbc2.tds.TdsNumeric;
import com.sybase.jdbc2.utils.CacheManager;
import com.sybase.jdbc2.utils.Cacheable;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.SQLException;

public class ParamManager
implements Cacheable {
    protected Param[] _params;
    protected int _next = -1;
    protected int _last = -1;
    private int _maxOutParam = -1;
    protected SybStatement _stmt;
    protected ProtocolContext _context;
    protected Protocol _protocol;
    protected CacheManager _stmtMgr;
    private CacheManager _mgr;
    private boolean _haveOutParam = false;
    private boolean _ignoreClear = false;
    private boolean _clearingParams = false;

    public ParamManager(int n, ProtocolContext protocolContext) throws SQLException {
        this._context = protocolContext;
        this._protocol = this._context._protocol;
        this._params = this._protocol.paramArray(n, this._mgr);
    }

    public ParamManager(int n, int[] nArray, SybStatement sybStatement) throws SQLException {
        this._stmt = sybStatement;
        this._context = sybStatement._context;
        this._stmtMgr = sybStatement._statementManager;
        this._protocol = this._context._protocol;
        this._params = this._protocol.paramArray(this._context, n);
        int n2 = 0;
        while (n2 < n) {
            this._params[n2]._paramMarkerOffset = nArray[n2];
            ++n2;
        }
        this._mgr = new CacheManager(this._context._is);
        boolean bl = this._context._conn._props.getBoolean(14);
        this._mgr.setReReadable(bl);
        int n3 = this._context._conn._props.getInteger(13);
        if (bl) {
            n3 = -1;
        }
        this._mgr.setCacheSize(n3);
        this._mgr.setChunkSize(256);
        this._mgr.setAbortOnCacheOverflow(true);
    }

    public void adjustOffsets(int n) {
        int n2 = 0;
        while (n2 < this._params.length) {
            this._params[n2]._paramMarkerOffset += n;
            ++n2;
        }
    }

    public void cache() throws IOException {
        if (this._ignoreClear) {
            return;
        }
        this._ignoreClear = true;
        this._mgr.register(this);
        this._mgr.open(this);
        this._mgr.doneReading();
        this._mgr.dead(this);
        this._ignoreClear = false;
        this._stmtMgr.doneReading();
    }

    private void checkIndex(int n) throws SQLException {
        if (n < 1 || n > this._params.length) {
            ErrorMessage.raiseError("JZ0SB", String.valueOf(n));
        }
    }

    public void checkParams(Protocol protocol, boolean bl) throws SQLException {
        int n = 0;
        while (n < this._params.length) {
            this._params[n].prepareForSend(protocol, n, bl);
            ++n;
        }
    }

    private void checkReceive() throws SQLException {
        if (this._next < 0) {
            ErrorMessage.raiseError("JZ0SF");
        }
    }

    private void checkType(int n) throws SQLException {
        switch (n) {
            default: {
                ErrorMessage.raiseError("JZ0SM", String.valueOf(n));
            }
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 2000: 
        }
    }

    public void clear() throws IOException {
        if (this._ignoreClear) {
            return;
        }
        try {
            try {
                if (this._haveOutParam) {
                    if (this._maxOutParam >= 0 && this._params[this._maxOutParam]._outValue == null) {
                        this.getOutValueAt(this._maxOutParam + 1);
                    }
                    if (!this._clearingParams) {
                        this.clearParams(false);
                    }
                }
                this._mgr.clear();
            }
            catch (SQLException sQLException) {
                ErrorMessage.raiseIOECheckDead(sQLException);
            }
            Object var2_2 = null;
            this._stmtMgr.dead(this);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this._stmtMgr.dead(this);
            throw throwable;
        }
    }

    protected synchronized void clearParamArray(boolean bl) throws IOException {
        int n = 0;
        if (this._params.length > 0 && this._params[0]._sqlType == -998) {
            n = 1;
            this._params[0].clear(false);
        }
        int n2 = n;
        while (n2 < this._params.length) {
            this._params[n2].clear(bl);
            ++n2;
        }
        this._next = -1;
        this._last = -1;
    }

    protected synchronized void clearParams(boolean bl) throws IOException {
        if (this._clearingParams) {
            return;
        }
        if (this._haveOutParam) {
            this._clearingParams = true;
            this._stmtMgr.open(this);
            this.cache();
            this._clearingParams = false;
            this._haveOutParam = false;
        }
        this.clearParamArray(bl);
        this._mgr.clear();
        this._mgr.allDead();
    }

    public ProtocolContext getContext() {
        return this._context;
    }

    public int getLength() {
        int n = 0;
        int n2 = 0;
        while (n2 < this._params.length) {
            n += this._params[n2].getLength();
            ++n2;
        }
        return n;
    }

    public int getNext() {
        return this._next;
    }

    public Object getOutObjectAt(int n) throws SQLException {
        Object object = null;
        JdbcDataObject jdbcDataObject = this.getOutValueAt(n);
        switch (this._params[--n]._regType) {
            case -6: 
            case 5: {
                object = Convert.objectToShort(jdbcDataObject.getObject());
                break;
            }
            case -5: {
                Object object2 = jdbcDataObject.getObject();
                if (object2 == null) {
                    object = null;
                    break;
                }
                if (object2 instanceof Integer) {
                    object = new Long(((Integer)object2).longValue());
                    break;
                }
                if (object2 instanceof BigDecimal) {
                    object = new Long(((BigDecimal)object2).longValue());
                    break;
                }
                if (!(object2 instanceof Long)) break;
                object = object2;
                break;
            }
            case 2: 
            case 3: {
                if (this._params[n]._scale == -999) break;
                object = jdbcDataObject.getBigDecimal(this._params[n]._scale);
                break;
            }
            case 6: {
                object = Convert.objectToFloat(jdbcDataObject.getObject());
                break;
            }
            case 91: {
                object = Convert.objectToDate(jdbcDataObject.getDateObject(91, null));
                break;
            }
            case 92: {
                object = Convert.objectToTime(jdbcDataObject.getDateObject(92, null));
                break;
            }
            case 93: {
                object = Convert.objectToTimestamp(jdbcDataObject.getDateObject(93, null));
                break;
            }
            default: {
                object = jdbcDataObject.getObject();
            }
        }
        return object;
    }

    public JdbcDataObject getOutValueAt(int n) throws SQLException {
        this.checkReceive();
        this.checkIndex(n);
        if (this._params[--n]._regType == -999 || this._stmt._hasReturn && n == 0 && !this._stmt._returnHasBeenRegistered) {
            ErrorMessage.raiseError("JZ0SB", String.valueOf(n));
        }
        while (this._params[n]._outValue == null) {
            this.nextOutParam();
            while (this._params[n]._outValue == null) {
                this.nextResult();
            }
        }
        this._last = n;
        return this._params[n]._outValue;
    }

    protected void getParameter() throws SQLException {
        this.checkReceive();
        this._protocol.param(this);
    }

    public Param[] getParams() {
        return this._params;
    }

    public int getState() {
        return 1;
    }

    public boolean hasInParams() {
        if (this._params.length == 0) {
            return false;
        }
        return this._params.length > 1 || this._params[0]._sqlType != -998;
    }

    protected void literalizeAll() {
        int n = 0;
        while (n < this._params.length) {
            this._params[n]._sendAsLiteral = true;
            ++n;
        }
    }

    public int makeFormats() throws IOException {
        int n = 0;
        int n2 = 0;
        while (n2 < this._params.length) {
            if (this._params[n2].makeFormat(this._protocol)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int nextOutParam() {
        if (this._next < this._params.length && this._params[this._next]._outValue != null) {
            ++this._next;
        }
        while (this._next < this._params.length && this._params[this._next]._regType == -999) {
            ++this._next;
        }
        return this._next;
    }

    private int nextResult() throws SQLException {
        int n = this._next;
        while (true) {
            try {
                block7: while (true) {
                    int n2 = this._stmt.nextResult();
                    switch (n2) {
                        default: {
                            continue block7;
                        }
                        case 3: {
                            return n2;
                        }
                        case 0: 
                    }
                    ErrorMessage.raiseError("JZ0SG");
                }
            }
            catch (SQLException sQLException) {
                this._stmt.handleSQLE(sQLException);
                continue;
            }
            break;
        }
    }

    public void open(boolean bl) {
    }

    public String processParamMarkers(String string) throws SQLException {
        if (this._params.length == 0) {
            return null;
        }
        int n = 0;
        if (this._params[n]._sqlType == -998) {
            ++n;
        }
        if (n == this._params.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        try {
            while (n < this._params.length) {
                if (this._params[n]._sqlType != -998) {
                    stringBuffer.append(string.substring(n2, this._params[n]._paramMarkerOffset));
                    stringBuffer.append(this._params[n].literalValue(this._protocol, n, this._context._maxFieldSize));
                    n2 = this._params[n]._paramMarkerOffset + 1;
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    public void registerParam(int n, int n2) throws SQLException {
        this.checkIndex(n);
        this.checkType(n2);
        if (--n > this._maxOutParam) {
            this._maxOutParam = n;
        }
        this._params[n]._regType = n2;
    }

    public void registerParam(int n, int n2, int n3) throws SQLException {
        this.registerParam(n, n2);
        this._params[n - 1]._scale = n3;
    }

    public void registerParam(int n, int n2, String string) throws SQLException {
        this.registerParam(n, n2);
        this._params[--n]._outParamClassName = string;
    }

    public void registerParam(Cacheable cacheable) throws SQLException {
        this.nextOutParam();
        try {
            this._haveOutParam = true;
            this._mgr.register(cacheable);
            this._mgr.open(cacheable);
            this._stmtMgr.register(this);
            this._stmtMgr.open(this);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    public void registerStatus(Cacheable cacheable) throws SQLException {
        if (this._params.length > 0 && this._params[0]._sqlType == -998) {
            this.registerParam(cacheable);
        } else {
            try {
                cacheable.clear();
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
        }
    }

    public void reset() throws IOException {
    }

    public void resetInputStream(InputStream inputStream) {
    }

    public void send(OutputStream outputStream) throws IOException, SQLException {
        this._next = 0;
        int n = 0;
        while (n < this._params.length) {
            this._params[n].send(outputStream, this._context._maxFieldSize);
            ++n;
        }
    }

    public void sendFormats(DataOutput dataOutput) throws IOException {
        int n = 0;
        while (n < this._params.length) {
            this._params[n].sendFormat(dataOutput);
            ++n;
        }
    }

    public void setManager(CacheManager cacheManager) {
    }

    public void setParam(int n, int n2, Object object, int n3) throws SQLException {
        this.checkIndex(n);
        Param param = this._params[--n];
        if (param._sqlType == -998) {
            ErrorMessage.raiseError("JZ0SC");
        }
        try {
            param.clear(false);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        switch (n2) {
            case 2: {
                if (!(object instanceof BigDecimal)) break;
                TdsNumeric.checkRange((BigDecimal)object, n3);
                break;
            }
        }
        param._sqlType = n2;
        param._inValue = object;
        param._scale = n3;
    }

    protected boolean wasNull() throws SQLException {
        this.checkReceive();
        if (this._last < 0 || this._params[this._last]._outValue == null) {
            ErrorMessage.raiseError("JZ0SD");
        }
        return this._params[this._last]._outValue.isNull();
    }
}

