/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ant;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.dbunit.DatabaseUnitException;
import org.dbunit.ant.DbUnitTaskStep;
import org.dbunit.ant.Query;
import org.dbunit.ant.Table;
import org.dbunit.database.CachedResultSetTableFactory;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.ForwardOnlyResultSetTableFactory;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.IResultSetTableFactory;
import org.dbunit.database.QueryDataSet;
import org.dbunit.dataset.CachedDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.csv.CsvProducer;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.dbunit.dataset.stream.StreamingDataSet;
import org.dbunit.dataset.xml.FlatDtdProducer;
import org.dbunit.dataset.xml.FlatXmlProducer;
import org.dbunit.dataset.xml.XmlProducer;
import org.xml.sax.InputSource;

public abstract class AbstractStep
implements DbUnitTaskStep {
    public static final String FORMAT_FLAT = "flat";
    public static final String FORMAT_XML = "xml";
    public static final String FORMAT_DTD = "dtd";
    public static final String FORMAT_CSV = "csv";

    protected IDataSet getDatabaseDataSet(IDatabaseConnection connection, List tables, boolean forwardonly) throws DatabaseUnitException {
        try {
            IResultSetTableFactory factory = null;
            factory = forwardonly ? new ForwardOnlyResultSetTableFactory() : new CachedResultSetTableFactory();
            DatabaseConfig config = connection.getConfig();
            config.setProperty("http://www.dbunit.org/properties/resultSetTableFactory", factory);
            if (tables.size() == 0) {
                return connection.createDataSet();
            }
            QueryDataSet queryDataset = new QueryDataSet(connection);
            Iterator it = tables.iterator();
            while (it.hasNext()) {
                Object item = it.next();
                if (item instanceof Query) {
                    Query queryItem = (Query)item;
                    queryDataset.addTable(queryItem.getName(), queryItem.getSql());
                    continue;
                }
                Table tableItem = (Table)item;
                queryDataset.addTable(tableItem.getName());
            }
            return queryDataset;
        }
        catch (SQLException e) {
            throw new DatabaseUnitException(e);
        }
    }

    protected IDataSet getSrcDataSet(File src, String format, boolean forwardonly) throws DatabaseUnitException {
        try {
            IDataSetProducer producer = null;
            if (format.equalsIgnoreCase(FORMAT_XML)) {
                producer = new XmlProducer(new InputSource(src.toURL().toString()));
            } else if (format.equalsIgnoreCase(FORMAT_CSV)) {
                producer = new CsvProducer(src);
            } else if (format.equalsIgnoreCase(FORMAT_FLAT)) {
                producer = new FlatXmlProducer(new InputSource(src.toURL().toString()));
            } else if (format.equalsIgnoreCase(FORMAT_DTD)) {
                producer = new FlatDtdProducer(new InputSource(src.toURL().toString()));
            } else {
                throw new IllegalArgumentException("Type must be either 'flat'(default), 'xml', 'csv' or 'dtd' but was: " + format);
            }
            if (forwardonly) {
                return new StreamingDataSet(producer);
            }
            return new CachedDataSet(producer);
        }
        catch (IOException e) {
            throw new DatabaseUnitException(e);
        }
    }

    public abstract /* synthetic */ String getLogMessage();

    public abstract /* synthetic */ void execute(IDatabaseConnection var1) throws DatabaseUnitException;
}

