/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.actions;

import java.util.Enumeration;
import java.util.Hashtable;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.actions.Action;
import org.xmlmiddleware.xmldbms.maps.ClassMap;
import org.xmlmiddleware.xmldbms.maps.XMLDBMSMap;
import org.xmlmiddleware.xmlutils.XMLName;

public class Actions {
    private Hashtable actions = new Hashtable();
    private XMLDBMSMap map;
    private Action defaultAction;

    public Actions(XMLDBMSMap xMLDBMSMap) {
        this.map = xMLDBMSMap;
    }

    public final Action getDefaultAction() {
        return this.defaultAction;
    }

    public void setDefaultAction(Action action) {
        this.defaultAction = action;
    }

    public final Action getAction(XMLName xMLName) {
        return (Action)this.actions.get(xMLName);
    }

    public final Action getAction(String string, String string2) {
        return (Action)this.actions.get(XMLName.create(string, string2));
    }

    public final Enumeration getActions() {
        return this.actions.elements();
    }

    public Action createAction(String string, String string2) throws XMLMiddlewareException {
        return this.createAction(XMLName.create(string, string2));
    }

    public Action createAction(XMLName xMLName) throws XMLMiddlewareException {
        if (xMLName == null) {
            throw new IllegalArgumentException("Element type name may not be null.");
        }
        Action action = this.getAction(xMLName);
        if (action != null) {
            throw new XMLMiddlewareException("Action already created for " + xMLName.getUniversalName());
        }
        ClassMap classMap = this.map.getClassMap(xMLName.getUniversalName());
        if (classMap == null) {
            throw new XMLMiddlewareException("Element type not mapped as a class: " + xMLName.getUniversalName());
        }
        action = new Action(xMLName, classMap);
        this.actions.put(xMLName, action);
        return action;
    }

    public void removeAction(XMLName xMLName) throws XMLMiddlewareException {
        Object v = this.actions.remove(xMLName);
        if (v == null) {
            throw new XMLMiddlewareException("No action specified for element type " + xMLName.getUniversalName());
        }
    }

    public void removeAction(String string, String string2) throws XMLMiddlewareException {
        this.removeAction(XMLName.create(string, string2));
    }

    public void removeAllActions() {
        this.actions.clear();
    }
}

