/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.protocol;

import com.trs.idm.exception.IdMException;
import com.trs.idm.interact.protocol.PacketUtil;
import com.trs.idm.interact.protocol.ProtocolPacket;

public class RequestPacket
extends ProtocolPacket {
    private byte cmd;
    private String remoteAddr;
    private int remotePort;

    public RequestPacket(byte cmd, String[] body) throws IdMException {
        if (body == null) {
            throw new IdMException("\u53c2\u6570\u4e3anull!");
        }
        this.buildRequesetPacket(cmd, body, null);
    }

    private void buildRequesetPacket(byte cmd, String[] body, String idmServerCharset) {
        this.cmd = cmd;
        this.bodyLength = PacketUtil.caculateBodyLength(body, (byte)2, idmServerCharset);
        if (this.bodyLength > 0) {
            this.bodyStrs = body;
            this.bodyDatas = PacketUtil.stringArray2PacketBodyBytes(body, this.bodyLength, (byte)2, idmServerCharset);
        }
    }

    public RequestPacket(byte cmd, String[] body, String idmServerCharset) throws IdMException {
        if (body == null) {
            throw new IdMException("\u53c2\u6570\u4e3anull!");
        }
        this.buildRequesetPacket(cmd, body, idmServerCharset);
    }

    public RequestPacket(byte cmd, byte[] body) {
        if (body == null) {
            throw new IllegalArgumentException("bytes of body is null!");
        }
        boolean PROTOCOL_MAJ_OLD_VER = true;
        this.buildRequestPacket(cmd, body, (byte)1, null);
    }

    public RequestPacket(byte cmd, byte[] body, byte majorVersion, String idmServerCharset) {
        if (body == null) {
            throw new IllegalArgumentException("bytes of body is null!");
        }
        this.buildRequestPacket(cmd, body, majorVersion, idmServerCharset);
    }

    private void buildRequestPacket(byte cmd, byte[] body, byte majorVersion, String idmServerCharset) {
        this.cmd = cmd;
        this.bodyLength = (short)body.length;
        if (this.bodyLength > 0) {
            this.bodyDatas = body;
            this.bodyStrs = PacketUtil.packetBodyBytes2StringArray(body, majorVersion, idmServerCharset);
            this.setMajorVersion(majorVersion);
        }
    }

    public byte getCommand() {
        return this.cmd;
    }

    public void setCommand(byte b) {
        this.cmd = b;
    }

    @Override
    public byte[] toBytes() {
        byte[] head = PacketUtil.requestHead2Bytes(this.bodyLength, this.packetId, this.cmd);
        byte[] pack = new byte[16 + this.bodyLength];
        System.arraycopy(head, 0, pack, 0, 16);
        if (this.bodyDatas != null) {
            System.arraycopy(this.bodyDatas, 0, pack, 16, this.bodyLength);
        }
        return pack;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("<bodyLen=").append(this.bodyLength);
        sb.append(";cmd=").append(this.cmd);
        sb.append(';').append(super.toString());
        sb.append('>');
        return sb.toString();
    }

    @Override
    public byte getPacketType() {
        return 0;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }
}

