/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.RawInputStream;
import com.sybase.jdbc2.utils.CacheManager;
import com.sybase.jdbc2.utils.CacheStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class CharsetToUniInputStream
extends RawInputStream {
    private int _currentChar;
    protected int _readBytes = 0;
    protected int _lengthLimit = 0;
    private InputStreamReader _isr = null;
    protected RawInputStream _ris = null;
    protected boolean _even;
    protected boolean _closed;

    public CharsetToUniInputStream(InputStream inputStream, int n, int n2, CacheManager cacheManager) throws IOException {
        super(inputStream, n, n2, cacheManager);
    }

    public CharsetToUniInputStream(InputStream inputStream, int n, int n2, CacheManager cacheManager, String string) throws UnsupportedEncodingException, IOException {
        super(inputStream, n, n2, cacheManager);
        this._lengthLimit = n2 * 2;
        this._ris = new RawInputStream(inputStream, n, n2, cacheManager);
        this._isr = string == null ? new InputStreamReader(this._ris) : new InputStreamReader((InputStream)this._ris, string);
        this._even = true;
        this._closed = false;
    }

    public int available() throws IOException {
        if (this._closed) {
            return 0;
        }
        int n = this._lengthLimit - this._readBytes;
        return n;
    }

    public boolean cache(CacheStream cacheStream) throws IOException {
        return this._ris.cache(cacheStream);
    }

    public void close() throws IOException {
        this._ris.close();
    }

    public int read() throws IOException {
        int n;
        if (this._closed) {
            return -1;
        }
        if (this._even) {
            this._currentChar = this._isr.read();
            if (this._currentChar == -1) {
                this._closed = true;
                return -1;
            }
            n = (this._currentChar & 0xFF00) >> 8;
        } else {
            n = this._currentChar & 0xFF;
        }
        this._even ^= true;
        ++this._readBytes;
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read();
            if (n4 == -1) {
                return n3 == 0 ? -1 : n3;
            }
            byArray[n3 + n] = (byte)(n4 & 0xFF);
            ++n3;
        }
        return n3;
    }

    public void setCached(boolean bl) {
        this._ris.setCached(bl);
    }

    public long skip(long l) throws IOException {
        long l2 = 0L;
        while (l2 < l) {
            if (this.read() < 0) break;
            ++l2;
        }
        return l2;
    }
}

