/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcmonline;

import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.publish.tagparser.WCMTagParserHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import org.apache.log4j.Logger;

public class TagParserVipMetaData
implements ITagParser {
    private static final Logger LOG = Logger.getLogger(TagParserVipMetaData.class);
    private static TagBeanInfo s_tagBeafInfo;
    private TagItem m_oTagItem;
    private String m_sVisitUrl = null;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_tagBeafInfo == null) {
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_VIPMETADATA");
            tbi.setDesc("\u5609\u5bbe\u8bbf\u8c08\u5143\u6570\u636e");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            TagBeanAttrInfo tbai = new TagBeanAttrInfo();
            tbai.setName("MODE");
            tbai.setDesc("\u6570\u636e\u83b7\u53d6\u65b9\u5f0f");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"REMOTE", "LOCAL"});
            tbai.setDefaultValue("REMOTE");
            tbai.setRequired(true);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("DATATYPE");
            tbai.setDesc("\u6570\u636e\u683c\u5f0f");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"js", "xml"});
            tbai.setDefaultValue("js");
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("VISITURL");
            tbai.setDesc("\u8bbf\u95ee\u8def\u5f84");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("USEABSURL");
            tbai.setDesc("\u4f7f\u7528\u7edd\u5bf9\u8def\u5f84");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIELD");
            tbai.setDesc("\u6307\u5b9a\u83b7\u53d6\u67d0\u4e00\u9879\u76ee\u5143\u6570\u636e");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            String[] fields = new String[]{"BOOKDATA", "VIPDATA", "NOTICEDATA", "VIPID", "SYSURL"};
            tbai.setEnumValue(fields);
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("VALUETYPE");
            tbai.setDesc("\u6570\u636e\u7684\u8f93\u51fa\u683c\u5f0f(\u5982\u679c\u6ca1\u6709\u6307\u5b9aFIELD\u6709\u6548)");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"js", "html"});
            tbai.setDefaultValue("js");
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ID");
            tbai.setDesc("\u6307\u5b9a\u83b7\u53d6\u90a3\u4e2a\u5609\u5bbe\u8bbf\u8c08\u9891\u9053");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("OWNER");
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("VIPID");
            tbai.setDesc("\u6307\u5b9a\u83b7\u53d6\u90a3\u4e2a\u5609\u5bbe\u8bbf\u8c08\u7684ID");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("SYSURL");
            tbai.setDesc("\u6307\u5b9a\u5609\u5bbe\u8bbf\u8c08\u7684\u8bbf\u95ee\u5730\u5740");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("OWNER");
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            s_tagBeafInfo = tbi;
        }
        return s_tagBeafInfo;
    }

    @Override
    public void setTagItem(TagItem _item) {
        this.m_oTagItem = _item;
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        String sDataType;
        BaseChannel channel = WCMTagParserHelper.findFolderHost(this.m_oTagItem, _context, true);
        if (channel == null) {
            return null;
        }
        String field = _context.getAttribute("FIELD");
        if (!CMyString.isEmpty(field) && field.equalsIgnoreCase("wcmurl")) {
            String sPath = channel.getAttributeValue("WCMUrl");
            return new String[]{sPath};
        }
        String sVipId = channel.getAttributeValue("VipId");
        String sSysUrl = _context.getAttribute("VISITURL");
        if (CMyString.isEmpty(sSysUrl)) {
            sSysUrl = channel.getAttributeValue("SysUrl");
        }
        if (CMyString.isEmpty(sVipId) || CMyString.isEmpty(sSysUrl)) {
            sVipId = _context.getAttribute("VIPID");
            sSysUrl = _context.getAttribute("SYSURL");
            if (CMyString.isEmpty(sVipId) || CMyString.isEmpty(sSysUrl)) {
                LOG.warn((Object)("not a vipchannel:" + channel));
                return null;
            }
        }
        if ('/' != sSysUrl.charAt(sSysUrl.length() - 1)) {
            sSysUrl = sSysUrl + '/';
        }
        this.m_sVisitUrl = sSysUrl;
        if ("LOCAL".equalsIgnoreCase(_context.getAttribute("MODE"))) {
            sSysUrl = _context.getPageHttpPath();
            if (!_context.getAttribute("USEABSURL", false)) {
                sSysUrl = HtmlUtil.calRelativePath(sSysUrl, _context.getPageHttpPath());
            }
        }
        sDataType = CMyString.isEmpty(sDataType = _context.getAttribute("DATATYPE")) ? "js" : sDataType.toLowerCase();
        String[] result = new String[1];
        if (CMyString.isEmpty(field)) {
            result[0] = "html".equalsIgnoreCase(_context.getAttribute("VALUETYPE")) ? this.generateHtml(sVipId, sSysUrl, sDataType) : this.generateJs(sVipId, sSysUrl, sDataType);
        } else {
            StringBuffer buff = new StringBuffer(64);
            if ("vipid".equals(field = field.toLowerCase())) {
                buff.append(sVipId);
            } else if ("sysurl".equals(field)) {
                buff.append(this.m_sVisitUrl);
            } else if ("loginurl".equals(field)) {
                buff.append(this.m_sVisitUrl);
                buff.append("personal/login.jsp");
            } else if ("loginaction".equals(field)) {
                buff.append(this.m_sVisitUrl);
                buff.append("personal/loginaction.jsp");
            } else {
                buff.append(sSysUrl);
                buff.append("vip").append(sVipId);
                if ("bookdata".equals(field)) {
                    buff.append("/booksdata_vip").append(sVipId).append("_{0}");
                } else if ("vipdata".equals(field)) {
                    buff.append("/commentsdata_vip").append(sVipId);
                } else {
                    buff.append("/noticedata_vip").append(sVipId);
                }
                buff.append('.').append(sDataType);
            }
            result[0] = buff.toString();
        }
        return result;
    }

    private String generateJs(String sVipId, String sSysUrl, String sDataType) {
        StringBuffer buff = new StringBuffer(256);
        buff.append("<script>");
        buff.append("var V_VIPID=").append(sVipId).append(';');
        buff.append("var V_SYSURL='").append(this.m_sVisitUrl).append("';");
        buff.append("var V_BOOKDATAURL='");
        buff.append(sSysUrl);
        buff.append("vip").append(sVipId);
        buff.append("/booksdata_vip").append(sVipId);
        buff.append("_{0}");
        buff.append('.').append(sDataType);
        buff.append("';");
        buff.append("var V_BOOKCOUNTDATAURL='");
        buff.append(sSysUrl);
        buff.append("vip").append(sVipId);
        buff.append("/countdata_vip").append(sVipId);
        buff.append('.').append(sDataType);
        buff.append("';");
        buff.append("var V_VIPDATAURL='");
        buff.append(sSysUrl);
        buff.append("vip").append(sVipId);
        buff.append("/commentsdata_vip").append(sVipId);
        buff.append('.').append(sDataType);
        buff.append("';");
        buff.append("var V_NOTICDATAURL='");
        buff.append(sSysUrl);
        buff.append("vip").append(sVipId);
        buff.append("/noticedata_vip").append(sVipId);
        buff.append('.').append(sDataType);
        buff.append("';");
        buff.append("var V_LOGINURL='");
        buff.append(this.m_sVisitUrl);
        buff.append("personal/login.jsp");
        buff.append("';");
        buff.append("var V_LOGINACTION='");
        buff.append(this.m_sVisitUrl);
        buff.append("personal/loginaction.jsp");
        buff.append("'");
        buff.append("</script>");
        buff.append("<script src='");
        buff.append(this.m_sVisitUrl);
        buff.append("wcmonline/ajaxservice/randid.jsp?vipid=");
        buff.append(sVipId);
        buff.append("'></script>");
        return buff.toString();
    }

    private String generateHtml(String sVipId, String sSysUrl, String sDataType) {
        StringBuffer buff = new StringBuffer(256);
        buff.append("<div style='display:none' id='wcmvip_metadata'>");
        buff.append("<span id='wcmvip_metadata_vipid'>");
        buff.append(sVipId);
        buff.append("</span>");
        buff.append("<span id='wcmvip_metadata_sysurl'>");
        buff.append(this.m_sVisitUrl);
        buff.append("</span>");
        buff.append("<span id='wcmvip_metadata_bookdata'>");
        buff.append(sSysUrl);
        buff.append("vip").append(sVipId);
        buff.append("/booksdata_vip").append(sVipId);
        buff.append('.').append(sDataType);
        buff.append("</span>");
        buff.append("<span id='wcmvip_metadata_vipdata'>");
        buff.append(sSysUrl);
        buff.append("vip").append(sVipId);
        buff.append("/commentsdata_vip").append(sVipId);
        buff.append('.').append(sDataType);
        buff.append("</span>");
        buff.append("<span id='wcmvip_metadata_noticedata'>");
        buff.append(sSysUrl);
        buff.append("vip").append(sVipId);
        buff.append("/noticedata_vip").append(sVipId);
        buff.append('.').append(sDataType);
        buff.append("</span>");
        buff.append("<span id='wcmvip_metadata_loginurl'>");
        buff.append(this.m_sVisitUrl);
        buff.append("personal/login.jsp");
        buff.append("</span>");
        buff.append("<span id='wcmvip_metadata_loginaction'>");
        buff.append(this.m_sVisitUrl);
        buff.append("personal/loginaction.jsp");
        buff.append("</span>");
        buff.append("</div>");
        return buff.toString();
    }

    public void clear() {
        if (this.m_oTagItem != null) {
            this.m_oTagItem.clear();
            this.m_oTagItem = null;
        }
    }
}

