/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.cabfile;

import com.trs.infra.util.cabfile.CFData;
import com.trs.infra.util.cabfile.CFFile;
import com.trs.infra.util.cabfile.CFFolder;
import com.trs.infra.util.cabfile.CFHeader;
import com.trs.infra.util.cabfile.CabConstants;
import com.trs.infra.util.cabfile.CabEntry;
import com.trs.infra.util.cabfile.CabFileReader;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;

public class CabFile
implements CabConstants {
    private FileStore m_oCabFile;
    private CabFileReader m_oCabReader;
    private CFHeader m_oHeader;
    private CFFolder[] m_oFolders;
    private CFFile[] m_oFiles;
    private CFData m_oCFData;
    private CabEntry[] m_oEentries;

    public CabFile(FileStore file) throws IOException {
        try {
            this.init(file);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public CabFile(String file) throws IOException {
        this(new FileService(file));
    }

    private void init(FileStore file) throws IOException {
        int i;
        this.m_oCabFile = file;
        this.m_oCabReader = new CabFileReader(file);
        this.m_oHeader = this.m_oCabReader.readCFHeader();
        System.out.println("The Folders:");
        this.m_oFolders = new CFFolder[this.m_oHeader.cFolders];
        System.out.println("Test CabFile.java,m_oHeader.cFolders is: " + this.m_oHeader.cFolders);
        for (i = 0; i < this.m_oHeader.cFolders; ++i) {
            this.m_oFolders[i] = this.m_oCabReader.readCFFolder();
            System.out.println("Test CabFile.java,m_oFolders[i] is:" + this.m_oFolders[i]);
        }
        this.m_oFiles = new CFFile[this.m_oHeader.cFiles];
        this.m_oEentries = new CabEntry[this.m_oHeader.cFiles];
        System.out.println("The Files:");
        for (i = 0; i < this.m_oHeader.cFiles; ++i) {
            this.m_oFiles[i] = this.m_oCabReader.readCFFile();
            this.m_oEentries[i] = new CabEntry(this.m_oFiles[i]);
            System.out.println("Test CabFile.java,m_oFiles[i] is:" + this.m_oFiles[i]);
            System.out.println("Test CabFile.java,m_oEentries[i] is:" + this.m_oEentries[i]);
        }
    }

    public void close() {
        if (this.m_oCabReader != null) {
            this.m_oCabReader.close();
        }
    }

    public Iterator entries() {
        Iterator itr = new Iterator(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < CabFile.this.m_oEentries.length;
            }

            public Object next() {
                return CabFile.this.m_oEentries[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return itr;
    }

    private void ensureDiretory(FileStore diretory) throws IOException {
        if (diretory == null) {
            throw new NullPointerException("diretory is null");
        }
        if (diretory.exists() && !diretory.isDirectory()) {
            throw new IOException(diretory.getPath() + " not diretory");
        }
        if (!diretory.exists()) {
            diretory.mkdirs();
        }
        if (!diretory.exists()) {
            throw new IOException("create " + diretory.getPath() + " fail");
        }
    }

    private CFData getNextCFData(CFFile cffile) throws IOException {
        if (this.m_oCFData == null) {
            this.m_oCFData = new CFData();
        }
        this.m_oCabReader.fillCFData(this.m_oCFData);
        try {
            this.m_oCFData.uncompress(this.m_oFolders[cffile.iFolder].getCompressType());
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
        return this.m_oCFData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int extract(FileService diretory) throws IOException {
        this.ensureDiretory(diretory);
        CFData cfdata = null;
        int iDataRemain = 0;
        int iDataOffset = 0;
        for (int i = 0; i < this.m_oEentries.length; ++i) {
            CFFile cffile = this.m_oFiles[i];
            CabEntry entry = this.m_oEentries[i];
            System.out.println("diretory\u7684\u503c\u4e3a:" + diretory.getAbsolutePath());
            System.out.println("entry.getName()\u7684\u503c\u4e3a:" + entry.getName());
            FileService file = new FileService(diretory, entry.getName());
            System.out.println("file\u7684\u503c\u4e3a:" + file.getAbsolutePath());
            try (OutputStream fos = file.getOutputStream();){
                long iFileRemain = entry.getSize();
                System.out.println("iFileRemain = entry.getSize(),iFileRemain is :" + iFileRemain);
                while (iFileRemain > 0L) {
                    if (iDataRemain == 0) {
                        cfdata = this.getNextCFData(cffile);
                        iDataRemain = cfdata.cbUncomp;
                        iDataOffset = 0;
                    }
                    int block = (int)Math.min((long)iDataRemain, iFileRemain);
                    System.out.println("block = (int) Math.min(iDataRemain, iFileRemain),block is:" + block);
                    fos.write(cfdata.abUncomp, iDataOffset, block);
                    iFileRemain -= (long)block;
                    iDataRemain -= block;
                    iDataOffset += block;
                }
            }
            file.setLastModified(entry.getTime());
        }
        return this.m_oEentries.length;
    }

    public CabEntry getEntry(String name) {
        if (this.m_oEentries != null) {
            for (int i = this.m_oEentries.length - 1; i >= 0; --i) {
                CabEntry entry = this.m_oEentries[i];
                if (!entry.getName().equals(name)) continue;
                return entry;
            }
        }
        return null;
    }

    public InputStream getInputStream(CabEntry entry) throws IOException {
        throw new UnsupportedOperationException("getInputStream(CabEntry)");
    }

    public String getName() {
        return this.m_oCabFile.getPath();
    }

    public int size() {
        return this.m_oEentries != null ? this.m_oEentries.length : 0;
    }
}

