/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.security;

import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SecureKeyUtil {
    private SecureKeyUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static String[] getServiceTypes() {
        HashSet<String> result = new HashSet<String>();
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            Set<Object> keys = providers[i].keySet();
            for (String string : keys) {
                void var5_5;
                String string2 = string.split(" ")[0];
                if (string2.startsWith("Alg.Alias.")) {
                    String string3 = string2.substring(10);
                }
                int ix = var5_5.indexOf(46);
                result.add(var5_5.substring(0, ix));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] getCryptoImpls(String serviceType) {
        HashSet<String> result = new HashSet<String>();
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            Set<Object> keys = providers[i].keySet();
            for (String string : keys) {
                String string2 = string.split(" ")[0];
                if (string2.startsWith(serviceType + ".")) {
                    result.add(string2.substring(serviceType.length() + 1));
                    continue;
                }
                if (!string2.startsWith("Alg.Alias." + serviceType + ".")) continue;
                result.add(string2.substring(serviceType.length() + 11));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] getCryptoImplsBy(String provName, String serviceType) {
        Provider prov = Security.getProvider(provName);
        HashSet<String> result = new HashSet<String>();
        if (prov != null) {
            Set<Object> keys = prov.keySet();
            for (String string : keys) {
                String string2 = string.split(" ")[0];
                if (string2.startsWith(serviceType + ".")) {
                    result.add(string2.substring(serviceType.length() + 1));
                    continue;
                }
                if (!string2.startsWith("Alg.Alias." + serviceType + ".")) continue;
                result.add(string2.substring(serviceType.length() + 11));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static void main(String[] args) {
        String[] types = SecureKeyUtil.getServiceTypes();
        Provider[] provs = Security.getProviders();
        for (int j = 0; j < provs.length; ++j) {
            System.out.println("Provider:" + provs[j].getName());
            for (int i = 0; i < types.length; ++i) {
                String[] impls = SecureKeyUtil.getCryptoImplsBy(provs[j].getName(), types[i]);
                if (impls.length <= 0) continue;
                System.out.println(types[i] + ":");
                System.out.println(Arrays.asList(impls));
                System.out.println();
            }
            System.out.println("===============");
        }
    }
}

