/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent;

import com.trs.components.wcm.content.service.portervisitors.PorterUtil;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.NullValue;
import com.trs.infra.util.CMyDOM4jHelper;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class BaseObjToXmlConverter {
    private static final String PATTERN_CDATA = "(?ism).*<!\\[CDATA\\[.*|.*\\]\\]>.*";
    private String m_sXmlEncoding = "utf-8";
    private boolean bAddVersion = true;

    public String toXMLString(Object _currObj) throws WCMException {
        return this.toXMLString(_currObj, null);
    }

    public String toXMLString(Object _currObj, String _sXslFile) throws WCMException {
        return this.toXMLString(_currObj, _sXslFile, null);
    }

    public String toXMLString(Object _currObj, String _XSLFileName, String _sFieldsList) throws WCMException {
        Element element = this.convertObjToElement(_currObj, _sFieldsList);
        if (_XSLFileName == null) {
            return element.asXML();
        }
        Document document = CMyDOM4jHelper.makeXMLDocument(element, _XSLFileName);
        return document.asXML();
    }

    public void toXMLFile(Object _currObj, String _sXmlFile) throws WCMException {
        this.toXMLFile(_currObj, _sXmlFile, null);
    }

    public void toXMLFile(Object _currObj, String _sXmlFile, String _sXslFile) throws WCMException {
        this.toXMLFile(_currObj, _sXmlFile, _sXslFile, null);
    }

    public void toXMLFile(Object _currObj, String _sXMLFile, String _XSLFileName, String _sFieldsList) throws WCMException {
        Element element = this.convertObjToElement(_currObj, _sFieldsList);
        CMyDOM4jHelper.toXMLFile(element, this.m_sXmlEncoding, _sXMLFile, _XSLFileName);
    }

    private Element convertObjToElement(Object _currObj, String _sFieldsList) throws WCMException {
        if (_currObj == null) {
            throw new WCMException(10, I18NMessage.get(BaseObjToXmlConverter.class, "BaseObjToXmlConverter.label1", "\u65e0\u6548\u7684\u5bf9\u8c61[null]!"));
        }
        if (_currObj instanceof BaseObj) {
            return this.toXmlElement((BaseObj)_currObj, _sFieldsList);
        }
        if (_currObj instanceof BaseObjs) {
            return this.toXmlElement((BaseObjs)_currObj, _sFieldsList);
        }
        if (_currObj instanceof List) {
            return this.toXmlElement((List)_currObj, _sFieldsList);
        }
        throw new WCMException(1100, I18NMessage.get(BaseObjToXmlConverter.class, "BaseObjToXmlConverter.label2", "\u4e0d\u652f\u6301[") + _currObj.getClass() + I18NMessage.get(BaseObjToXmlConverter.class, "BaseObjToXmlConverter.label3", "]\u7c7b\u578b\u5bf9\u8c61\u7684XML\u8f6c\u6362"));
    }

    public Element toXmlElement(BaseObjs _baseObjs, String _sFieldsList) throws WCMException {
        Element element = DocumentHelper.createElement((String)this.getElementTag(_baseObjs));
        BaseObj baseObj = null;
        for (int i = 0; i < _baseObjs.size(); ++i) {
            baseObj = _baseObjs.getAt(i);
            if (baseObj == null) continue;
            element.add(this.toXmlElement(baseObj, _sFieldsList));
        }
        return element;
    }

    public Element toXmlElement(List _listObjs, String _sFieldsList) throws WCMException {
        if (_listObjs.isEmpty()) {
            return null;
        }
        BaseObj oFirstObj = (BaseObj)_listObjs.get(0);
        if (oFirstObj == null) {
            throw new WCMException(10, I18NMessage.get(BaseObjToXmlConverter.class, "BaseObjToXmlConverter.label4", "\u6307\u5b9a\u7684List\u4e2d\u7684\u5143\u7d20[") + _listObjs.get(0).getClass() + I18NMessage.get(BaseObjToXmlConverter.class, "BaseObjToXmlConverter.label5", "]\u4e0d\u7b26\u5408\u8981\u6c42\uff01"));
        }
        Element element = DocumentHelper.createElement((String)(oFirstObj.getDbTableName() + "S"));
        BaseObj baseObj = null;
        for (int i = 0; i < _listObjs.size(); ++i) {
            baseObj = (BaseObj)_listObjs.get(i);
            if (baseObj == null) continue;
            element.add(this.toXmlElement(baseObj, _sFieldsList));
        }
        return element;
    }

    public Element toXmlElement(BaseObj _baseObj) throws WCMException {
        return this.toXmlElement(_baseObj, null);
    }

    protected Element toXmlElement(BaseObj _baseObj, String _sFieldsList) throws WCMException {
        StringTokenizer enumKeys = null;
        String sKey = null;
        Object objValue = null;
        Hashtable<String, Object> hProperty = _baseObj.getAllProperty();
        Element currElement = DocumentHelper.createElement((String)this.getElementTag(_baseObj));
        if (this.isAddVersion()) {
            currElement.addAttribute("Version", "6.0");
        }
        Element eleProperties = currElement.addElement("PROPERTIES");
        Element eleItem = null;
        String sFieldList = _sFieldsList;
        if (sFieldList == null || sFieldList.trim().length() == 0) {
            sFieldList = this.getFieldList(_baseObj);
        }
        enumKeys = sFieldList != null && sFieldList.trim().length() > 0 ? new StringTokenizer(sFieldList.toUpperCase(), ",") : hProperty.keys();
        while (enumKeys.hasMoreElements()) {
            try {
                sKey = enumKeys.nextElement().trim();
                objValue = _baseObj.getProperty(sKey);
                eleItem = eleProperties.addElement(sKey);
                if (objValue == null || objValue instanceof NullValue) continue;
                if (objValue instanceof String) {
                    String strValue = (String)objValue;
                    if (strValue.matches(PATTERN_CDATA)) {
                        eleItem.setText(strValue);
                        continue;
                    }
                    eleItem.addCDATA(strValue);
                    continue;
                }
                if (objValue instanceof CDBText) {
                    String textValue = ((CDBText)objValue).getText();
                    if (CMyString.isEmpty(textValue)) continue;
                    if (textValue.matches(PATTERN_CDATA)) {
                        eleItem.setText(textValue);
                        continue;
                    }
                    eleItem.addCDATA(textValue);
                    continue;
                }
                if (objValue instanceof CMyDateTime) {
                    CMyDateTime dtTemp = (CMyDateTime)objValue;
                    if (dtTemp.isNull()) continue;
                    eleItem.setText(dtTemp.toString());
                    continue;
                }
                eleItem.setText(objValue.toString());
            }
            catch (Throwable ex) {
                throw new WCMException(I18NMessage.get(BaseObjToXmlConverter.class, "BaseObjToXmlConverter.label6", "\u5904\u7406[") + sKey + I18NMessage.get(BaseObjToXmlConverter.class, "BaseObjToXmlConverter.label7", "]\u5b57\u6bb5\u5931\u8d25!"), ex);
            }
        }
        Element[] childElements = this.getChildElement(_baseObj);
        this.addChildElements(currElement, childElements);
        PorterUtil.doExports(_baseObj, new Object[]{this, currElement});
        return currElement;
    }

    public void addChildElements(Element currElement, Element[] childElements) {
        if (childElements == null) {
            return;
        }
        for (int i = 0; i < childElements.length; ++i) {
            Element element = childElements[i];
            if (element == null) continue;
            currElement.add(element);
        }
    }

    protected abstract Element[] getChildElement(BaseObj var1) throws WCMException;

    public String getXmlEncoding() {
        return this.m_sXmlEncoding;
    }

    public void setXmlEncoding(String _sXmlEncoding) {
        this.m_sXmlEncoding = _sXmlEncoding;
    }

    protected String getFieldList(BaseObj _currObj) {
        return null;
    }

    public String getElementTag(BaseObjs _baseObjs) {
        return _baseObjs.getDbTableName() + "S";
    }

    public String getElementTag(BaseObj _baseObj) {
        return _baseObj.getDbTableName();
    }

    public boolean isAddVersion() {
        return this.bAddVersion;
    }

    public void setAddVersion(boolean _bAddVersion) {
        this.bAddVersion = _bAddVersion;
    }
}

