/*
 * Decompiled with CFR 0.152.
 */
package com.trs.database.util;

import com.trs.database.util.Plan;
import com.trs.database.util.Row;
import com.trs.infra.util.store.FileService;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;

public class OTop {
    private static final String SQL = "select sql_text ,rawtohex(address),hash_value,child_number from v$sql s order by #topby# desc nulls last";
    private static final String SQL_PLAN = "select lpad(' ', 2*(level-1))||operation, options ,decode(to_char(id), '0', 'Cost='||nvl(to_char(position), 'n/a'), object_name) ,cost,optimizer from v$sql_plan sqlplan start with address = hextoraw(?) and hash_value=? and child_number=? and id = 0 connect by prior id = sqlplan.parent_id and prior sqlplan.address = sqlplan.address and prior sqlplan.hash_value = sqlplan.hash_value";
    private static final String[] TOPBYS = new String[]{"buffer_gets", "disk_reads", "cpu_time", "executions", "buffer_gets/nvl(replace(rows_processed,0,1),1)"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage:");
            System.out.println("\t1. UserName, account can access v$sql etc.");
            System.out.println("\t2. Password, password of account.");
            System.out.println("\t3. Link url,host:port:sid");
            System.out.println("\t4. OTop,order by(optional,default=1)");
            System.out.println("\t  1=buffer_gets");
            System.out.println("\t  2=disk_reads");
            System.out.println("\t  3=cpu_time");
            System.out.println("\t  4=executions");
            System.out.println("\t  5=buffer_gets/rows_processed");
            System.out.println("\t5. Lines Count(optional ,default=20)");
            System.exit(1);
        }
        String user = args[0];
        String passwd = args[1];
        String url = "jdbc:oracle:thin:@" + args[2];
        if ("-f".equals(args[0])) {
            Properties props = new Properties();
            InputStream ins = null;
            try {
                ins = new FileService(args[1]).getInputStream();
                props.load(ins);
                user = props.getProperty("user");
                passwd = props.getProperty("passwd");
                url = props.getProperty("url");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (Exception ex) {}
                }
                props.clear();
            }
        }
        int topn = 20;
        int ix = 0;
        if (args.length > 3) {
            try {
                ix = Integer.parseInt(args[3]) - 1;
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (ix < 0 || ix > TOPBYS.length) {
                ix = 0;
            }
        }
        if (args.length > 4) {
            try {
                topn = Integer.parseInt(args[4]);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (topn < 0) {
                topn = 20;
            }
        }
        String topby = TOPBYS[ix];
        String sql = SQL.replaceAll("#topby#", topby);
        Connection conn = null;
        Statement stmt = null;
        Statement pstmt = null;
        ResultSet rs = null;
        ResultSet temprs = null;
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
            conn = DriverManager.getConnection(url, user, passwd);
            stmt = conn.createStatement();
            stmt.setFetchSize(topn);
            stmt.setMaxRows(topn);
            rs = stmt.executeQuery(sql);
            pstmt = conn.prepareStatement(SQL_PLAN);
            String sqlstmt = null;
            String addr = null;
            long hash = 0L;
            long childNumber = 0L;
            StringBuffer buff = new StringBuffer(128);
            Plan plan = new Plan();
            Row row = null;
            for (int count = 0; rs.next() && count < topn; ++count) {
                ix = 1;
                plan.reset();
                sqlstmt = rs.getString(ix++);
                buff.append(sqlstmt);
                buff.append('\n');
                buff.append("\n---- execute plan ----\n");
                addr = rs.getString(ix++);
                hash = rs.getLong(ix++);
                childNumber = rs.getLong(ix++);
                pstmt.setString(1, addr);
                pstmt.setLong(2, hash);
                pstmt.setLong(3, childNumber);
                temprs = pstmt.executeQuery();
                while (temprs.next()) {
                    ix = 1;
                    row = new Row(temprs.getString(ix++), temprs.getString(ix++), temprs.getString(ix++), temprs.getString(ix++), temprs.getString(ix++));
                    plan.addRow(row);
                }
                temprs.close();
                buff.append(plan);
                buff.append('\n');
                System.out.println(buff);
                buff.setLength(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (temprs != null) {
                try {
                    temprs.close();
                }
                catch (Exception exception) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

