/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.stat.domain;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.stat.StatFieldMap;
import com.trs.components.wcm.stat.StatFieldMaps;
import com.trs.components.wcm.stat.StatView;
import com.trs.components.wcm.stat.domain.ChartBuildException;
import com.trs.components.wcm.stat.domain.ChartOption;
import com.trs.components.wcm.stat.domain.StatDataItem;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.CMyResultSet;
import com.trs.infra.persistent.CMyResultSets;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CPager;
import com.trs.service.impl.StatService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TimingChartData {
    private static final String MAPDATA_INDEX = "_INDEX";
    public static boolean IS_DEBUG = false;
    public static final String KEY_DATASET_HEADER = "header";
    public static final String KEY_DATASET_VALUES = "values";
    private ChartOption m_oChartOption = null;
    private int m_nStatViewId;
    private Map m_hDataset = null;

    public TimingChartData(int _nStatViewId, ChartOption _option) {
        if (_nStatViewId <= 0) {
            throw new ChartBuildException(I18NMessage.get(TimingChartData.class, "TimingChartData.label1", "\u4f20\u5165\u7684StatViewId\u53c2\u6570\u5fc5\u987b\u4e3a\u6b63\u6574\u6570\uff08\u5f53\u524d\u4e3a") + _nStatViewId + "\uff09\uff01");
        }
        if (_option == null) {
            throw new ChartBuildException(I18NMessage.get(TimingChartData.class, "TimingChartData.label2", "\u6ca1\u6709\u4f20\u5165\u56fe\u8868\u6784\u9020\u53c2\u6570\uff01"));
        }
        this.m_nStatViewId = _nStatViewId;
        this.m_oChartOption = _option;
        this.m_oChartOption.validate();
    }

    public Object getDataSet() {
        if (this.m_hDataset == null) {
            this.fill();
        }
        return this.m_hDataset;
    }

    public Object fill() {
        return this.fill(this.m_oChartOption.getPeriodType());
    }

    public Object fill(int _nPeriodType) {
        if (IS_DEBUG) {
            this.m_hDataset = (Map)this.getTestDataset(this.m_oChartOption, _nPeriodType);
            return this.m_hDataset;
        }
        StatService currStatService = (StatService)DreamFactory.createObjectById("IStatService");
        String sStartDateTime = this.m_oChartOption.getStartStatTimeAsString();
        String sEndDateTime = this.m_oChartOption.getEndStatTimeAsString();
        String sGroupBy = this.m_oChartOption.getGroupBy();
        String sStatTimeProp = this.m_oChartOption.getStatTimeField();
        try {
            this.m_hDataset = new HashMap();
            StatFieldMaps currStatFieldMaps = currStatService.getStatFieldsByView(this.m_nStatViewId);
            int nFieldsCounter = currStatFieldMaps.size();
            HashMap<String, String> hFieldInfo = new HashMap<String, String>(nFieldsCounter);
            StatFieldMap currStatFieldMap = null;
            for (int j = 0; j < nFieldsCounter; ++j) {
                currStatFieldMap = (StatFieldMap)currStatFieldMaps.getAt(j);
                if (currStatFieldMap == null) continue;
                String sFieldName = currStatFieldMap.getFieldName();
                String sFieldType = currStatFieldMap.getFieldType();
                if (sFieldName == null || sFieldName.equalsIgnoreCase(sGroupBy) || sFieldType == null || !sFieldType.equalsIgnoreCase("Number")) continue;
                hFieldInfo.put(sFieldName.toUpperCase(), currStatFieldMap.getFieldDesc());
            }
            this.m_hDataset.put(KEY_DATASET_HEADER, hFieldInfo);
            CMyResultSets currResultSets = new CMyResultSets();
            WCMFilter filter = this.makeSql(this.m_nStatViewId, sStartDateTime, sEndDateTime, sStatTimeProp, this.m_oChartOption);
            currResultSets.open(filter.toSQL(), "recid");
            CPager currPager = new CPager(-1);
            int nDataSize = currResultSets.size();
            currPager.setItemCount(nDataSize);
            HashMap<String, Cloneable> hFlagedData = new HashMap<String, Cloneable>();
            HashMap<String, Integer> hStageData = null;
            for (int i = currPager.getFirstItemIndex() - 1; i < currPager.getLastItemIndex(); ++i) {
                CMyResultSet obj = (CMyResultSet)currResultSets.getAt(i);
                if (obj == null) continue;
                String flag = obj.getPropertyAsString(sGroupBy);
                CMyDateTime dtStatTime = obj.getPropertyAsDateTime(sStatTimeProp);
                if (flag == null || dtStatTime == null) continue;
                hStageData = new HashMap<String, Integer>(hFieldInfo.size());
                for (Map.Entry entry : hFieldInfo.entrySet()) {
                    String sKey = (String)entry.getKey();
                    hStageData.put(sKey.toUpperCase(), new Integer(obj.getPropertyAsInt(sKey, 0)));
                }
                if (_nPeriodType > 0) {
                    HashMap hValData = (HashMap)hFlagedData.get(flag);
                    if (hValData == null) {
                        hValData = new HashMap();
                    }
                    this.manipulateHash(hValData, hStageData, _nPeriodType, dtStatTime);
                    hFlagedData.put(flag, hValData);
                    continue;
                }
                ArrayList<StatDataItem> arItems = (ArrayList<StatDataItem>)hFlagedData.get(flag);
                if (arItems == null) {
                    arItems = new ArrayList<StatDataItem>();
                }
                arItems.add(new StatDataItem(dtStatTime, hStageData));
                hFlagedData.put(flag, arItems);
            }
            this.m_hDataset.put(KEY_DATASET_VALUES, hFlagedData);
            return this.m_hDataset;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Object getTestDataset(ChartOption _option, int _nPeriod) {
        HashMap<String, Cloneable> hFlagedData = new HashMap<String, Cloneable>();
        int nSeriesCount = 5;
        String sStageField = _option.getCurrStageField();
        HashMap<String, Integer> hData = null;
        int nPeriod = _nPeriod;
        for (int i = 0; i < nSeriesCount; ++i) {
            String flag = "S-" + (i + 1);
            int nDataCount = 12;
            for (int nItemIndex = 0; nItemIndex < nDataCount; ++nItemIndex) {
                try {
                    hData = new HashMap<String, Integer>(1);
                    hData.put(sStageField.toUpperCase(), new Integer((int)(Math.random() * 100.0)));
                    CMyDateTime dtStatTime = new CMyDateTime();
                    dtStatTime.setDateTimeWithString("2007-" + (nItemIndex + 1) + "-" + (nItemIndex + 1));
                    if (nPeriod > 0) {
                        HashMap hValData = (HashMap)hFlagedData.get(flag);
                        if (hValData == null) {
                            hValData = new HashMap();
                        }
                        this.manipulateHash(hValData, hData, nPeriod, dtStatTime);
                        hFlagedData.put(flag, hValData);
                        continue;
                    }
                    ArrayList<StatDataItem> arValData = (ArrayList<StatDataItem>)hFlagedData.get(flag);
                    if (arValData == null) {
                        arValData = new ArrayList<StatDataItem>();
                    }
                    arValData.add(new StatDataItem(dtStatTime, hData));
                    hFlagedData.put(flag, arValData);
                    continue;
                }
                catch (CMyException e) {
                    // empty catch block
                }
            }
        }
        HashMap<String, HashMap<String, Cloneable>> result = new HashMap<String, HashMap<String, Cloneable>>(1);
        result.put(KEY_DATASET_VALUES, hFlagedData);
        return result;
    }

    private void manipulateHash(Map _result, Map _data, int _nPeriod, CMyDateTime _dtStatTime) throws CMyException {
        if (_data == null || _data.isEmpty()) {
            return;
        }
        String period = null;
        Integer nIndex = null;
        int nYear = _dtStatTime.getYear();
        if (_nPeriod == 3) {
            period = String.valueOf(nYear + "-01-01");
            nIndex = new Integer(nYear);
        } else {
            int nMonth = _dtStatTime.getMonth();
            period = String.valueOf(nYear + "-" + nMonth + "-01");
            nIndex = new Integer(nYear * 12 + nMonth);
        }
        HashMap<String, Integer> hPeriodData = (HashMap<String, Integer>)_result.get(period);
        if (hPeriodData == null) {
            hPeriodData = new HashMap<String, Integer>();
        }
        hPeriodData.put(MAPDATA_INDEX, nIndex);
        for (Map.Entry entry : _data.entrySet()) {
            Object key = entry.getKey();
            Integer val = (Integer)entry.getValue();
            Integer raw = (Integer)hPeriodData.get(key);
            if (raw == null) {
                hPeriodData.put((String)key, val);
                continue;
            }
            hPeriodData.put((String)key, new Integer(raw + val));
        }
        _result.put(period, hPeriodData);
    }

    private WCMFilter makeSql(int nStatViewId, String startDateTime, String endDateTime, String statTimeField, ChartOption chartOption) throws WCMException {
        StatView view = StatView.findById(nStatViewId);
        if (view == null) {
            throw new ChartBuildException(I18NMessage.get(TimingChartData.class, "TimingChartData.label3", "\u6ca1\u6709\u627e\u5230[ID=") + nStatViewId + I18NMessage.get(TimingChartData.class, "TimingChartData.label4", "]\u7684StatView\u5bf9\u8c61\uff01"));
        }
        WCMFilter filter = new WCMFilter();
        filter.setFrom(view.getResultTable());
        filter.setSelect("*");
        String sWhere = statTimeField + " >= " + this.toSqlDate(startDateTime) + " and " + statTimeField + " <= " + this.toSqlDate(endDateTime);
        filter.setWhere(sWhere);
        filter.setOrder("STATTIME");
        WCMFilter extFilter = null;
        if (chartOption != null && (extFilter = chartOption.getExtraFilter()) != null) {
            filter.mergeWith(extFilter);
        }
        return filter;
    }

    private String toSqlDate(String _sDateTime) {
        return DBManager.getDBManager().getDBType().sqlDateTime(_sDateTime, "YYYY-MM-DD HH24:MI:SS");
    }

    public static String makeDatasetJSON(int nStatviewId, ChartOption option) throws Throwable {
        TimingChartData chartDataset = new TimingChartData(nStatviewId, option);
        if (option.getPeriodType() > 0) {
            chartDataset.fill(option.getPeriodType());
            return TimingChartData.makeDatasetJSON(chartDataset, option.getPeriodType(), option.getGroupBy());
        }
        return TimingChartData.makeDatasetJSON(chartDataset, 0, option.getGroupBy());
    }

    public static String makeDatasetJSON(TimingChartData data, ChartOption option) throws Throwable {
        return TimingChartData.makeDatasetJSON(data, option.getPeriodType(), option.getGroupBy());
    }

    public static String makeDatasetJSON(TimingChartData data) throws Throwable {
        return TimingChartData.makeDatasetJSON(data, 0, "UserId");
    }

    public static String makeDatasetJSON(TimingChartData data, int _nPeriodType, String _sGroupBy) throws Throwable {
        Map hDataset = (Map)data.getDataSet();
        Map hFlagedData = (Map)hDataset.get(KEY_DATASET_VALUES);
        if (hFlagedData == null || hFlagedData.isEmpty()) {
            return null;
        }
        Iterator flagedDatas = hFlagedData.entrySet().iterator();
        StringBuffer sb = new StringBuffer("\nvar dataset = {};");
        while (flagedDatas.hasNext()) {
            Map.Entry flagedData = flagedDatas.next();
            String sSeriesName = (String)flagedData.getKey();
            sSeriesName = IS_DEBUG ? sSeriesName + "[Test]" : (!_sGroupBy.equalsIgnoreCase("UserId") ? TimingChartData.getGroupNameById(sSeriesName) : TimingChartData.getUserNameById(sSeriesName));
            sb.append("\ndataset['" + sSeriesName + "'] = [");
            if (_nPeriodType > 0) {
                Map hValData = (Map)flagedData.getValue();
                if (sSeriesName == null || hValData == null) continue;
                Object[][] arrItems = TimingChartData.orderTimingData(hValData);
                for (int i = 0; i < arrItems.length; ++i) {
                    String key = (String)arrItems[i][0];
                    String val = StatDataItem.getDataMapStr((Map)arrItems[i][1]);
                    sb.append("\n\t['" + key + "', {" + val + "}],");
                }
            } else {
                ArrayList arItems = (ArrayList)flagedData.getValue();
                if (sSeriesName == null || arItems == null) continue;
                for (int nItemIndex = 0; nItemIndex < arItems.size(); ++nItemIndex) {
                    StatDataItem item = (StatDataItem)arItems.get(nItemIndex);
                    sb.append("\n\t['" + item.getStatTimeAsString() + "', {" + StatDataItem.getDataMapStr(item.getDataMap()) + "}],");
                }
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("\n];");
        }
        String result = sb.toString();
        sb.setLength(0);
        return result;
    }

    private static Object[][] orderTimingData(Map _valData) {
        int nMapSize = _valData.size();
        Object[][] result = new Object[nMapSize][2];
        Iterator entries = _valData.entrySet().iterator();
        HashMap hIndex = new HashMap(nMapSize);
        int[] arIndex = new int[nMapSize];
        int nCount = 0;
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Integer index = (Integer)((Map)entry.getValue()).get(MAPDATA_INDEX);
            hIndex.put(index, entry.getKey());
            arIndex[nCount++] = index;
        }
        for (int nPosFlag = arIndex.length; nPosFlag != 2; --nPosFlag) {
            int nExchangeCouter = 0;
            for (int i = 0; i < nPosFlag - 1; ++i) {
                boolean bExchangeCondition;
                int former = arIndex[i];
                int later = arIndex[i + 1];
                boolean bl = bExchangeCondition = former > later;
                if (!bExchangeCondition) continue;
                arIndex[i] = later;
                arIndex[i + 1] = former;
                ++nExchangeCouter;
            }
            if (nExchangeCouter == 0) break;
        }
        for (int i = 0; i < arIndex.length; ++i) {
            Object key = hIndex.get(new Integer(arIndex[i]));
            Map hData = (Map)_valData.get(key);
            hData.remove(MAPDATA_INDEX);
            result[i] = new Object[]{key, hData};
        }
        return result;
    }

    public static String getUserNameById(String _sUserId) {
        String result = null;
        try {
            User user = User.findById(Integer.parseInt(_sUserId));
            result = user.getName();
        }
        catch (Exception ex) {
            result = I18NMessage.get(TimingChartData.class, "TimingChartData.label5", "\u7528\u6237[ID=") + _sUserId + "]";
        }
        return result;
    }

    public static String getGroupNameById(String _sGroupId) {
        String result = null;
        try {
            Group group = Group.findById(Integer.parseInt(_sGroupId));
            result = group.getName();
        }
        catch (Exception ex) {
            result = I18NMessage.get(TimingChartData.class, "TimingChartData.label6", "\u7ec4\u7ec7[ID=") + _sGroupId + "]";
        }
        return result;
    }
}

