/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.ExtendedField;
import com.trs.cms.content.WCMSystemObject;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ContentExtField;
import com.trs.components.wcm.content.persistent.ContentExtFields;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.TableInfo;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;

public class ContentExtFieldMgr {
    private static Logger logger = Logger.getLogger(ContentExtFieldMgr.class);
    private static final String CONEXTFIELD_INVALID_DESC = I18NMessage.get(ContentExtFieldMgr.class, "ContentExtFieldMgr.label1", "\u65e0\u6548\u7684\u6269\u5c55\u5b57\u6bb5!");
    private static final String BASECHANNEL_INVALID_DESC = I18NMessage.get(ContentExtFieldMgr.class, "ContentExtFieldMgr.label2", "\u6307\u5b9a\u7684\u7ad9\u70b9/\u9891\u9053\u8fd9\u65e0\u6548!");

    public ContentExtField save(CMSObj _host, ContentExtField _extfield, boolean _bDoWithChildren) throws WCMException {
        this.assertNotNull(_host, BASECHANNEL_INVALID_DESC);
        this.assertNotNull(_extfield, CONEXTFIELD_INVALID_DESC);
        if (_extfield.isAddMode()) {
            _extfield.setObjId(_host.getId());
            _extfield.setObjType(_host.getWCMType());
        }
        User user = this.getLoginUser();
        _extfield.save(user);
        if (_bDoWithChildren) {
            this.addExtFieldToChildren(_host, _extfield);
        }
        return _extfield;
    }

    public void addExtField(CMSObj _host, ContentExtField _extfield, int i) throws WCMException {
        ContentExtField extfield = this.findMine((BaseChannel)_host, _extfield.getExtFieldId());
        if (extfield != null) {
            return;
        }
        extfield = (ContentExtField)_extfield.cloneToNewObj();
        extfield.setProperty("EXTORDER", i);
        this.save(_host, extfield, false);
    }

    public void addExtFieldToSpeicficChildren(String _sSiteids, String _sChannelids, ContentExtField _extfield) throws WCMException {
        int i;
        User user = this.getLoginUser();
        Channel child = null;
        WebSite site = null;
        Channels currChannels = null;
        WebSites currWebsites = null;
        ContentExtField childExtfield = null;
        if (_sChannelids.trim().length() > 0) {
            currChannels = Channels.findByIds(user, _sChannelids);
            for (i = 0; i < currChannels.size(); ++i) {
                child = (Channel)currChannels.getAt(i);
                if (child == null || child.getType() != 0 || child.isDeleted() || (childExtfield = this.findMine(child, _extfield.getExtFieldId())) != null) continue;
                childExtfield = (ContentExtField)_extfield.cloneToNewObj();
                int extOrder = this.getMaxOrder(child);
                childExtfield.setProperty("EXTORDER", extOrder);
                this.save(child, childExtfield, false);
            }
        }
        if (_sSiteids.trim().length() > 0) {
            currWebsites = WebSites.findByIds(user, _sSiteids);
            for (i = 0; i < currWebsites.size(); ++i) {
                ContentExtField extfield;
                site = (WebSite)currWebsites.getAt(i);
                if (site == null || site.isDeleted() || (extfield = this.findMine(site, _extfield.getExtFieldId())) != null) continue;
                extfield = (ContentExtField)_extfield.cloneToNewObj();
                this.save(site, extfield, false);
            }
        }
    }

    public void addExtFieldToChildren(CMSObj _host, ContentExtField _extfield) throws WCMException {
        switch (_host.getWCMType()) {
            case 1: {
                WCMFilter filter = new WCMFilter("", "SiteType=? AND Status=0", "");
                filter.addSearchValues(0, _host.getId());
                WebSites sites = WebSites.openWCMObjs(null, filter);
                int nSize = sites.size();
                for (int i = 0; i < nSize; ++i) {
                    WebSite site = (WebSite)sites.getAt(i);
                    if (site == null || site.isDeleted()) continue;
                    ContentExtField extfield = this.findMine(site, _extfield.getExtFieldId());
                    if (extfield == null) {
                        extfield = (ContentExtField)_extfield.cloneToNewObj();
                        this.save(site, extfield, true);
                        continue;
                    }
                    this.addExtFieldToChildren(site, _extfield);
                }
                break;
            }
            case 101: 
            case 103: {
                List<Channel> children = ((BaseChannel)_host).getChildren(this.getLoginUser(), 0);
                Channel child = null;
                ContentExtField childExtfield = null;
                for (int i = 0; i < children.size(); ++i) {
                    child = children.get(i);
                    if (child == null || child.getType() != 0 || child.isDeleted()) continue;
                    childExtfield = this.findMine(child, _extfield.getExtFieldId());
                    if (childExtfield == null) {
                        childExtfield = (ContentExtField)_extfield.cloneToNewObj();
                        int extOrder = this.getMaxOrder(child);
                        childExtfield.setProperty("EXTORDER", extOrder);
                        this.save(child, childExtfield, true);
                        continue;
                    }
                    this.addExtFieldToChildren(child, _extfield);
                }
                break;
            }
        }
    }

    public int getMaxOrder(CMSObj host) throws WCMException {
        DBManager currDBManager = DBManager.getDBManager();
        String sSql = "SELECT MAX(extorder) FROM WCMCONTENTEXTFIELD WHERE objtype=" + host.getWCMType() + " and objid=" + host.getId();
        int nExtOrder = currDBManager.sqlExecuteIntQuery(sSql) + 1;
        return nExtOrder;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public void delete(CMSObj _siteOrChannel, ContentExtField _extfield, boolean _bDoWithChildren) throws WCMException {
        this.assertNotNull(_extfield, CONEXTFIELD_INVALID_DESC);
        User user = this.getLoginUser();
        if (_bDoWithChildren) {
            if (_siteOrChannel instanceof BaseChannel) {
                this.syncDeleteChildrenField((BaseChannel)_siteOrChannel, _extfield);
            } else {
                this.syncDeleteChildrenField((WCMSystemObject)_siteOrChannel, _extfield);
            }
        }
        _extfield.delete(user);
        this.deleteRelatedContent(_extfield);
        this.deletePhysicalInfoIfNecessary(_extfield);
    }

    private void syncDeleteChildrenField(BaseChannel _siteOrChannel, ContentExtField _extfield) throws WCMException {
        List<Channel> children = _siteOrChannel.getAllChildren(this.getLoginUser());
        BaseChannel child = null;
        ContentExtField childExtfield = null;
        for (int i = 0; i < children.size(); ++i) {
            child = children.get(i);
            if (child == null || child.isDeleted()) continue;
            childExtfield = this.findMine(child, _extfield.getExtFieldId());
            if (childExtfield == null) {
                this.syncDeleteChildrenField(child, _extfield);
                continue;
            }
            this.delete(child, childExtfield, true);
        }
    }

    private void syncDeleteChildrenField(WCMSystemObject _siteOrChannel, ContentExtField _extfield) throws WCMException {
        String sWhere = "SiteType=?";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(0, _siteOrChannel.getId());
        WebSites sites = WebSites.openWCMObjs(null, filter);
        BaseChannel child = null;
        ContentExtField childExtfield = null;
        for (int i = 0; i < sites.size(); ++i) {
            child = (BaseChannel)sites.getAt(i);
            if (child == null || child.isDeleted()) continue;
            childExtfield = this.findMine(child, _extfield.getExtFieldId());
            if (childExtfield == null) {
                this.syncDeleteChildrenField(child, _extfield);
                continue;
            }
            this.delete(child, childExtfield, true);
        }
    }

    public ContentExtFields getExtFields(BaseChannel _siteOrChannel, WCMFilter _filter) throws WCMException {
        return this.getExtFields(_siteOrChannel, _filter, false);
    }

    public ContentExtFields getExtFields(CMSObj _host, WCMFilter _filter, boolean _bContainsChildren) throws WCMException {
        this.assertNotNull(_host, BASECHANNEL_INVALID_DESC);
        WCMFilter filter = this.makeHostExtendFilter(_host, _bContainsChildren);
        filter.mergeWith(this.analyze(_filter));
        ContentExtFields fields = new ContentExtFields(this.getLoginUser());
        fields.open(filter);
        if (_bContainsChildren) {
            ContentExtField field = null;
            CMSObj host = null;
            for (int i = 0; i < fields.size(); ++i) {
                field = (ContentExtField)fields.getAt(i);
                if (field == null || (host = field.getHost()) == null || !(host instanceof Channel) || !((Channel)host).isOnlySearch()) continue;
                fields.remove(field, false);
            }
        }
        return fields;
    }

    private WCMFilter makeHostExtendFilter(CMSObj _host, boolean _bContainsChildren) throws WCMException {
        StringBuffer sbWhere;
        WCMFilter filter = new WCMFilter("", "", "wcmcontentextfield.extorder desc");
        switch (_host.getWCMType()) {
            case 1: {
                int nMaxLength = _bContainsChildren ? 400 : 50;
                sbWhere = new StringBuffer(nMaxLength);
                int nSearchIndex = 0;
                sbWhere.append("(ObjId=? and ObjType=?)");
                filter.addSearchValues(nSearchIndex++, _host.getId());
                filter.addSearchValues(nSearchIndex++, _host.getWCMType());
                if (!_bContainsChildren) break;
                sbWhere.append(" or ");
                sbWhere.append("exists(select WCMWebSite.SiteId from WCMWebSite where WCMWebSite.SiteType=? and WCMCONTENTEXTFIELD.ObjType=103 and WCMCONTENTEXTFIELD.ObjId=WCMWebSite.SiteId AND Status=0)");
                filter.addSearchValues(nSearchIndex++, _host.getId());
                sbWhere.append(" or ");
                sbWhere.append("exists(select WCMChannel.ChannelId from WCMChannel where WCMCONTENTEXTFIELD.ObjType=101 and WCMCONTENTEXTFIELD.ObjId=WCMChannel.ChannelId and exists(select WCMWebSite.SiteId from WCMWebSite where WCMWebSite.SiteType=? and WCMCHANNEL.SiteId=WCMWebSite.SiteId) AND Status=0)");
                filter.addSearchValues(nSearchIndex++, _host.getId());
                break;
            }
            case 103: {
                int nMaxLength = _bContainsChildren ? 300 : 50;
                sbWhere = new StringBuffer(nMaxLength);
                int nSearchIndex = 0;
                sbWhere.append("(ObjId=? and ObjType=?)");
                filter.addSearchValues(nSearchIndex++, _host.getId());
                filter.addSearchValues(nSearchIndex++, _host.getWCMType());
                if (!_bContainsChildren) break;
                sbWhere.append(" or ");
                sbWhere.append("exists(select WCMChannel.ChannelId from WCMChannel where WCMCONTENTEXTFIELD.ObjType=101 and WCMCONTENTEXTFIELD.ObjId=WCMChannel.ChannelId and exists(select WCMWebSite.SiteId from WCMWebSite where WCMWebSite.SiteId=? and WCMCHANNEL.SiteId=WCMWebSite.SiteId) AND Status=0)");
                filter.addSearchValues(nSearchIndex++, _host.getId());
                break;
            }
            case 101: {
                int nMaxLength = _bContainsChildren ? 200 : 50;
                sbWhere = new StringBuffer(nMaxLength);
                if (_bContainsChildren) {
                    sbWhere.append("ObjType=? and ObjId in(?");
                    filter.addSearchValues(0, _host.getWCMType());
                    filter.addSearchValues(1, _host.getId());
                    this.makeChildrenWhere(filter, sbWhere, (Channel)_host);
                    sbWhere.append(")");
                    break;
                }
                sbWhere.append("(ObjId=? and ObjType=?)");
                filter.addSearchValues(0, _host.getId());
                filter.addSearchValues(1, _host.getWCMType());
                break;
            }
            default: {
                throw new WCMException(I18NMessage.get(ContentExtFieldMgr.class, "ContentExtFieldMgr.label3", "\u672a\u77e5\u7c7b\u578b[HostType=") + _host.getWCMType() + ",HostId=" + _host.getId() + "]\uff01");
            }
        }
        filter.setWhere(sbWhere.toString());
        return filter;
    }

    private void makeChildrenWhere(WCMFilter _filter, StringBuffer _sbWhere, Channel _parent) throws WCMException {
        List<Channel> lChildren = _parent.getChildren(null);
        if (lChildren == null || lChildren.isEmpty()) {
            return;
        }
        Channel child = null;
        int nSize = lChildren.size();
        for (int i = 0; i < nSize; ++i) {
            child = lChildren.get(i);
            if (child == null || child.isDeleted()) continue;
            _sbWhere.append(",?");
            _filter.addSearchValues(_filter.getSearchValues().size(), child.getId());
            this.makeChildrenWhere(_filter, _sbWhere, child);
        }
    }

    private WCMFilter analyze(WCMFilter _filter) throws WCMException {
        if (_filter == null) {
            return null;
        }
        String where = "WCMContentExtField.ExtFieldId=WCMExtField.ExtFieldId";
        try {
            String sWhere = this.analyzePart(_filter.getWhere());
            if (this.empty(sWhere)) {
                _filter.setWhere(where);
            } else {
                _filter.setWhere(where + " AND (" + this.analyzePart(_filter.getWhere()) + ")");
            }
            _filter.setOrder(_filter.getOrder());
        }
        catch (WCMException e) {
            throw new WCMException(1100, I18NMessage.get(ContentExtFieldMgr.class, "ContentExtFieldMgr.label4", "\u5206\u6790\u68c0\u7d22\u6761\u4ef6\u51fa\u9519!"), e);
        }
        _filter.setSelect("");
        _filter.setFrom("WCMContentExtField,WCMExtField");
        return _filter;
    }

    private String analyzePart(String _sPart) throws WCMException {
        if (this.empty(_sPart)) {
            return "";
        }
        String sWhere = _sPart;
        Enumeration fields = this.getTableFields("WCMEXTFIELD");
        while (fields.hasMoreElements()) {
            sWhere = this.appendPreTableName(sWhere, (String)fields.nextElement(), "WCMEXTFIELD");
        }
        return sWhere;
    }

    private Enumeration getTableFields(String _sTableName) throws WCMException {
        DBManager manager = DBManager.getDBManager();
        TableInfo info = manager.getTableInfo(_sTableName);
        return info.getFieldNames();
    }

    private String appendPreTableName(String _sExpression, String _sFieldName, String _sTableName) {
        if (_sExpression == null) {
            return "";
        }
        if (this.empty(_sFieldName)) {
            return _sExpression;
        }
        String sSrcExpress = _sExpression;
        String sFieldName = _sFieldName.toUpperCase();
        int nFieldLen = sFieldName.length();
        int nStartPose = 0;
        do {
            char chEnd;
            int nEndPose;
            String sTemp;
            if ((nStartPose = (sTemp = sSrcExpress.toUpperCase()).indexOf(sFieldName, nStartPose)) < 0) {
                return sSrcExpress;
            }
            if (nStartPose > 0) {
                char chStart = sTemp.charAt(nStartPose - 1);
                if (chStart >= 'A' && chStart <= 'Z') continue;
                if (chStart == '.') {
                    nStartPose += nFieldLen;
                    continue;
                }
            }
            if ((nEndPose = nStartPose + nFieldLen) < sTemp.length() && (chEnd = sTemp.charAt(nEndPose)) >= 'A' && chEnd <= 'Z') {
                nStartPose += nFieldLen;
                continue;
            }
            String sNewFieldName = _sTableName + "." + sFieldName;
            sSrcExpress = sSrcExpress.substring(0, nStartPose) + sNewFieldName + sSrcExpress.substring(nEndPose);
            nStartPose += sNewFieldName.length();
        } while (nStartPose >= 0 && nStartPose < sSrcExpress.length());
        return sSrcExpress;
    }

    private boolean empty(String _string) {
        return _string == null || _string.trim().length() == 0;
    }

    private void assertNotNull(Object _object, String _sDesc) throws WCMException {
        if (_object == null) {
            throw new WCMException(10, _sDesc);
        }
    }

    private void deleteRelatedContent(ContentExtField _extfield) throws WCMException {
        String fieldName = null;
        try {
            fieldName = _extfield.getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (CMyString.isEmpty(fieldName)) {
            return;
        }
        if (101 == _extfield.getObjType() && "WCMDOCUMENT".equals(_extfield.getTableName())) {
            String sql = " SET " + fieldName + "=null Where DocChannel=" + _extfield.getObjId();
            String[] tablesql = new String[]{"UPDATE WCMDOCUMENT" + sql, "UPDATE WCMDOCBAK" + sql};
            DBManager.getDBManager().sqlExecuteUpdate(tablesql);
        }
    }

    private void deletePhysicalInfoIfNecessary(ContentExtField _extfield) throws WCMException {
        if (this.isInUse(_extfield)) {
            return;
        }
        ExtendedField physicalField = ExtendedField.findById(_extfield.getExtFieldId());
        if (logger.isDebugEnabled()) {
            String msg = I18NMessage.get(ContentExtFieldMgr.class, "ContentExtFieldMgr.label5", "\u7cfb\u7edf\u6570\u636e\u53ef\u80fd\u51fa\u73b0\u5f02\u5e38:\nextfield[") + _extfield.getExtFieldId() + "," + _extfield.getDesc() + "]@" + _extfield.getHost() + I18NMessage.get(ContentExtFieldMgr.class, "ContentExtFieldMgr.label6", "\u5bf9\u5e94\u7684\u7269\u7406\u5b57\u6bb5\u7f3a\u5931!");
            logger.debug((Object)msg);
        }
        if (physicalField != null) {
            physicalField.delete(this.getLoginUser());
        }
    }

    private ContentExtField findMine(BaseChannel _siteOrChannel, int _nExtfieldId) throws WCMException {
        String sWhere = "ExtFieldId=" + _nExtfieldId;
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        aFilter.setMaxRowNumber(1);
        ContentExtFields extfields = this.getExtFields(_siteOrChannel, aFilter);
        if (extfields.isEmpty()) {
            return null;
        }
        return (ContentExtField)extfields.getAt(0);
    }

    private boolean isInUse(ContentExtField _extfield) throws WCMException {
        String sSql = "SELECT COUNT(*) FROM WCMCONTENTEXTFIELD WHERE ExtFieldId=" + _extfield.getExtFieldId();
        return DBManager.getDBManager().sqlExecuteIntQuery(sSql) > 0;
    }
}

