/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.process;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.FlowAction;
import com.trs.cms.process.engine.ExecuteContext;
import com.trs.cms.process.engine.IActionHandler;
import com.trs.cms.process.engine.handlers.ActionParametersAnalyser;
import com.trs.components.infoview.db.InfoviewXMLDataUpdator;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.List;
import org.apache.log4j.Logger;

public class DelRepeatSectionForCurrUser
implements IActionHandler {
    private static Logger logger = Logger.getLogger(DelRepeatSectionForCurrUser.class);

    @Override
    public boolean execute(ExecuteContext _context, FlowAction _action) throws WCMException {
        IFlowContent content = _context.getFlowContent();
        if (content.getContentType() != 605) {
            return false;
        }
        String currUserName = _context.getFlowContext().getCurrUser().getName();
        if (CMyString.isEmpty(currUserName)) {
            logger.error((Object)"\u6ca1\u6709\u83b7\u53d6\u5230\u5f53\u524d\u64cd\u4f5c\u7684postUser\u7528\u6237\uff01");
            return false;
        }
        Document document = (Document)content.getSubinstance();
        ActionParametersAnalyser parameter = new ActionParametersAnalyser(_action.getParams());
        String sRepeatSectionName = parameter.getParameterValue("RepeatField");
        String sUserNameFieldName = parameter.getParameterValue("ReplyDep");
        if (CMyString.isEmpty(sRepeatSectionName) || CMyString.isEmpty(sUserNameFieldName)) {
            logger.error((Object)"\u5f53\u524d\u5de5\u4f5c\u6d41\u4e2d\u672a\u8bbe\u7f6e\u5b58\u50a8\u5f53\u524d\u7528\u6237\u4fe1\u606f\u7684\u5b57\u6bb5\u540d\uff01");
            return false;
        }
        InfoviewXMLDataUpdator oUpdator = new InfoviewXMLDataUpdator(document.getContent());
        List userList = oUpdator.getFieldValue(sUserNameFieldName);
        if (userList == null) {
            return false;
        }
        for (int i = 0; i < userList.size(); ++i) {
            String sUserName = (String)userList.get(i);
            if (!sUserName.equals(currUserName)) continue;
            oUpdator.setRemoveField(sRepeatSectionName, i + 1);
        }
        String sNewContent = oUpdator.update(null);
        document.setContent(sNewContent);
        document.save();
        return false;
    }

    public static void main(String[] args) throws WCMException {
        ContextHelper.initContext(User.findByName("admin"));
        DelRepeatSectionForCurrUser handle = new DelRepeatSectionForCurrUser();
        handle.execute(null, null);
    }
}

