/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.extract;

import com.trs.components.infoview.InfoViewConfig;
import com.trs.components.infoview.extract.DataGroup;
import com.trs.components.infoview.extract.DataType;
import com.trs.components.infoview.extract.manifest.CalculatedField;
import com.trs.components.infoview.extract.manifest.Manifest;
import com.trs.components.infoview.extract.manifest.MenuButton;
import com.trs.components.infoview.extract.manifest.View;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class XSLTViewBuilder {
    public static final String FLAG_TRS_OBJ_TYPENAME = "trs_obj_typename";
    public static final String FLAG_TRS_OBJ_TYPE = "trs_obj_type";
    public static final String FLAG_TRS_OBJ_ID = "trs_obj_id";
    public static final String FLAG_TRS_OBJ_PUB = "trs_obj_publish";
    public static final String NAME_DATA_SECTION = "DataSection";
    public static final String NAME_DATA_FIELD = "DataField";
    public static final String TYPE_DATA_SECTION = String.valueOf(1107);
    public static final String TYPE_DATA_FIELD = String.valueOf(1105);
    private String m_sXSDURI;
    private String m_sXSDPrefix;
    private String m_sXSLURI;
    private String m_sXSLPrefix;
    private Manifest m_oManifest;
    private InfoViewConfig m_oIVConfig;
    private List m_oGroupList;
    private List m_oTypeList;
    private DataType m_oRootType;
    private Element m_oRootTemplate;
    private Element m_oFormTemplate;
    private HashMap m_oMapTemplates;

    public void init(InfoViewConfig ivConfig, Manifest manifest, List groupList, DataType rootType, List typeList) {
        this.m_oIVConfig = ivConfig;
        this.m_oManifest = manifest;
        this.m_oGroupList = groupList;
        this.m_oRootType = rootType;
        this.m_oTypeList = typeList;
    }

    public void build(View view) {
        Element root = view.getDOM4JDocument().getRootElement();
        if (root == null) {
            return;
        }
        this.prepare(root, view.getViewWidth());
        view.setXSLPrefix(this.m_sXSLPrefix);
        this.reformElementChildren(this.m_oRootTemplate, "");
        this.reformTopSection(root, view);
    }

    void addTemplateXML(String sTemplateContent) {
        Element textarea = this.m_oFormTemplate.addElement("textarea");
        textarea.addAttribute("name", "ObjectXML");
        textarea.addAttribute("style", "display:none");
        textarea.setText(sTemplateContent);
    }

    private void prepare(Element root, String sViewWidth) {
        Namespace ns = null;
        this.m_sXSLURI = "http://www.w3.org/1999/XSL/Transform";
        this.m_sXSDURI = this.m_oManifest.getRootSchemaURI();
        ns = root.getNamespaceForURI(this.m_sXSLURI);
        this.m_sXSLPrefix = ns.getPrefix();
        ns = root.getNamespaceForURI(this.m_sXSDURI);
        this.m_sXSDPrefix = ns.getPrefix();
        this.m_oMapTemplates = new HashMap();
        this.addOutputIndent(root);
        Iterator itr = root.elementIterator("template");
        while (itr.hasNext()) {
            Element templateElement = (Element)itr.next();
            String mode = templateElement.attributeValue("mode");
            if (mode == null) {
                this.m_oRootTemplate = templateElement;
                continue;
            }
            Object oValue = this.m_oMapTemplates.get(mode);
            if (oValue == null) {
                this.m_oMapTemplates.put(mode, templateElement);
                continue;
            }
            if (oValue instanceof ArrayList) {
                ((ArrayList)oValue).add(templateElement);
                continue;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            arrayList.add(oValue);
            arrayList.add(templateElement);
            this.m_oMapTemplates.put(mode, arrayList);
        }
        Element head = (Element)this.m_oRootTemplate.selectSingleNode(".//head");
        this.addScript(head);
        this.addStyle(head);
    }

    private void addOutputIndent(Element root) {
        Element elOutput = root.element("output");
        if (elOutput != null) {
            elOutput.addAttribute("indent", "yes");
        }
    }

    private void addScript(Element head) {
        String[] saScript = CMyString.split(this.m_oIVConfig.getScriptURI(), ",");
        for (int i = 0; i < saScript.length; ++i) {
            Element scriptElement = head.addElement("script");
            scriptElement.addAttribute("language", "JavaScript");
            scriptElement.addAttribute("src", saScript[i]);
        }
    }

    private void addStyle(Element head) {
        String[] saStyle = CMyString.split(this.m_oIVConfig.getStyleURI(), ",");
        for (int i = 0; i < saStyle.length; ++i) {
            Element styleElement = head.addElement("link");
            styleElement.addAttribute("rel", "stylesheet");
            styleElement.addAttribute("type", "text/css");
            styleElement.addAttribute("href", saStyle[i]);
        }
    }

    private void reformTopSection(Element root, View view) {
        for (Element elDiv : this.m_oRootTemplate.selectNodes("//div")) {
            String sBindname = this.findChildSection(elDiv, view);
            if (sBindname != null) continue;
            sBindname = this.findChildTable(elDiv, view);
        }
    }

    private Element getTemplate(String _sMode, String _sCallSelect) {
        Object elTemplate = this.m_oMapTemplates.get(_sMode);
        if (elTemplate == null) {
            return null;
        }
        if (elTemplate instanceof ArrayList) {
            if (_sCallSelect == null) {
                return null;
            }
            ArrayList oTmpList = (ArrayList)elTemplate;
            try {
                for (Element element : oTmpList) {
                    String sMatch = element.attributeValue("match");
                    if (!_sCallSelect.equals(sMatch) && !_sCallSelect.endsWith("/" + sMatch)) continue;
                    return element;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        if (elTemplate instanceof Element) {
            return (Element)elTemplate;
        }
        return null;
    }

    private String findChildSection(Element elDiv, View view) {
        Element elAT = elDiv.element("apply-templates");
        if (elAT == null) {
            return null;
        }
        String mode = elAT.attributeValue("mode");
        if (mode == null) {
            return null;
        }
        Element elTemplate = this.getTemplate(mode, elAT.attributeValue("select"));
        if (elTemplate == null) {
            return null;
        }
        Element elCtrl = elTemplate.element("div");
        if (elCtrl == null) {
            return null;
        }
        String sCtrlName = elCtrl.attributeValue("xctname");
        if (sCtrlName == null) {
            return null;
        }
        if ("RepeatingSection".equalsIgnoreCase(sCtrlName) || "Section".equalsIgnoreCase(sCtrlName)) {
            elCtrl.addAttribute(FLAG_TRS_OBJ_TYPENAME, NAME_DATA_SECTION);
            elCtrl.addAttribute(FLAG_TRS_OBJ_TYPE, TYPE_DATA_SECTION);
            String sBindName = elCtrl.attributeValue("trs_temp_id");
            if (sBindName != null) {
                this.m_oGroupList.add(new DataGroup(sBindName, elCtrl, view));
            }
            return sBindName;
        }
        return null;
    }

    private String findChildTable(Element elDiv, View view) {
        Element elTable = elDiv.element("table");
        if (elTable == null) {
            return null;
        }
        Iterator itr = elTable.elementIterator("tbody");
        while (itr.hasNext()) {
            Element elTbody = (Element)itr.next();
            String sCtrlName = elTbody.attributeValue("xctname");
            if (!"RepeatingTable".equalsIgnoreCase(sCtrlName)) continue;
            elTbody.addAttribute(FLAG_TRS_OBJ_TYPENAME, NAME_DATA_SECTION);
            elTbody.addAttribute(FLAG_TRS_OBJ_TYPE, TYPE_DATA_SECTION);
            String sBindName = elTbody.attributeValue("trs_temp_id");
            if (sBindName != null) {
                this.m_oGroupList.add(new DataGroup(sBindName, elTbody, view));
            }
            return sBindName;
        }
        return null;
    }

    private void reformElementChildren(Element element, String sParentXPath) {
        Iterator itr = element.elementIterator();
        while (itr.hasNext()) {
            this.reformElementSelf((Element)itr.next(), sParentXPath);
        }
    }

    private void reformElementSelf(Element element, String sParentXPath) {
        String sThisXPath = sParentXPath;
        if (this.m_sXSLPrefix.equals(element.getNamespacePrefix())) {
            sThisXPath = this.reformXSLElement(element, sParentXPath);
            if (sThisXPath == null) {
                return;
            }
        } else {
            this.reformHTMLElement(element, sParentXPath);
        }
        this.reformElementChildren(element, sThisXPath);
    }

    private String reformXSLElement(Element element, String sParentXPath) {
        String sSelect = element.attributeValue("select");
        if (sSelect == null) {
            return sParentXPath;
        }
        String sThisXPath = this.appendXPath(sParentXPath, sSelect);
        if ("apply-templates".equals(element.getName())) {
            this.reformXSLTemplate(element, sThisXPath);
            return null;
        }
        return sThisXPath;
    }

    private void reformXSLTemplate(Element element, String sThisXPath) {
        Element elTemplate;
        String sMode = element.attributeValue("mode");
        if (sMode != null && (elTemplate = this.getTemplate(sMode, element.attributeValue("select"))) != null) {
            this.reformElementChildren(elTemplate, sThisXPath);
        }
    }

    private void reformBinding(Element element, String sCtrlName, String sParentXPath) {
        ArrayList list;
        DataType dataType;
        if ("PlainList".equalsIgnoreCase(sCtrlName) || "BulletedList".equalsIgnoreCase(sCtrlName) || "NumberedList".equalsIgnoreCase(sCtrlName) || "ExpressionBox".equalsIgnoreCase(sCtrlName)) {
            return;
        }
        String sBindName = element.attributeValue("binding");
        if (sBindName == null && "RepeatingTable".equalsIgnoreCase(sCtrlName)) {
            sBindName = this.findRepeatingTableBinding(element);
        }
        boolean zInheritParent = false;
        if (sBindName != null) {
            sBindName = this.appendXPath(sParentXPath, sBindName);
        } else {
            zInheritParent = true;
            sBindName = sParentXPath;
        }
        if (sBindName == null || sBindName.length() <= 0) {
            return;
        }
        element.addAttribute("trs_temp_id", sBindName);
        if (zInheritParent) {
            return;
        }
        element.addAttribute("id", sBindName);
        element.addAttribute("name", sBindName);
        CalculatedField cField = this.m_oManifest.getCalculatedField(sBindName);
        if (cField != null) {
            element.addAttribute("trs_calc_expression", CMyString.filterForXsltValue(cField.getExpression()));
            element.addAttribute("trs_calc_refresh", cField.getRefresh());
        }
        if ((dataType = this.m_oRootType.findDataType(sBindName, this.m_sXSDPrefix)) != null) {
            dataType.setDisplayName(element.attributeValue("title"));
            dataType.setBindElement(element);
            dataType.setDisplayFieldType(sCtrlName);
            element.addAttribute(FLAG_TRS_OBJ_TYPENAME, NAME_DATA_FIELD);
            element.addAttribute(FLAG_TRS_OBJ_TYPE, TYPE_DATA_FIELD);
            if (!dataType.isNillable()) {
                element.addAttribute("not_null", "1");
                element.addAttribute("validation", "required:true");
            }
            element.addAttribute("elname", dataType.getDisplayName());
            element.addAttribute("pattern", dataType.getTRSTypeName());
            element.addAttribute("trs_field_name", dataType.getNewBindName());
            if (!this.containsWith(this.m_oTypeList, dataType)) {
                this.m_oTypeList.add(dataType);
            }
        }
        if ((list = this.m_oManifest.getDefaultView().getContextMenuForBinding(sBindName)) != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                MenuButton mb = (MenuButton)list.get(i);
                element.addAttribute(mb.getBindAction(), mb.getCaption());
            }
        }
    }

    private boolean containsWith(List typeList, DataType _oCmpDataType) {
        for (int i = 0; i < typeList.size(); ++i) {
            DataType dataType = (DataType)typeList.get(i);
            if (dataType == null || dataType.getBindName() == null || !dataType.getBindName().equals(_oCmpDataType.getBindName())) continue;
            return true;
        }
        return false;
    }

    private void reformHTMLElement(Element element, String sParentXPath) {
        String sCtrlName;
        if ("div".equals(element.getName()) && element.attributeValue("xmlToEdit") != null) {
            element.addAttribute("style", "display:none");
            return;
        }
        if ("img".equals(element.getName())) {
            this.reformHTMLImage(element);
        }
        if ((sCtrlName = element.attributeValue("xctname")) == null) {
            return;
        }
        if ("InlineImage".equals(sCtrlName)) {
            this.reformHTMLInlineImage(element);
        }
        if ("ExpressionBox".equals(sCtrlName)) {
            this.reformHTMLExpressionBox(element);
        }
        this.reformBinding(element, sCtrlName, sParentXPath);
    }

    private void reformHTMLInlineImage(Element bindElement) {
        Attribute testAttribute;
        Element parentElement;
        Attribute srcAttribute = bindElement.attribute("src");
        if (srcAttribute != null) {
            bindElement.remove(srcAttribute);
        }
        if ((parentElement = bindElement.getParent()) != null && (testAttribute = parentElement.attribute("test")) != null) {
            testAttribute.setValue("1=1");
        }
    }

    private void reformHTMLImage(Element element) {
        Attribute srcAttr = element.attribute("src");
        if (srcAttr == null) {
            return;
        }
        String sCalendar = "res://infopath.exe/calendar.gif";
        if ("res://infopath.exe/calendar.gif".equals(srcAttr.getValue())) {
            srcAttr.setValue("TRSCalendar.gif");
        }
    }

    private void reformHTMLExpressionBox(Element element) {
        Element elIf = element.element("if");
        if (elIf == null) {
            return;
        }
        Element elValueOf = elIf.element("value-of");
        if (elValueOf == null) {
            return;
        }
        Attribute atSelect = elValueOf.attribute("select");
        if (atSelect == null) {
            return;
        }
        element.addAttribute("trs_calc_expression", CMyString.filterForXsltValue(atSelect.getValue()));
        element.addAttribute("trs_calc_refresh", "onChange");
    }

    private String appendXPath(String sParentXPath, String sChildXPath) {
        if (sParentXPath.length() <= 0) {
            return sChildXPath;
        }
        if (sChildXPath.charAt(0) == '/') {
            return sChildXPath;
        }
        if (sChildXPath.equals(".")) {
            return sParentXPath;
        }
        while (sChildXPath.charAt(0) == '.') {
            if (sChildXPath.startsWith("./")) {
                sChildXPath = sChildXPath.substring(2);
                continue;
            }
            if (!sChildXPath.startsWith("../")) continue;
            if (sParentXPath.length() <= 0) {
                return sChildXPath;
            }
            int index = sParentXPath.lastIndexOf(47);
            if (index < 0) {
                index = 0;
            }
            sParentXPath = sParentXPath.substring(0, index);
            sChildXPath = sChildXPath.substring(3);
        }
        if (sParentXPath.length() <= 0) {
            return sChildXPath;
        }
        return sParentXPath + '/' + sChildXPath;
    }

    private String findRepeatingTableBinding(Element element) {
        Element elForEach = element.element("for-each");
        if (elForEach == null) {
            return null;
        }
        Attribute atSelect = elForEach.attribute("select");
        if (atSelect == null) {
            return null;
        }
        return atSelect.getValue();
    }
}

