/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.document;

import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;

public class DocumentTimeRangeHelper {
    public static WCMFilter makeFilterWithTimeLimit(PublishTagContext _context, IPublishFolder _folder) throws WCMException {
        WCMFilter filter = new WCMFilter();
        CMyDateTime dtStart = DocumentTimeRangeHelper.getPublishStartDate(_context, _folder);
        if (dtStart == null) {
            return filter;
        }
        String sDateFieldName = ConfigServer.getServer().getSysConfigValue("PUBLISH_DATE_FIELD", "CrTime");
        String sWhere = "WCMChnlDoc." + sDateFieldName + ">=" + DBManager.getDBManager().getDBType().sqlDate(dtStart.toString());
        filter.setWhere(sWhere);
        return filter;
    }

    public static WCMFilter makeFilterWithTimeLimit(BaseChannel host) throws WCMException {
        WCMFilter filter = new WCMFilter();
        CMyDateTime dtStart = DocumentTimeRangeHelper.getPublishStartDate(host);
        if (dtStart == null) {
            return filter;
        }
        String sDateFieldName = ConfigServer.getServer().getSysConfigValue("PUBLISH_DATE_FIELD", "CrTime");
        String sWhere = "WCMChnlDoc." + sDateFieldName + ">=" + DBManager.getDBManager().getDBType().sqlDate(dtStart.toString());
        filter.setWhere(sWhere);
        return filter;
    }

    public static String makeWhereWithTimeLimit(BaseChannel host) throws WCMException {
        String sWhere = "";
        CMyDateTime dtStart = DocumentTimeRangeHelper.getPublishStartDate(host);
        if (dtStart == null) {
            return sWhere;
        }
        String sDateFieldName = ConfigServer.getServer().getSysConfigValue("PUBLISH_DATE_FIELD", "CrTime");
        sWhere = "WCMChnlDoc." + sDateFieldName + ">=" + DBManager.getDBManager().getDBType().sqlDate(dtStart.toString());
        return sWhere;
    }

    public static CMyDateTime getPublishStartDate(PublishTagContext _context, IPublishFolder _folder) throws WCMException {
        boolean bEnableLimitPublishDate = _context.getAttribute("EnableLimit", true);
        if (!bEnableLimitPublishDate) {
            return null;
        }
        return DocumentTimeRangeHelper.getPublishStartDate((BaseChannel)_folder.getSubstance());
    }

    public static CMyDateTime getPublishStartDate(BaseChannel host) throws WCMException {
        boolean bEnableLimitPublishDate = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("ENABLE_LIMIT_PUBLISH_DATE", "false").trim());
        if (!bEnableLimitPublishDate) {
            return null;
        }
        CMyDateTime dtStart = null;
        while (host != null) {
            dtStart = DocumentTimeRangeHelper.makePublishStartDate(host);
            if (dtStart != null) {
                return dtStart;
            }
            if (host.isSite()) {
                return null;
            }
            host = host.getHost();
        }
        return null;
    }

    private static CMyDateTime makePublishStartDate(CMSObj currSubstance) throws WCMException {
        boolean bEnableLimitPublishDate = "1".equals(currSubstance.getAttributeValue("PublishLimit"));
        if (!bEnableLimitPublishDate) {
            return null;
        }
        String dateTime = CMyString.showEmpty(currSubstance.getAttributeValue("PubStartDate"));
        CMyDateTime dtStart = new CMyDateTime();
        try {
            String timeBegin = "$sysdate";
            if (dateTime.trim().toLowerCase().startsWith(timeBegin)) {
                int time = Integer.parseInt(dateTime.split("-")[1].trim());
                CMyDateTime dt = CMyDateTime.now();
                dtStart = dt.dateAdd(3, time * -1);
            } else {
                dtStart.setDateTimeWithString(dateTime);
            }
            return dtStart;
        }
        catch (CMyException e) {
            throw new WCMException("\u89e3\u6790$sysdate\u51fa\u73b0\u5f02\u5e38", e);
        }
    }
}

