/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms;

import com.trs.cms.auth.persistent.User;
import com.trs.infra.I18NMessage;
import com.trs.infra.cache.CacheLayer;
import com.trs.infra.common.BaseContextHelper;
import com.trs.infra.support.log.LogServer;
import org.apache.batik.dom.util.HashTable;
import org.apache.log4j.Logger;

public class ContextHelper {
    private static Logger logger = Logger.getLogger(ContextHelper.class);
    private static final int ARG_INDEX_USER = BaseContextHelper.getNextIndex();
    private static final int ARG_INDEX_TESTVALUES = BaseContextHelper.getNextIndex();

    public static void initContext(User _loginUser) {
        ContextHelper.setLoginUser(_loginUser);
        ContextHelper.setArg(LogServer.CONTEXT_INDEX_IP, _loginUser.getLoginIP());
    }

    public static User getLoginUser() {
        User loginUser = (User)BaseContextHelper.getArg(ARG_INDEX_USER);
        if (loginUser == null) {
            throw new RuntimeException("fatal error:no current user in threadlocal,iniContext please!");
        }
        return loginUser;
    }

    public static void setLoginUser(User _currUser) {
        if (_currUser.getName().equalsIgnoreCase("system")) {
            logger.debug((Object)I18NMessage.get(ContextHelper.class, "ContextHelper.label1", "\u8c01\u4f7f\u7528System\u521d\u59cb\u5316ContextHelper?"), (Throwable)new Exception());
        }
        BaseContextHelper.setArg(ARG_INDEX_USER, _currUser);
    }

    public static HashTable getTestValues() {
        HashTable hTestValues = (HashTable)BaseContextHelper.getArg(ARG_INDEX_TESTVALUES);
        if (hTestValues == null) {
            throw new RuntimeException("fatal error:no current user in threadlocal,iniContext please!");
        }
        return hTestValues;
    }

    public static void setTestValues(HashTable _hValues) {
        BaseContextHelper.setArg(ARG_INDEX_TESTVALUES, _hValues);
    }

    public static Object getArg(int _nIndex) {
        return BaseContextHelper.getArg(_nIndex);
    }

    public static int setArg(int _nIndex, Object _currObj) {
        return BaseContextHelper.setArg(_nIndex, _currObj);
    }

    public static void clear() {
        BaseContextHelper.clear();
        CacheLayer.clear();
    }
}

