/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.TemplateEmployMgrHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateEmploy;
import com.trs.components.common.publish.persistent.template.TemplateEmploys;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.util.ArrayList;

public class TemplateServiceHelperProvider
implements IGlueServiceProvider {
    private TemplateEmployMgr m_oEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");

    public void setChannelEmployersOfTemplate(MethodContext _context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nTemplateId = _context.getValue("TemplateId", 0);
        Template template = Template.findById(nTemplateId);
        if (template == null) {
            throw new WCMException(I18NMessage.get(TemplateServiceHelperProvider.class, "TemplateServiceHelperProvider.label9", "\u6a21\u677f[ID=") + nTemplateId + I18NMessage.get(TemplateServiceHelperProvider.class, "TemplateServiceHelperProvider.label1", "]\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01"));
        }
        this.validateRight(loginUser, template, 24, I18NMessage.get(TemplateServiceHelperProvider.class, "TemplateServiceHelperProvider.label2", "\u8bbe\u7f6e"));
        boolean bSetDefaultTemplate = _context.getValue("SetDefaultTemplate", true);
        String sEmployOnSite = _context.getValue("EmployOnSite");
        if (sEmployOnSite != null && template.getFolderType() == 103) {
            IPublishFolder siteFolder = template.getFolder();
            if (!siteFolder.isCanDoSave(loginUser) && !AuthServer.hasRight(loginUser, siteFolder.getSubstance(), 9)) {
                throw new WCMException(I18NMessage.get(TemplateServiceHelperProvider.class, "TemplateServiceHelperProvider.label3", "\u60a8[") + loginUser.getName() + I18NMessage.get(TemplateServiceHelperProvider.class, "TemplateServiceHelperProvider.label4", "]\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u6a21\u677f\u6240\u5c5e\u7ad9\u70b9\u8bbe\u7f6e\u6a21\u677f\uff01"));
            }
            boolean bEmployOnSite = _context.getValue("EmployOnSite", false);
            if (!bEmployOnSite) {
                this.clearEmploymentOfEmployer(siteFolder, template);
            } else if (bSetDefaultTemplate) {
                this.setDefaultTemplate(siteFolder, template);
            } else {
                TemplateEmployMgrHelper.setOtherOutlinesOfSite(siteFolder, template);
            }
        }
        if (bSetDefaultTemplate) {
            String sChannelIds = _context.getValue("ChannelIds");
            if (CMyString.isEmpty(sChannelIds)) {
                this.clearEmploymentOfEmployee(template, 101);
                return;
            }
            Channels channels = Channels.findByIds(loginUser, sChannelIds);
            if (channels == null || channels.size() == 0) {
                return;
            }
            String[] sLastEmployeChnlIds = null;
            String sLastHasEmployeChnlIds = this.getAllEmployMentOfEmployee(template, 101);
            if (!sLastHasEmployeChnlIds.equals("")) {
                sLastEmployeChnlIds = sLastHasEmployeChnlIds.split(",");
            }
            ArrayList<String> aLastEmployeChnlIds = new ArrayList<String>();
            ArrayList<String> aNewEmployeChnlIds = new ArrayList<String>();
            if (sLastEmployeChnlIds != null) {
                for (int k = 0; k < sLastEmployeChnlIds.length; ++k) {
                    aLastEmployeChnlIds.add(sLastEmployeChnlIds[k]);
                }
            }
            for (int i = 0; i < channels.size(); ++i) {
                Channel channel = (Channel)channels.getAt(i);
                int nChannelId = channel.getId();
                aNewEmployeChnlIds.add(String.valueOf(nChannelId));
                if (aLastEmployeChnlIds != null && aLastEmployeChnlIds.contains(String.valueOf(nChannelId))) continue;
                IPublishElement chlFolder = PublishElementFactory.lookupElement(101, channel.getId());
                this.setDefaultTemplate(chlFolder, template);
            }
            for (int m = 0; m < aLastEmployeChnlIds.size(); ++m) {
                if (aNewEmployeChnlIds.contains(aLastEmployeChnlIds.get(m))) continue;
                int nChnlId = Integer.parseInt(String.valueOf(aLastEmployeChnlIds.get(m)));
                this.clearEmploymentOfChnlEmployer(nChnlId, template);
            }
        } else {
            TemplateEmployMgrHelper.setOtherOutlinesOfChannels(_context, template);
        }
    }

    private String getAllEmployMentOfEmployee(Template _template, int _nEmployerType) throws WCMException {
        if (_template == null) {
            return null;
        }
        String sWhere = "TEMPLATETYPE=? AND EMPLOYERTYPE=? AND TEMPLATEID=? AND ISDEFAULT=?";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(0, _template.getType());
        filter.addSearchValues(1, _nEmployerType);
        filter.addSearchValues(2, _template.getId());
        filter.addSearchValues(3, 1);
        TemplateEmploys employs = TemplateEmploys.openWCMObjs(ContextHelper.getLoginUser(), filter);
        String sHasEmployedChnlIds = "";
        for (int i = 0; i < employs.size(); ++i) {
            TemplateEmploy employ = (TemplateEmploy)employs.getAt(i);
            int nChannelId = employ.getEmployerId();
            sHasEmployedChnlIds = i == employs.size() - 1 ? sHasEmployedChnlIds + nChannelId : sHasEmployedChnlIds + nChannelId + ",";
        }
        return sHasEmployedChnlIds;
    }

    private void clearEmploymentOfChnlEmployer(int nChnlId, Template _template) throws WCMException {
        if (_template == null || nChnlId == 0) {
            return;
        }
        String sWhere = "TEMPLATETYPE=? AND EMPLOYERTYPE=? AND TEMPLATEID=? AND ISDEFAULT=? AND EMPLOYERID=?";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(0, _template.getType());
        filter.addSearchValues(1, 101);
        filter.addSearchValues(2, _template.getId());
        filter.addSearchValues(3, 1);
        filter.addSearchValues(4, nChnlId);
        TemplateEmploys employs = TemplateEmploys.openWCMObjs(ContextHelper.getLoginUser(), filter);
        employs.removeAll(true);
    }

    private int clearEmploymentOfEmployer(IPublishElement _employer, Template _template) throws WCMException {
        if (_employer == null || _template == null) {
            return 0;
        }
        String sWhere = "EMPLOYERID=? AND EMPLOYERTYPE=? AND TEMPLATEID=? AND ISDEFAULT=?";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(0, _employer.getId());
        filter.addSearchValues(1, _employer.getType());
        filter.addSearchValues(2, _template.getId());
        filter.addSearchValues(3, 1);
        TemplateEmploys employs = TemplateEmploys.openWCMObjs(ContextHelper.getLoginUser(), filter);
        int nRecord = employs.size();
        employs.removeAll(true);
        return nRecord;
    }

    private int clearEmploymentOfEmployee(Template _template, int _nEmployerType) throws WCMException {
        if (_template == null) {
            return 0;
        }
        String sWhere = "TEMPLATETYPE=? AND EMPLOYERTYPE=? AND TEMPLATEID=? AND ISDEFAULT=?";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(0, _template.getType());
        filter.addSearchValues(1, _nEmployerType);
        filter.addSearchValues(2, _template.getId());
        filter.addSearchValues(3, 1);
        TemplateEmploys employs = TemplateEmploys.openWCMObjs(ContextHelper.getLoginUser(), filter);
        int nRecord = employs.size();
        employs.removeAll(true);
        return nRecord;
    }

    private void setDefaultTemplate(IPublishElement _publishElement, Template _template) throws Throwable {
        if (_publishElement == null || _template == null) {
            return;
        }
        User loginUser = this.getLoginUser();
        if (!_publishElement.isCanDoSave(loginUser) && !AuthServer.hasRight(loginUser, _publishElement.getSubstance(), 9)) {
            throw new WCMException(I18NMessage.get(TemplateServiceHelperProvider.class, "TemplateServiceHelperProvider.label5", "\u60a8\u6ca1\u6709\u6743\u9650\u8bbe\u7f6e\uff1a") + _publishElement.getInfo() + I18NMessage.get(TemplateServiceHelperProvider.class, "TemplateServiceHelperProvider.label6", "\u7684\u6a21\u677f\uff01"));
        }
        int nTemplateType = _template.getType();
        int nTemplateId = _template.getId();
        if (_publishElement.isFolder()) {
            switch (nTemplateType) {
                case 2: {
                    this.m_oEmployMgr.setDetailTemplate(_publishElement, nTemplateId, false);
                    break;
                }
                case 3: {
                    this.m_oEmployMgr.setDetailTemplate((IPublishFolder)_publishElement, nTemplateId, false, 3);
                    break;
                }
                case 1: {
                    this.m_oEmployMgr.setDefaultOutline((IPublishFolder)_publishElement, nTemplateId);
                    break;
                }
            }
        } else {
            this.m_oEmployMgr.setDetailTemplate(_publishElement, nTemplateId, false);
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void validateRight(User _loginUser, IPublishFolder _folder, int _nRightIndex, String _sOperDesc) throws WCMException {
        if (AuthServer.hasRight(_loginUser, _folder.getSubstance(), _nRightIndex)) {
            return;
        }
        IPublishFolder parent = _folder.getParent();
        if (parent == null || parent == _folder) {
            throw new WCMException(I18NMessage.get(TemplateServiceHelperProvider.class, "TemplateServiceHelperProvider.label7", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + _loginUser.getName() + I18NMessage.get(TemplateServiceHelperProvider.class, "TemplateServiceHelperProvider.label8", "]\u6ca1\u6709\u6743\u9650\u6267\u884c") + _sOperDesc + "\uff01");
        }
        this.validateRight(_loginUser, parent, _nRightIndex, _sOperDesc);
    }

    private void validateRight(User _loginUser, Template _template, int _nRightIndex, String _sOperDesc) throws WCMException {
        if (_loginUser.getName().equalsIgnoreCase(_template.getCrUserName())) {
            return;
        }
        this.validateRight(_loginUser, _template.getFolder(), _nRightIndex, _sOperDesc);
    }

    @Override
    public void delete(MethodContext context) throws Throwable {
    }

    @Override
    public Object query(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public int save(MethodContext context) throws Throwable {
        return 0;
    }

    @Override
    public Object findById(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public Object findByIds(MethodContext context) throws Throwable {
        return null;
    }
}

