/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ejb.access;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.NamingException;
import org.aopalliance.aop.AspectException;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.beans.FatalBeanException;
import org.springframework.jndi.AbstractJndiLocator;

public abstract class AbstractSlsbInvokerInterceptor
extends AbstractJndiLocator
implements MethodInterceptor {
    private boolean cacheHome = true;
    private Object cachedHome;
    private Method createMethod;

    public void setCacheHome(boolean cacheHome) {
        this.cacheHome = cacheHome;
    }

    protected void located(Object jndiObject) {
        this.cachedHome = jndiObject;
        try {
            this.createMethod = this.cachedHome.getClass().getMethod("create", null);
        }
        catch (NoSuchMethodException ex) {
            throw new FatalBeanException("Cannot create EJB proxy: EJB home [" + this.cachedHome + "] has no no-arg create() method");
        }
        this.afterLocated();
    }

    protected void afterLocated() {
    }

    protected Object getCachedEjbHome() {
        return this.cachedHome;
    }

    protected Object create() throws NamingException, InvocationTargetException {
        if (!this.cacheHome) {
            this.lookup();
        }
        try {
            return this.createMethod.invoke(this.cachedHome, null);
        }
        catch (IllegalArgumentException ex) {
            throw new AspectException("Inconsistent state: could not call ejbCreate() method without arguments", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new AspectException("Could not access ejbCreate() method", (Throwable)ex);
        }
    }
}

