/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.util.List;
import org.jfree.data.KeyedObjects2D;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.statistics.MeanAndStandardDeviation;
import org.jfree.data.statistics.StatisticalCategoryDataset;

public class DefaultStatisticalCategoryDataset
extends AbstractDataset
implements StatisticalCategoryDataset,
RangeInfo {
    private KeyedObjects2D data = new KeyedObjects2D();
    private Number minimumRangeValue = new Double(0.0);
    private Number maximumRangeValue = new Double(0.0);
    private Range valueRange = new Range(0.0, 0.0);

    public Number getMeanValue(int row, int column) {
        Number result = null;
        MeanAndStandardDeviation masd = (MeanAndStandardDeviation)this.data.getObject(row, column);
        if (masd != null) {
            result = masd.getMean();
        }
        return result;
    }

    public Number getValue(int row, int column) {
        return this.getMeanValue(row, column);
    }

    public Number getValue(Comparable rowKey, Comparable columnKey) {
        return this.getMeanValue(rowKey, columnKey);
    }

    public Number getMeanValue(Comparable rowKey, Comparable columnKey) {
        Number result = null;
        MeanAndStandardDeviation masd = (MeanAndStandardDeviation)this.data.getObject(rowKey, columnKey);
        if (masd != null) {
            result = masd.getMean();
        }
        return result;
    }

    public Number getStdDevValue(int row, int column) {
        Number result = null;
        MeanAndStandardDeviation masd = (MeanAndStandardDeviation)this.data.getObject(row, column);
        if (masd != null) {
            result = masd.getStandardDeviation();
        }
        return result;
    }

    public Number getStdDevValue(Comparable rowKey, Comparable columnKey) {
        Number result = null;
        MeanAndStandardDeviation masd = (MeanAndStandardDeviation)this.data.getObject(rowKey, columnKey);
        if (masd != null) {
            result = masd.getStandardDeviation();
        }
        return result;
    }

    public int getColumnIndex(Comparable key) {
        return this.data.getColumnIndex(key);
    }

    public Comparable getColumnKey(int column) {
        return this.data.getColumnKey(column);
    }

    public List getColumnKeys() {
        return this.data.getColumnKeys();
    }

    public int getRowIndex(Comparable key) {
        return this.data.getRowIndex(key);
    }

    public Comparable getRowKey(int row) {
        return this.data.getRowKey(row);
    }

    public List getRowKeys() {
        return this.data.getRowKeys();
    }

    public int getRowCount() {
        return this.data.getRowCount();
    }

    public int getColumnCount() {
        return this.data.getColumnCount();
    }

    public void add(double mean, double standardDeviation, Comparable rowKey, Comparable columnKey) {
        MeanAndStandardDeviation item = new MeanAndStandardDeviation(new Double(mean), new Double(standardDeviation));
        this.data.addObject(item, rowKey, columnKey);
        if (mean + standardDeviation > this.maximumRangeValue.doubleValue()) {
            this.maximumRangeValue = new Double(mean + standardDeviation);
            this.valueRange = new Range(this.minimumRangeValue.doubleValue(), this.maximumRangeValue.doubleValue());
        }
        if (mean - standardDeviation < this.minimumRangeValue.doubleValue()) {
            this.minimumRangeValue = new Double(mean - standardDeviation);
            this.valueRange = new Range(this.minimumRangeValue.doubleValue(), this.maximumRangeValue.doubleValue());
        }
        this.fireDatasetChanged();
    }

    public Number getMinimumRangeValue() {
        return this.minimumRangeValue;
    }

    public Number getMaximumRangeValue() {
        return this.maximumRangeValue;
    }

    public Range getValueRange() {
        return this.valueRange;
    }
}

