/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.filters;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.filters.FilterBase;
import org.xmlmiddleware.xmldbms.filters.RelatedTableFilter;
import org.xmlmiddleware.xmldbms.filters.ResultSetFilter;
import org.xmlmiddleware.xmldbms.filters.RootFilter;
import org.xmlmiddleware.xmldbms.filters.TableFilter;
import org.xmlmiddleware.xmldbms.maps.XMLDBMSMap;
import org.xmlmiddleware.xmlutils.XMLName;

public class FilterSet {
    private XMLDBMSMap map;
    private Vector wrapperNames = new Vector();
    private Vector filters = new Vector();
    private Hashtable uris = new Hashtable();
    private Hashtable prefixes = new Hashtable();
    private Hashtable rsNames = new Hashtable();
    private static String ARGUMENT = "Programming error. Argument ";
    private static String NOTNULL = " must not be null.";
    private static String ARG_PREFIX = "prefix";
    private static String ARG_URI = "uri";
    private static final Object O = new Object();

    public FilterSet(XMLDBMSMap xMLDBMSMap) {
        this.map = xMLDBMSMap;
    }

    public final String getNamespaceURI(String string) throws XMLMiddlewareException {
        this.checkArgNull(string, ARG_PREFIX);
        String string2 = (String)this.uris.get(string);
        if (string2 == null) {
            throw new XMLMiddlewareException("Prefix not found: " + string);
        }
        return string2;
    }

    public final String getNamespacePrefix(String string) throws XMLMiddlewareException {
        this.checkArgNull(string, ARG_URI);
        String string2 = (String)this.prefixes.get(string);
        if (string2 == null) {
            throw new XMLMiddlewareException("URI not found: " + string);
        }
        return string2;
    }

    public final Hashtable getNamespaceURIs() {
        return (Hashtable)this.uris.clone();
    }

    public final Hashtable getNamespacePrefixes() {
        return (Hashtable)this.prefixes.clone();
    }

    public void addNamespace(String string, String string2) throws XMLMiddlewareException {
        this.checkArgNull(string, ARG_PREFIX);
        this.checkArgNull(string2, ARG_URI);
        if (this.uris.get(string) != null) {
            throw new XMLMiddlewareException("Prefix already used: " + string);
        }
        if (this.prefixes.get(string2) != null) {
            throw new XMLMiddlewareException("URI already used: " + string2);
        }
        this.uris.put(string, string2);
        this.prefixes.put(string2, string);
    }

    public void removeNamespaceByPrefix(String string) throws XMLMiddlewareException {
        this.checkArgNull(string, ARG_PREFIX);
        String string2 = (String)this.uris.remove(string);
        if (string2 == null) {
            throw new XMLMiddlewareException("Prefix not found: " + string);
        }
        this.prefixes.remove(string2);
    }

    public void removeNamespaceByURI(String string) throws XMLMiddlewareException {
        this.checkArgNull(string, ARG_URI);
        String string2 = (String)this.prefixes.remove(string);
        if (string2 == null) {
            throw new XMLMiddlewareException("URI not found: " + string);
        }
        this.uris.remove(string2);
    }

    public void removeNamespaces() {
        this.uris.clear();
        this.prefixes.clear();
    }

    public final XMLName getWrapperName(int n) {
        return (XMLName)this.wrapperNames.elementAt(n - 1);
    }

    public final Vector getWrapperNames() {
        return (Vector)this.wrapperNames.clone();
    }

    public void addWrapperName(XMLName xMLName, int n) throws XMLMiddlewareException {
        if (n == 0) {
            this.wrapperNames.addElement(xMLName);
            return;
        }
        if (n > 0 && n <= this.wrapperNames.size() + 1) {
            this.wrapperNames.insertElementAt(xMLName, n - 1);
            return;
        }
        throw new XMLMiddlewareException("Invalid nesting level for wrapper element: " + n);
    }

    public void removeWrapperName(int n) throws XMLMiddlewareException {
        if (n > 0 && n <= this.wrapperNames.size()) {
            this.wrapperNames.removeElementAt(n - 1);
            return;
        }
        throw new XMLMiddlewareException("Invalid nesting level for wrapper element name: " + n);
    }

    public void removeAllWrapperNames() {
        this.wrapperNames.removeAllElements();
    }

    public final Vector getFilters() {
        return (Vector)this.filters.clone();
    }

    public RootFilter createRootFilter() {
        RootFilter rootFilter = new RootFilter(this.map);
        this.filters.addElement(rootFilter);
        return rootFilter;
    }

    public ResultSetFilter createResultSetFilter(String string) throws XMLMiddlewareException {
        if (string == null) {
            string = "Default";
        }
        if (this.rsNames.get(string) != null) {
            throw new XMLMiddlewareException("A result set filter for the result set named " + string + " has already been created.");
        }
        this.rsNames.put(string, O);
        ResultSetFilter resultSetFilter = new ResultSetFilter(this.map, string);
        this.filters.addElement(resultSetFilter);
        return resultSetFilter;
    }

    public void removeFilter(int n) throws XMLMiddlewareException {
        if (n >= 0 && n < this.filters.size()) {
            Object e = this.filters.elementAt(n);
            if (e instanceof ResultSetFilter) {
                this.rsNames.remove(((ResultSetFilter)e).getResultSetName());
            }
            this.filters.removeElementAt(n);
            return;
        }
        throw new XMLMiddlewareException("Invalid filter index: " + n);
    }

    public void removeAllFilters() {
        this.filters.removeAllElements();
        this.rsNames.clear();
    }

    public void setFilterParameters(Hashtable hashtable) {
        int n = 0;
        while (n < this.filters.size()) {
            FilterBase filterBase = (FilterBase)this.filters.elementAt(n);
            if (filterBase instanceof RootFilter) {
                ((RootFilter)filterBase).getRootFilterConditions().setParameters(hashtable);
            }
            Enumeration enumeration = filterBase.getTableFilters();
            while (enumeration.hasMoreElements()) {
                TableFilter tableFilter = (TableFilter)enumeration.nextElement();
                Enumeration enumeration2 = tableFilter.getRelatedTableFilters();
                while (enumeration2.hasMoreElements()) {
                    RelatedTableFilter relatedTableFilter = (RelatedTableFilter)enumeration2.nextElement();
                    relatedTableFilter.setParameters(hashtable);
                }
            }
            ++n;
        }
    }

    private void checkArgNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(String.valueOf(ARGUMENT) + string + NOTNULL);
        }
    }
}

