/*
 * Decompiled with CFR 0.152.
 */
package com.trs.weblet.util.verfiycode;

import com.trs.weblet.util.verfiycode.BitMapInputStream;
import com.trs.weblet.util.verfiycode.BitMapOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class BitMapData {
    static final byte[] FILE_TYPE_BYTES = new byte[]{66, 77};
    static final int FILE_TYPE_MAGIC = 19778;
    private byte[][] m_baData;
    private FileHeader m_obBmfh = new FileHeader();
    private InfoHeader m_obBmih = new InfoHeader();

    public int getCompression() {
        return this.m_obBmih.m_uiCompression;
    }

    public void setCompression(int uiCompression) {
        this.m_obBmih.m_uiCompression = uiCompression;
    }

    public int getWidth() {
        return this.m_obBmih.m_uiWidth;
    }

    public void setWidth(int uiWidth) {
        this.m_obBmih.m_uiWidth = uiWidth;
    }

    public int getHeight() {
        return this.m_obBmih.m_uiHeight;
    }

    public void setHeight(int uiHeight) {
        this.m_obBmih.m_uiHeight = uiHeight;
    }

    public byte[] getPalette() {
        return this.m_obBmih.m_baPalette;
    }

    public void setPalette(byte[] baPalette) {
        InfoHeader.access$302(this.m_obBmih, baPalette);
    }

    public int getFileSize() {
        return this.m_obBmfh.m_uiFileSize;
    }

    public byte[] getFileData() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.getDataSize() + 1024);
        BitMapOutputStream bmos = new BitMapOutputStream(baos);
        try {
            this.save(bmos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public int getDataSize() {
        return this.m_obBmih.m_uiDataSize;
    }

    protected int getLineLength() {
        return this.getWidth() + 31 >> 5 << 2;
    }

    protected byte[][] getDataBuff() {
        if (this.m_baData == null) {
            int iLin = this.getHeight();
            int iCol = this.getLineLength();
            this.m_baData = new byte[iLin][];
            for (int i = 0; i < iLin; ++i) {
                this.m_baData[i] = new byte[iCol];
            }
        }
        return this.m_baData;
    }

    public int getLineData(int uiLine, byte[] dstBuff, int iDstOff) {
        if (uiLine < 0 || uiLine >= this.getHeight()) {
            throw new IllegalArgumentException("line number");
        }
        if (iDstOff < 0) {
            throw new IllegalArgumentException("dest offset");
        }
        if (dstBuff == null || iDstOff >= dstBuff.length) {
            throw new IllegalArgumentException("dest buffer");
        }
        if (this.m_baData == null) {
            throw new IllegalStateException("m_baData is null");
        }
        byte[] srcBuff = this.m_baData[uiLine];
        int iSrcOff = 0;
        int iSrcLen = this.getLineLength();
        int iDstLen = dstBuff.length;
        int iCount = 0;
        for (iCount = 0; iCount < iSrcLen && iDstOff < iDstLen; ++iCount) {
            dstBuff[iDstOff++] = srcBuff[iSrcOff++];
        }
        return iCount;
    }

    public int setLineData(int uiLine, byte[] srcBuff, int iSrcOff, int iSrcLen) {
        if (uiLine < 0 || uiLine >= this.getHeight()) {
            throw new IllegalArgumentException("line number");
        }
        if (iSrcOff < 0 || iSrcLen < 0) {
            throw new IllegalArgumentException("source offset or length");
        }
        if (srcBuff == null || iSrcOff + iSrcLen >= srcBuff.length) {
            throw new IllegalArgumentException("dest buffer");
        }
        if (this.m_baData == null) {
            throw new IllegalStateException("m_baData is null");
        }
        byte[] dstBuff = this.m_baData[uiLine];
        int iDstOff = 0;
        int iDstLen = this.getHeight();
        int iCount = 0;
        for (iCount = 0; iCount < iSrcLen && iDstOff < iDstLen; ++iCount) {
            dstBuff[iDstOff++] = srcBuff[iSrcOff++];
        }
        return iCount;
    }

    public void load(BitMapInputStream bmis) throws IOException {
        if (bmis.readUnsignedByte2() != 19778) {
            throw new IllegalArgumentException("BMP format error");
        }
        this.m_obBmfh.m_uiFileSize = bmis.readUnsignedByte4();
        this.m_obBmfh.m_uiReserved = bmis.readUnsignedByte4();
        this.m_obBmfh.m_uiDataOffset = bmis.readUnsignedByte4();
        this.m_obBmih.m_uiHeaderSize = bmis.readUnsignedByte4();
        this.m_obBmih.m_uiWidth = bmis.readUnsignedByte4();
        this.m_obBmih.m_uiHeight = bmis.readUnsignedByte4();
        this.m_obBmih.m_usPlanes = bmis.readUnsignedByte2();
        this.m_obBmih.m_usPixelBit = bmis.readUnsignedByte2();
        this.m_obBmih.m_uiCompression = bmis.readUnsignedByte4();
        this.m_obBmih.m_uiDataSize = bmis.readUnsignedByte4();
        this.m_obBmih.m_uiHResolution = bmis.readUnsignedByte4();
        this.m_obBmih.m_uiVResolution = bmis.readUnsignedByte4();
        this.m_obBmih.m_uiColors = bmis.readUnsignedByte4();
        this.m_obBmih.m_uiImportantColors = bmis.readUnsignedByte4();
        int iSkipByte = this.m_obBmih.m_uiHeaderSize - 40;
        if (iSkipByte > 0) {
            bmis.skip(iSkipByte);
        }
        int iPalette = this.m_obBmfh.m_uiDataOffset - this.m_obBmih.m_uiHeaderSize - 14;
        InfoHeader.access$302(this.m_obBmih, new byte[iPalette]);
        int iReadLen = bmis.read(this.m_obBmih.m_baPalette);
        iSkipByte = iPalette - iReadLen;
        if (iSkipByte > 0) {
            bmis.skip(iSkipByte);
        }
        int iLineCount = this.getHeight();
        for (int i = 0; i < iLineCount; ++i) {
            bmis.read(this.getDataBuff()[i]);
        }
    }

    public void save(BitMapOutputStream bmos) throws IOException {
        this.m_obBmih.m_uiDataSize = this.getLineLength() * this.m_obBmih.m_uiHeight;
        this.m_obBmfh.m_uiDataOffset = 14 + this.m_obBmih.m_uiHeaderSize + this.m_obBmih.m_baPalette.length;
        this.m_obBmfh.m_uiFileSize = this.m_obBmfh.m_uiDataOffset + this.m_obBmih.m_uiDataSize;
        bmos.write(this.m_obBmfh.m_baFileType);
        bmos.writeUnsignedByte4(this.m_obBmfh.m_uiFileSize);
        bmos.writeUnsignedByte4(this.m_obBmfh.m_uiReserved);
        bmos.writeUnsignedByte4(this.m_obBmfh.m_uiDataOffset);
        bmos.writeUnsignedByte4(this.m_obBmih.m_uiHeaderSize);
        bmos.writeUnsignedByte4(this.m_obBmih.m_uiWidth);
        bmos.writeUnsignedByte4(this.m_obBmih.m_uiHeight);
        bmos.writeUnsignedByte2(this.m_obBmih.m_usPlanes);
        bmos.writeUnsignedByte2(this.m_obBmih.m_usPixelBit);
        bmos.writeUnsignedByte4(this.m_obBmih.m_uiCompression);
        bmos.writeUnsignedByte4(this.m_obBmih.m_uiDataSize);
        bmos.writeUnsignedByte4(this.m_obBmih.m_uiHResolution);
        bmos.writeUnsignedByte4(this.m_obBmih.m_uiVResolution);
        bmos.writeUnsignedByte4(this.m_obBmih.m_uiColors);
        bmos.writeUnsignedByte4(this.m_obBmih.m_uiImportantColors);
        bmos.write(this.m_obBmih.m_baPalette);
        int iLineCount = this.getHeight();
        int iLineWidth = this.getLineLength();
        for (int i = 0; i < iLineCount; ++i) {
            bmos.writeLine(this.getDataBuff()[i], 0, iLineWidth);
        }
    }

    class InfoHeader {
        private int m_uiHeaderSize = 40;
        private int m_uiWidth = 0;
        private int m_uiHeight = 0;
        private int m_usPlanes = 1;
        private int m_usPixelBit = 1;
        private int m_uiCompression = 0;
        private int m_uiDataSize = 0;
        private int m_uiHResolution = 0;
        private int m_uiVResolution = 0;
        private int m_uiColors = 0;
        private int m_uiImportantColors = 0;
        private byte[] m_baPalette = null;

        InfoHeader() {
        }

        static /* synthetic */ byte[] access$302(InfoHeader x0, byte[] x1) {
            x0.m_baPalette = x1;
            return x1;
        }
    }

    class FileHeader {
        private byte[] m_baFileType = FILE_TYPE_BYTES;
        private int m_uiFileSize = 0;
        private int m_uiReserved = 0;
        private int m_uiDataOffset = 0;

        FileHeader() {
        }
    }
}

