/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcag2.validator;

import com.trs.infra.I18NMessage;
import com.trs.wcag2.HTMLUtil;
import com.trs.wcag2.validator.AbstractValidator;
import java.util.HashMap;
import java.util.List;

public class HtmlH1_H6Validator
extends AbstractValidator {
    protected String m_sType = I18NMessage.get(HtmlH1_H6Validator.class, "HtmlH1_H6Validator.label1", "\u6807\u9898/\u7c7b\u76ee");
    protected Object m_oWarning = I18NMessage.get(HtmlH1_H6Validator.class, "HtmlH1_H6Validator.label2", "\u4e0d\u662f\u4f7f\u7528H1-H6\u6765\u5b9a\u4e49\u9875\u9762\u7684\u6846\u67b6\u7ed3\u6784");
    protected String m_oExample = I18NMessage.get(HtmlH1_H6Validator.class, "HtmlH1_H6Validator.label3", "\u4f7f\u7528\u9875\u9762\u6807\u7b7e\u5c06\u9875\u9762\u5212\u5206\u4e3a \u6807\u9898, \u6bb5\u843d, \u5217\u8868, \u5f15\u7528\u7b49\uff0c\u4f8b\u5982\uff1a<br>") + I18NMessage.get(HtmlH1_H6Validator.class, "HtmlH1_H6Validator.label4", "<br>&nbsp;&nbsp;\u4f7f\u7528 &lt;h1&gt; \u6807\u7b7e\u6765\u533a\u5206\u9876\u5c42\u5934\u4fe1\u606f\u800c\u4e0d\u662f\u7b80\u5355\u7684\u52a0\u5927\u52a0\u7c97\u8fd9\u4e9b\u6587\u5b57\uff0c\u518d\u4f7f\u7528CSS\u683c\u5f0f\u5316\u8fd9\u4e9b\u6807\u7b7e\u7684\u5185\u5bb9\u3002");

    @Override
    public Object doValid(String content, HashMap known) {
        int cnt = 0;
        for (int i = 1; i <= 6; ++i) {
            String eleName = "H" + i;
            List tags = HTMLUtil.findTagOuterHTML(content, eleName);
            cnt += tags.size();
        }
        return cnt == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    public Object getWarnObj() {
        return this.m_oWarning;
    }

    @Override
    public String getType() {
        return this.m_sType;
    }

    @Override
    public Object getExampleObj() {
        return this.m_oExample;
    }
}

