/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.service;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.common.WCMException;
import com.trs.scm.domain.ISCMCommentMgr;
import com.trs.scm.domain.SCMAuthServer;
import com.trs.scm.persistent.Account;
import com.trs.scm.sdk.model.Comment;
import com.trs.scm.sdk.model.CommentWrapper;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;

public class SCMCommentServiceProvider
implements ISelfDefinedServiceProvider {
    ISCMCommentMgr m_oSCMCommentMgr = (ISCMCommentMgr)DreamFactory.createObjectById("ISCMCommentMgr");

    public Comment createComment(MethodContext _oContext) throws Throwable {
        User oCurrUser = this.getLoginUser();
        int nAccountId = _oContext.getValue("AccountId", 0);
        Account oCommentAccount = Account.findById(nAccountId);
        if (oCommentAccount == null) {
            throw new WCMException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01[ID=" + nAccountId + "]");
        }
        if (!SCMAuthServer.hasRight(oCurrUser, oCommentAccount, 44)) {
            throw new WCMException("\u60a8\u5bf9\u6b64\u8d26\u53f7\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff01[ID=" + nAccountId + "]");
        }
        String sMicroContentId = _oContext.getValue("MicroContentId");
        String sCommentId = _oContext.getValue("CommentId");
        String sContent = _oContext.getValue("Content");
        boolean bIsReplyComment = _oContext.getValue("isReplyComment", false);
        return this.m_oSCMCommentMgr.createComment(oCommentAccount, sContent, sMicroContentId, sCommentId, bIsReplyComment, _oContext.getParams());
    }

    public boolean destroyComment(MethodContext _oContext) throws Throwable {
        User oCurrUser = this.getLoginUser();
        int nAccountId = _oContext.getValue("AccountId", 0);
        Account oDeleteAccount = Account.findById(nAccountId);
        if (oDeleteAccount == null) {
            throw new WCMException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01[ID=" + nAccountId + "]");
        }
        if (!SCMAuthServer.hasRight(oCurrUser, oDeleteAccount, 44)) {
            throw new WCMException("\u60a8\u5bf9\u6b64\u8d26\u53f7\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff01[ID=" + nAccountId + "]");
        }
        String sCommentId = _oContext.getValue("CommentId");
        return this.m_oSCMCommentMgr.destroyComment(oDeleteAccount, sCommentId);
    }

    public CommentWrapper queryCommentsByMCId(MethodContext _oContext) throws Throwable {
        User oCurrUser = this.getLoginUser();
        int nAccountId = _oContext.getValue("AccountId", 0);
        Account oAccountToGetComments = Account.findById(nAccountId);
        if (oAccountToGetComments == null) {
            throw new WCMException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01[ID=" + nAccountId + "]");
        }
        if (!SCMAuthServer.hasRight(oCurrUser, oAccountToGetComments, 44)) {
            throw new WCMException("\u60a8\u5bf9\u6b64\u8d26\u53f7\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff01[ID=" + nAccountId + "]");
        }
        int nPageIndex = _oContext.getValue("PageIndex", 1);
        int nPageSize = _oContext.getValue("PageSize", 10);
        String sMicroContentId = _oContext.getValue("MicroContentId");
        return this.m_oSCMCommentMgr.queryCommentsByMCId(oAccountToGetComments, sMicroContentId, nPageIndex, nPageSize, _oContext.getParams());
    }

    public CommentWrapper queryCommentsToMe(MethodContext _oContext) throws Throwable {
        User oCurrUser = this.getLoginUser();
        int nAccountId = _oContext.getValue("AccountId", 0);
        Account oAccountToGetComments = Account.findById(nAccountId);
        if (oAccountToGetComments == null) {
            throw new WCMException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01[ID=" + nAccountId + "]");
        }
        if (!SCMAuthServer.hasRight(oCurrUser, oAccountToGetComments, 44)) {
            throw new WCMException("\u60a8\u5bf9\u6b64\u8d26\u53f7\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff01[ID=" + nAccountId + "]");
        }
        int nPageIndex = _oContext.getValue("PageIndex", 1);
        int nPageSize = _oContext.getValue("PageSize", 10);
        return this.m_oSCMCommentMgr.queryCommentsToMe(oAccountToGetComments, nPageIndex, nPageSize, _oContext.getParams());
    }

    public CommentWrapper queryCommentsByMe(MethodContext _oContext) throws Throwable {
        User oCurrUser = this.getLoginUser();
        int nAccountId = _oContext.getValue("AccountId", 0);
        Account oAccountToGetComments = Account.findById(nAccountId);
        if (oAccountToGetComments == null) {
            throw new WCMException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01[ID=" + nAccountId + "]");
        }
        if (!SCMAuthServer.hasRight(oCurrUser, oAccountToGetComments, 44)) {
            throw new WCMException("\u60a8\u5bf9\u6b64\u8d26\u53f7\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff01[ID=" + nAccountId + "]");
        }
        int nPageIndex = _oContext.getValue("PageIndex", 1);
        int nPageSize = _oContext.getValue("PageSize", 10);
        return this.m_oSCMCommentMgr.queryCommentsByMe(oAccountToGetComments, nPageIndex, nPageSize, _oContext.getParams());
    }

    public CommentWrapper queryCommentMentions(MethodContext _oContext) throws Throwable {
        User oCurrUser = this.getLoginUser();
        int nAccountId = _oContext.getValue("AccountId", 0);
        Account oAccountToGetComments = Account.findById(nAccountId);
        if (oAccountToGetComments == null) {
            throw new WCMException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01[ID=" + nAccountId + "]");
        }
        if (!SCMAuthServer.hasRight(oCurrUser, oAccountToGetComments, 44)) {
            throw new WCMException("\u60a8\u5bf9\u6b64\u8d26\u53f7\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff01[ID=" + nAccountId + "]");
        }
        int nPageIndex = _oContext.getValue("PageIndex", 1);
        int nPageSize = _oContext.getValue("PageSize", 10);
        return this.m_oSCMCommentMgr.queryCommentMentions(oAccountToGetComments, nPageIndex, nPageSize, _oContext.getParams());
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

