/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.config.FlowConfigServer;
import com.trs.cms.process.config.ToUsersCreatorConfig;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.engine.FlowContext;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class FlowNextBranchInfo {
    private static Logger logger = Logger.getLogger(FlowNextBranchInfo.class);
    private FlowDoc m_oCurrFlowDoc = null;
    private User m_currUser = null;
    private int m_nNextNodeId = 0;
    private Users m_oToUsers = null;
    private Users m_oUsersPassed = null;
    private String m_sNotifyTypes = null;
    private Status m_oChangeStatus = null;
    private FlowConfigServer m_oFlowConfigServer = null;
    private FlowContext m_oCurrFlowContext = null;
    private boolean m_bResubmit = false;
    private Group m_oGroupRange = null;

    public FlowNextBranchInfo(User _currUser, FlowDoc _currFlowDoc, int _nNextNodeId, boolean _bResubmit) throws WCMException {
        this.m_bResubmit = _bResubmit;
        try {
            this.m_oFlowConfigServer = (FlowConfigServer)DreamFactory.createObjectById("FlowConfigServer");
        }
        catch (Throwable e) {
            logger.error((Object)I18NMessage.get(FlowNextBranchInfo.class, "FlowNextBranchInfo.label1", "\u521b\u5efa\u914d\u7f6e\u670d\u52a1\u5668\u5931\u8d25\uff01"), e);
        }
        this.m_oCurrFlowDoc = _currFlowDoc;
        this.m_nNextNodeId = _nNextNodeId;
        this.m_currUser = _currUser;
        this.makeInfo();
    }

    private void makeInfo() throws WCMException {
        if (this.m_oCurrFlowDoc.getWorkModal() == 1) {
            if (this.m_bResubmit) {
                FlowNode currNode = this.m_oCurrFlowDoc.getNode();
                this.m_oToUsers = this.getDealers(currNode);
                WCMFilter filter = new WCMFilter("", "exists(select WCMFlowDoc.ToUserId from WCMFlowDoc where WCMFlowDoc.Worked=1 and WCMFlowDoc.ParentId=? and WCMFlowDoc.ToUserId=WCMUser.UserId)", "");
                filter.addSearchValues(this.m_oCurrFlowDoc.getId());
                this.m_oUsersPassed = Users.openWCMObjs(null, filter);
                FlowNodeBranch branch = this.m_oCurrFlowDoc.getPreNode().getBranchTo(this.m_currUser, currNode);
                this.m_oChangeStatus = branch.getStatus();
                this.m_sNotifyTypes = branch.getNotifyTypes();
                return;
            }
            WCMFilter filter = new WCMFilter("", "ParentId=? and FlowDocId<>?", "");
            filter.addSearchValues(this.m_oCurrFlowDoc.getParentId());
            filter.addSearchValues(this.m_oCurrFlowDoc.getId());
            FlowDocs flowDocs = FlowDocs.openWCMObjs(this.m_currUser, filter);
            this.m_oToUsers = new Users(this.m_currUser, flowDocs.size(), 1);
            this.m_oUsersPassed = new Users(this.m_currUser, flowDocs.size(), 1);
            int nSize = flowDocs.size();
            for (int i = 0; i < nSize; ++i) {
                User dealer;
                FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
                if (flowDoc == null || (dealer = flowDoc.getToUser()) == null) continue;
                if (flowDoc.isWorked()) {
                    this.m_oUsersPassed.addElement(dealer);
                    continue;
                }
                this.m_oToUsers.addElement(dealer);
            }
            if (!this.m_oToUsers.isEmpty()) {
                return;
            }
        }
        FlowNode currNode = this.m_oCurrFlowDoc.getNode();
        FlowNode nextNode = null;
        nextNode = this.m_oCurrFlowDoc.getFlag() == 2 ? this.m_oCurrFlowDoc.getPreNode() : this.findNodeById(this.m_nNextNodeId);
        if (this.m_bResubmit) {
            currNode = this.m_oCurrFlowDoc.getPreNode();
        }
        FlowNodeBranch branch = currNode.getBranchTo(this.m_currUser, nextNode);
        if (this.m_oCurrFlowDoc.getFlag() == 2) {
            this.m_oToUsers = new Users(this.m_currUser, 1, 1);
            FlowDoc preFlowDoc = this.m_oCurrFlowDoc.getPreFlowDoc();
            if (preFlowDoc == null || preFlowDoc.getWorkModal() != 1 || preFlowDoc.getParentId() == 0) {
                this.m_oToUsers.addElement(this.m_oCurrFlowDoc.getPostUser());
            } else {
                FlowDoc parent = preFlowDoc.getParent();
                if (parent != null) {
                    this.m_oToUsers = parent.getToUsers(null);
                } else {
                    this.m_oToUsers.addElement(this.m_oCurrFlowDoc.getPostUser());
                }
            }
        } else {
            this.m_oToUsers = this.getDealers(nextNode);
            this.m_oGroupRange = this.getRangedGroup(nextNode);
        }
        if (branch != null) {
            this.m_oChangeStatus = branch.getStatus();
            this.m_sNotifyTypes = branch.getNotifyTypes();
        }
    }

    private FlowNode findNodeById(int _nNodeId) throws WCMException {
        FlowNode node = FlowNode.findById(_nNodeId);
        if (node == null) {
            throw new WCMException(I18NMessage.get(FlowNextBranchInfo.class, "FlowNextBranchInfo.label4", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5de5\u4f5c\u6d41\u8282\u70b9\uff01[ID=") + _nNodeId + "]");
        }
        return node;
    }

    public Status getChangeStatus() {
        return this.m_oChangeStatus;
    }

    public void setChangeStatus(Status changeStatus) {
        this.m_oChangeStatus = changeStatus;
    }

    public Users getToUsers() {
        return this.m_oToUsers;
    }

    public void setToUsers(Users toUsers) {
        this.m_oToUsers = toUsers;
    }

    public String getNotifyTypes() {
        return this.m_sNotifyTypes;
    }

    public void setNotifyTypes(String notifyTypes) {
        this.m_sNotifyTypes = notifyTypes;
    }

    public Users getUsersPassed() {
        return this.m_oUsersPassed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Users getDealers(FlowNode _node) throws WCMException {
        if (_node == null) {
            return new Users(null);
        }
        FlowContext currFlowContext = this.getCurrFlowContext();
        FlowNode eOldNextNode = currFlowContext.getNextNode();
        currFlowContext.setNextNode(_node);
        try {
            Users toUsers;
            ToUsersCreatorConfig toUsersCreatorConfig;
            String sToUsersCreator = _node.getPropertyAsString("ToUsersCreator");
            String sToUsersCreatorParams = _node.getPropertyAsString("ToUsersCreatorParams");
            if (!CMyString.isEmpty(sToUsersCreator) && (toUsersCreatorConfig = this.m_oFlowConfigServer.getToUsersCreatorConfigByName(sToUsersCreator, sToUsersCreatorParams)) != null) {
                Users oDealers;
                Users users = oDealers = toUsersCreatorConfig.getToUsers(currFlowContext);
                return users;
            }
            Users users = toUsers = _node.getOperUsers(null, true);
            return users;
        }
        finally {
            currFlowContext.setNextNode(eOldNextNode);
        }
    }

    private Group getRangedGroup(FlowNode _node) throws WCMException {
        ToUsersCreatorConfig toUsersCreatorConfig;
        if (_node == null) {
            return null;
        }
        Group result = null;
        String sToUsersCreator = _node.getPropertyAsString("ToUsersCreator");
        if (!CMyString.isEmpty(sToUsersCreator) && (toUsersCreatorConfig = this.m_oFlowConfigServer.getToUsersCreatorConfigByName(sToUsersCreator)) != null) {
            result = toUsersCreatorConfig.getGroupRange(this.getCurrFlowContext());
        }
        return result;
    }

    public FlowContext getCurrFlowContext() throws WCMException {
        if (this.m_oCurrFlowContext == null) {
            this.m_oCurrFlowContext = new FlowContext(this.m_currUser, this.m_oCurrFlowDoc.getFlowContent());
        }
        return this.m_oCurrFlowContext;
    }

    public void setCurrFlowContext(FlowContext currFlowContext) {
        this.m_oCurrFlowContext = currFlowContext;
    }

    public boolean isResubmit() {
        return this.m_bResubmit;
    }

    public void setResubmit(boolean resubmit) {
        this.m_bResubmit = resubmit;
    }

    public Group getGroupRange() {
        return this.m_oGroupRange;
    }

    public void setGroupRange(Group groupRange) {
        this.m_oGroupRange = groupRange;
    }
}

