/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.IWorkflowDelegateServiceProvider;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.IWorkflowDelegateMgr;
import com.trs.cms.process.engine.WorkflowDelegate;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;

public class WorkflowDelegateServiceProvider
implements IWorkflowDelegateServiceProvider {
    IWorkflowDelegateMgr m_oDelegateMgr = (IWorkflowDelegateMgr)DreamFactory.createObjectById("IWorkflowDelegateMgr");

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        return loginUser;
    }

    private void validRight(int nDelegateUserId) throws WCMException {
        User loginUser = this.getLoginUser();
        User currUser = User.findById(nDelegateUserId);
        if (!loginUser.isAdministrator() && !currUser.equals(loginUser)) {
            throw new WCMException("\u60a8\u6ca1\u6709\u4fdd\u5b58\u59d4\u6258\u4fe1\u606f\u7684\u6743\u9650\uff01");
        }
    }

    @Override
    public Object getDelegateUsers(MethodContext methodContext) throws Throwable {
        int nDelegateId = methodContext.getObjectId();
        WorkflowDelegate oDelegate = WorkflowDelegate.findById(nDelegateId);
        int nDelegateUserId = oDelegate.getCurrUserId();
        this.validRight(nDelegateUserId);
        String sUserIds = oDelegate.getDelegateUserIds();
        Users users = this.m_oDelegateMgr.getDelegateUsers(this.getLoginUser(), true);
        return users;
    }

    @Override
    public int setEnableDelegate(MethodContext methodContext) throws Throwable {
        return this.saveDelegate(methodContext);
    }

    @Override
    public int saveDelegateUsers(MethodContext methodContext) throws Throwable {
        return this.saveDelegate(methodContext);
    }

    @Override
    public int saveDelegate(MethodContext methodContext) throws Throwable {
        int nDelegateId = methodContext.getObjectId();
        WorkflowDelegate oDelegate = null;
        User loginUser = this.getLoginUser();
        if (nDelegateId == 0) {
            WorkflowDelegate oTempDelegate;
            if (CMyString.isEmpty(methodContext.getValue("CurrUserId"))) {
                methodContext.setValue("CurrUserId", loginUser.getId());
            }
            oDelegate = (oTempDelegate = this.getDelegateByUser(methodContext)) != null ? oTempDelegate : new WorkflowDelegate();
        } else {
            oDelegate = WorkflowDelegate.findById(nDelegateId);
            if (oDelegate == null) {
                throw new WCMException("\u6307\u5b9a\u7684\u59d4\u6258\u4e0d\u5b58\u5728,[ObjectID=" + methodContext.getObjectId() + "]!");
            }
            int nDelegateUserId = oDelegate.getCurrUserId();
            this.validRight(nDelegateUserId);
        }
        String[] _pLogicFields = new String[]{"ObjectId"};
        WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, methodContext, oDelegate, _pLogicFields);
        this.m_oDelegateMgr.save(oDelegate);
        return oDelegate.getId();
    }

    @Override
    public WorkflowDelegate getDelegateByUser(MethodContext methodContext) throws Throwable {
        int nUserId = methodContext.getValue("CurrUserId", 0);
        User oCurrUser = User.findById(nUserId);
        if (oCurrUser == null) {
            return null;
        }
        this.validRight(nUserId);
        return this.m_oDelegateMgr.getDelegateByUser(oCurrUser);
    }

    @Override
    public void delete(MethodContext context) throws Throwable {
    }

    @Override
    public Object query(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public int save(MethodContext context) throws Throwable {
        return 0;
    }

    @Override
    public Object findById(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public Object findByIds(MethodContext context) throws Throwable {
        return null;
    }
}

