/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.filter.logicProcessor;

import com.trs.idm.client.filter.logicProcessor.AbstractIDSCmdProcessor;
import com.trs.idm.interact.agent.IAgent;
import com.trs.idm.util.RequestUtil;
import com.trs.idm.util.StringHelper;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class PingProcessor
extends AbstractIDSCmdProcessor {
    private static final Logger LOG = Logger.getLogger(PingProcessor.class);
    private IAgent agent;
    private final String idsCmd = "ping";

    public PingProcessor(IAgent agent) {
        this.agent = agent;
    }

    public void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOG.info((Object)("agent begin response ping from ids server, remote Addr = " + RequestUtil.getRemoteAddr((HttpServletRequest)req, (String)this.agent.getOriginalClientIPHttpHeader())));
        String coSessionId = "";
        String idmServerCharset = this.agent.getIdmServerCharset();
        if (StringHelper.isEmpty((String)idmServerCharset) || "GBK".equals(idmServerCharset)) {
            resp.getOutputStream().print(this.agent.getAgentName());
        } else {
            coSessionId = this.agent.getServletAppActorV2().getSessionId(req, resp, false);
            resp.getOutputStream().print(String.valueOf(this.agent.getAgentName()) + ";" + coSessionId);
        }
        LOG.info((Object)("agent finish response ping from ids server, coAppName=" + this.agent.getAgentName() + ", coSessionId=" + coSessionId + ", idmServerCharset[" + idmServerCharset + "]"));
    }

    public String getIDSCmd() {
        return "ping";
    }
}

