/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent;

import com.trs.idm.client.IWebCoAppActor;
import com.trs.idm.client.actor.FormValues;
import com.trs.idm.client.actor.IServletAppActor;
import com.trs.idm.client.actor.LegacyActorAdapter;
import com.trs.idm.client.actor.SSOGroup;
import com.trs.idm.client.actor.SSOUser;
import com.trs.idm.client.actor.v2.IServletAppActorV2;
import com.trs.idm.client.actor.v2.LegacyActorAdapterV2;
import com.trs.idm.client.actor.v2.ServletAppActorV2Wrapper;
import com.trs.idm.client.filter.GeneralSSOFilter;
import com.trs.idm.client.filter.VerifyReqInfo;
import com.trs.idm.client.filter.VerifyResult;
import com.trs.idm.exception.ClientTransferException;
import com.trs.idm.exception.FileReadException;
import com.trs.idm.exception.IdMException;
import com.trs.idm.exception.NoSuchFileException;
import com.trs.idm.exception.NoSuchSSOIDException;
import com.trs.idm.interact.agent.AgentFactory;
import com.trs.idm.interact.agent.AgentVersion;
import com.trs.idm.interact.agent.AsyncTimeoutNotifier;
import com.trs.idm.interact.agent.IAgent;
import com.trs.idm.interact.agent.LoginResult;
import com.trs.idm.interact.agent.ResponseResult;
import com.trs.idm.interact.agent.SocketAddr;
import com.trs.idm.interact.agent.TransferResult;
import com.trs.idm.interact.agent.validator.FilterAgentPropertiesValidator;
import com.trs.idm.interact.agent.validator.IAgentPropertiesValidator;
import com.trs.idm.interact.agent.watcher.ServerStatusWatcher;
import com.trs.idm.interact.protocol.PacketUtil;
import com.trs.idm.interact.protocol.ProtocolPacket;
import com.trs.idm.interact.protocol.RequestPacket;
import com.trs.idm.interact.protocol.ResponsePacket;
import com.trs.idm.model.sso.samedomain.SameDomainSSOHelper;
import com.trs.idm.security.DataSecurityFactory;
import com.trs.idm.util.Base64Util;
import com.trs.idm.util.ConfigFileModifier;
import com.trs.idm.util.JSONUtil;
import com.trs.idm.util.PropertyUtil;
import com.trs.idm.util.RequestUtil;
import com.trs.idm.util.ResourceUtil;
import com.trs.idm.util.StringHelper;
import com.trs.idm.util.UrlUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AgentBase
implements IAgent {
    private static final Logger LOG = Logger.getLogger(AgentBase.class);
    protected static final String LOG4J_CFG_FILE = "/log4j_idsagent.properties";
    protected String agentName;
    protected String encryptAgentName;
    protected String host;
    protected int port;
    protected int nSocket;
    protected String globalLoginUrl;
    protected String proxyGlobalLoginUrl;
    protected boolean allowAnonymous;
    protected String coAppActorClassName;
    protected IWebCoAppActor appActor;
    protected IServletAppActorV2 actorV2;
    protected Properties props;
    protected String serverInfo;
    protected boolean started;
    protected String squidUrl;
    protected AsyncTimeoutNotifier asyncNotifier;
    protected String[] hostIPs;
    protected SocketAddr[] socketAddrs = new SocketAddr[0];
    protected boolean isHTTPSocket;
    boolean readSameDomainConfigFromLocal;
    private boolean idsSupportSDSSO;
    private boolean appSupportSDSSO;
    private String sdSSOCommonCookieDomain;
    private String sdSSOCommonCookiePath;
    private String sdSSOIDSCookiePath;
    private String originalClientIPHttpHeaderToken;
    private String originalHostHttpHeader;
    private Thread notifyThread;
    String anonymousFlag;
    boolean continueLocalLoginIfUserNotFoundOnIDS;
    String selfLoginPageUserNameField;
    String coAppSelfLoginActionURL;
    String selfLoginPagePasswordField;
    boolean needSavePostParamAndPostBack;
    String appFirstRedirectToIDSReturnUrlPrefix;
    ServerStatusWatcher serverStatusWatcher;
    private boolean inited;
    private int appAuthBy;
    private String appCharset;
    private String idmServerCharset;
    protected String coAppVersion;
    protected String coAppType;
    protected String coAppRootUrl;
    protected String notifyUrl;
    private boolean agentFirstStart;
    private boolean groupSynchronize;
    private boolean userSynchronize;
    private String configFile;
    private IAgentPropertiesValidator agentPropertiesValidator;
    protected boolean switchOn;
    private boolean socketCommunicationSessionSticky;
    String loginActionMethod;
    private static final String PLAIN_SOCKET = "plain";
    private static final String DUMMY_SSL = "dummySSL";
    private static final int EOF_CHAR = 25;
    private Set serverNodes = new HashSet(3);

    public boolean isHTTPSocket() {
        return this.isHTTPSocket;
    }

    @Override
    public IAgent initAndStart() {
        if (this.inited) {
            return this;
        }
        AgentBase.appendAgentLog4JConfig(LOG4J_CFG_FILE);
        LOG.info((Object)("begin to init and start agent with inited status[" + this.inited + "]"));
        Properties props = null;
        boolean switchOn = false;
        try {
            props = PropertyUtil.assertAndLoadFromResource(GeneralSSOFilter.class, "/trsids-agent.properties");
        }
        catch (NoSuchFileException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (FileReadException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        if (props != null) {
            switchOn = PropertyUtil.getPropertyAsBool(props, "sso.on", true);
            LOG.debug((Object)("sso.on: " + switchOn));
        }
        AgentBase agent = null;
        try {
            agent = AgentFactory.getInstance();
            LOG.info((Object)("TRSIDS Agent: " + agent));
        }
        catch (Exception e) {
            LOG.error((Object)"get TRSIDS Agent fail!", (Throwable)e);
        }
        if (agent == null) {
            LOG.warn((Object)"agent is null!");
            return agent;
        }
        if (!switchOn) {
            agent.setProperties(props);
            agent.setSSOSwitch(switchOn);
            return agent;
        }
        agent.setSSOSwitch(switchOn);
        this.host = props.getProperty("idm.server.host");
        this.port = PropertyUtil.getPropertyAsInt(props, "idm.server.port", 2005);
        this.agentName = props.getProperty("agent.name");
        agent.start();
        this.inited = true;
        LOG.info((Object)("init and start agent[" + agent + "] successfully, with inited status[" + this.inited + "]"));
        return agent;
    }

    @Override
    public IAgent restart() {
        this.inited = false;
        this.stop();
        LOG.debug((Object)"init and restart agent!");
        return this.initAndStart();
    }

    protected abstract void onStart();

    protected abstract void onStop();

    @Override
    public final void start() {
        if (this.started) {
            return;
        }
        this.agentPropertiesValidator = new FilterAgentPropertiesValidator();
        if (!this.agentPropertiesValidator.check()) {
            LOG.error((Object)"IDS Agent properties is not correct, Agent start failed !!!!!!!");
            this.started = false;
            return;
        }
        try {
            this.parseConfigFromFile();
        }
        catch (IdMException e) {
            LOG.error((Object)"parse trsids-agent.properties error, IDS Agent start failed!!!!!!", (Throwable)e);
            return;
        }
        LOG.info((Object)("TRS IDS Agent starting, connecting IDS Server: " + this.host + ":" + this.port + ", nSocket=" + this.nSocket));
        try {
            this.onStart();
        }
        catch (Exception e) {
            LOG.error((Object)"onStart() fail! Maybe IDS Server not start yet!", (Throwable)e);
        }
        this.asyncNotifier = new AsyncTimeoutNotifier(this);
        this.notifyThread = new Thread(this.asyncNotifier);
        this.notifyThread.setName("TRSIDSAgent.AsyncTimeoutNotifier." + this.agentName);
        this.notifyThread.start();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("start coApp[" + this.agentName + "] notifyThread[" + this.notifyThread + "]"));
        }
        this.serverStatusWatcher = new ServerStatusWatcher(this);
        this.serverStatusWatcher.start();
        this.started = true;
    }

    void parseConfigFromFile() throws IdMException {
        try {
            this.props = PropertyUtil.assertAndLoadFromResource(AgentBase.class, this.configFile);
        }
        catch (NoSuchFileException e) {
            throw e;
        }
        catch (FileReadException e) {
            throw e;
        }
        this.loadProperties(this.props);
        this.actorV2 = this.createServletAppActorV2();
        LOG.info((Object)("Create IServletApppActorV2 instance: " + this.actorV2));
        StringTokenizer hosts = new StringTokenizer(this.host);
        this.hostIPs = new String[hosts.countTokens()];
        int i = 0;
        while (hosts.hasMoreTokens()) {
            this.hostIPs[i] = hosts.nextToken();
            ++i;
        }
        this.socketAddrs = new SocketAddr[this.hostIPs.length];
        i = 0;
        while (i < this.hostIPs.length) {
            this.socketAddrs[i] = new SocketAddr(this.hostIPs[i], this.port);
            ++i;
        }
        this.isHTTPSocket = "true".equals(this.props.getProperty("protocol.http", "false").toLowerCase());
    }

    @Override
    public final void stop() {
        if (!this.started) {
            LOG.info((Object)("coApp[" + this.agentName + "] is not started, so need not to stop"));
            return;
        }
        this.started = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("interrupt coApp[" + this.agentName + "] notifyThread[" + this.notifyThread + "]"));
        }
        this.notifyThread.interrupt();
        this.serverStatusWatcher.interrupt();
        this.onStop();
    }

    @Override
    public Properties getUpdateUser(String userName) {
        block6: {
            ResponsePacket resp;
            block7: {
                block5: {
                    resp = null;
                    resp = StringHelper.isEmpty(userName) ? this.getResponsePacket((byte)7, new String[]{this.agentName}) : this.getResponsePacket((byte)7, new String[]{this.agentName, userName});
                    if (resp != null) break block5;
                    return null;
                }
                if (resp.getErrCode() != 1) break block6;
                String revCoAppName = resp.getData((byte)0);
                if (this.agentName.equals(revCoAppName)) break block7;
                LOG.warn((Object)("expect coAppName=" + this.agentName + ", but recevd=" + revCoAppName));
                return null;
            }
            try {
                Properties props = this.getResponseProperties(resp);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("get update user info: " + props));
                }
                return props;
            }
            catch (Exception e) {
                LOG.error((Object)"auto sync_add user fail!", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public SSOUser getUpdateSSOUser(String userName) {
        Properties props = this.getUpdateUser(userName);
        return this.props2SSOUser(props);
    }

    @Override
    public SSOUser getUpdateSSOUser(String userName, String sourceName) {
        Properties props = this.getUpdateUser(userName, sourceName);
        return this.props2SSOUser(props);
    }

    private Properties getUpdateUser(String userName, String sourceName) {
        block6: {
            ResponsePacket resp;
            block7: {
                block5: {
                    resp = null;
                    resp = StringHelper.isEmpty(userName) ? this.getResponsePacket((byte)7, new String[]{this.agentName}) : this.getResponsePacket((byte)7, new String[]{this.agentName, userName, sourceName});
                    if (resp != null) break block5;
                    return null;
                }
                if (resp.getErrCode() != 1) break block6;
                String revCoAppName = resp.getData((byte)0);
                if (this.agentName.equals(revCoAppName)) break block7;
                LOG.warn((Object)("expect coAppName=" + this.agentName + ", but recevd=" + revCoAppName));
                return null;
            }
            try {
                Properties props = this.getResponseProperties(resp);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("get update user info: " + props));
                }
                return props;
            }
            catch (Exception e) {
                LOG.error((Object)"auto sync_add user fail!", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public Properties getNewUser(String userName) {
        block6: {
            ResponsePacket resp;
            block7: {
                block5: {
                    resp = null;
                    resp = StringHelper.isEmpty(userName) ? this.getResponsePacket((byte)5, new String[]{this.agentName}) : this.getResponsePacket((byte)5, new String[]{this.agentName, userName});
                    if (resp != null) break block5;
                    LOG.warn((Object)"resp=null! skip.");
                    return null;
                }
                if (resp.getErrCode() != 1) break block6;
                String revCoAppName = resp.getData((byte)0);
                if (this.agentName.equals(revCoAppName)) break block7;
                LOG.warn((Object)("expect coAppName=" + this.agentName + ", but recevd=" + revCoAppName), (Throwable)new Exception());
                return null;
            }
            try {
                Properties props = this.getResponseProperties(resp);
                if (LOG.isDebugEnabled()) {
                    LOG.info((Object)("new user info: " + props));
                }
                return props;
            }
            catch (Exception e) {
                LOG.error((Object)"auto sync_add user fail!", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public SSOUser getNewSSOUser(String userName) {
        Properties props = this.getNewUser(userName);
        return this.props2SSOUser(props);
    }

    @Override
    public SSOUser getNewSSOUser(String userName, String sourceName) {
        Properties props = this.getNewUser(userName, sourceName);
        return this.props2SSOUser(props);
    }

    private Properties getNewUser(String userName, String sourceName) {
        block6: {
            ResponsePacket resp;
            block7: {
                block5: {
                    resp = null;
                    resp = StringHelper.isEmpty(userName) ? this.getResponsePacket((byte)5, new String[]{this.agentName}) : this.getResponsePacket((byte)5, new String[]{this.agentName, userName, sourceName});
                    if (resp != null) break block5;
                    LOG.warn((Object)"resp=null! skip.");
                    return null;
                }
                if (resp.getErrCode() != 1) break block6;
                String revCoAppName = resp.getData((byte)0);
                if (this.agentName.equals(revCoAppName)) break block7;
                LOG.warn((Object)("expect coAppName=" + this.agentName + ", but recevd=" + revCoAppName), (Throwable)new Exception());
                return null;
            }
            try {
                Properties props = this.getResponseProperties(resp);
                if (LOG.isDebugEnabled()) {
                    LOG.info((Object)("new user info: " + props));
                }
                return props;
            }
            catch (Exception e) {
                LOG.error((Object)"auto sync_add user fail!", (Throwable)e);
            }
        }
        return null;
    }

    private SSOUser props2SSOUser(Properties props) {
        if (props == null) {
            return null;
        }
        SSOUser ssoUser = new SSOUser(props);
        LOG.debug((Object)("SSOUser: " + ssoUser));
        return ssoUser;
    }

    private SSOGroup props2SSOGroup(Properties props) {
        if (props == null) {
            return null;
        }
        return new SSOGroup(props);
    }

    @Override
    public Properties getDelUser(String userName) {
        block6: {
            ResponsePacket resp;
            block7: {
                block5: {
                    resp = null;
                    resp = StringHelper.isEmpty(userName) ? this.getResponsePacket((byte)6, new String[]{this.agentName}) : this.getResponsePacket((byte)6, new String[]{this.agentName, userName});
                    if (resp != null) break block5;
                    return null;
                }
                if (resp.getErrCode() != 1) break block6;
                String revCoAppName = resp.getData((byte)0);
                if (this.agentName.equals(revCoAppName)) break block7;
                LOG.warn((Object)("expect coAppName=" + this.agentName + ", but recevd=" + revCoAppName));
                return null;
            }
            try {
                Properties props = this.getResponsePropertiesByDelUser(resp);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("del user info: " + props));
                }
                return props;
            }
            catch (Exception e) {
                LOG.error((Object)"auto sync_del user fail!", (Throwable)e);
            }
        }
        return null;
    }

    private Properties getResponsePropertiesByDelUser(ResponsePacket responsePacket) {
        Properties props = new Properties();
        int tokenIndex = 0;
        int dataCount = responsePacket.getDataCountAsInt();
        int i = 1;
        while (i < dataCount) {
            if (dataCount == 2) {
                props.setProperty("userName", responsePacket.getData(i));
            } else {
                tokenIndex = responsePacket.getData(i).indexOf(58);
                if (tokenIndex > 0) {
                    props.setProperty(responsePacket.getData(i).substring(0, tokenIndex), responsePacket.getData(i).substring(tokenIndex + 1));
                }
            }
            ++i;
        }
        return props;
    }

    @Override
    public SSOUser getDelSSOUser(String userName) {
        Properties props = new Properties();
        props.put("userName", userName);
        return this.props2SSOUser(props);
    }

    @Override
    public SSOUser getDelSSOUser(String userName, String sourceName) {
        Properties props = new Properties();
        try {
            props.put("userName", userName);
            props.put("sourceName", sourceName);
        }
        catch (Exception e) {
            LOG.error((Object)("Put userName[" + userName + "] and sourceName[" + sourceName + "] to properties fail! "), (Throwable)e);
        }
        return this.props2SSOUser(props);
    }

    @Override
    public SSOGroup getNewSSOGroup(String groupName) {
        Properties props = this.getNewGroup(groupName);
        return this.props2SSOGroup(props);
    }

    @Override
    public SSOGroup getNewSSOGroup(String groupName, String sourceName, String groupDN) {
        Properties props = this.getNewGroup(groupName, sourceName, groupDN);
        return this.props2SSOGroup(props);
    }

    private Properties getNewGroup(String groupName, String sourceName, String groupDN) {
        block6: {
            ResponsePacket resp;
            block7: {
                block5: {
                    resp = this.getResponsePacket((byte)21, new String[]{this.agentName, groupName, sourceName, groupDN});
                    if (resp != null) break block5;
                    LOG.error((Object)("Group:" + groupName + "," + 21 + ",agentName:" + this.agentName + ", sourceName: " + sourceName + ", groupDN: " + groupDN + " is failed(resp == null)."));
                    return null;
                }
                if (resp.getErrCode() != 1) break block6;
                String revCoAppName = resp.getData((byte)0);
                if (this.agentName.equals(revCoAppName)) break block7;
                LOG.warn((Object)("expect coAppName=" + this.agentName + ", but received = " + revCoAppName));
                return null;
            }
            try {
                Properties props = this.getResponseProperties(resp);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("new group info: " + props));
                }
                return props;
            }
            catch (Exception e) {
                LOG.error((Object)"auto sync_add group fail!", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public SSOGroup getUpdSSOGroup(String groupName) {
        Properties props = this.getUpdateGroup(groupName);
        return this.props2SSOGroup(props);
    }

    @Override
    public SSOGroup getUpdSSOGroup(String groupName, String sourceName, String groupDN) {
        Properties props = this.getUpdateGroup(groupName, sourceName, groupDN);
        return this.props2SSOGroup(props);
    }

    private Properties getUpdateGroup(String groupName, String sourceName, String groupDN) {
        block5: {
            ResponsePacket resp;
            block6: {
                block4: {
                    resp = this.getResponsePacket((byte)23, new String[]{this.agentName, groupName, sourceName, groupDN});
                    if (resp != null) break block4;
                    return null;
                }
                if (resp.getErrCode() != 1) break block5;
                String revCoAppName = resp.getData((byte)0);
                if (this.agentName.equals(revCoAppName)) break block6;
                LOG.warn((Object)("expect coAppName=" + this.agentName + ", but received = " + revCoAppName));
                return null;
            }
            try {
                Properties props = this.getResponseProperties(resp);
                LOG.info((Object)("update group info: " + props));
                return props;
            }
            catch (Exception e) {
                LOG.error((Object)"auto sync_update group fail!", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public SSOGroup getDelSSOGroup(String groupName, String sourceName, String groupDN) {
        Properties props = this.getDelGroup(groupName, sourceName, groupDN);
        return this.props2SSOGroup(props);
    }

    private Properties getDelGroup(String groupName, String sourceName, String groupDN) {
        block5: {
            ResponsePacket resp;
            block6: {
                block4: {
                    resp = this.getResponsePacket((byte)22, new String[]{this.agentName, groupName, sourceName, groupDN});
                    if (resp != null) break block4;
                    return null;
                }
                if (resp.getErrCode() != 1) break block5;
                String revCoAppName = resp.getData((byte)0);
                if (this.agentName.equals(revCoAppName)) break block6;
                LOG.warn((Object)("expect coAppName=" + this.agentName + ", but received = " + revCoAppName));
                return null;
            }
            try {
                Properties props = this.getResponseProperties(resp);
                LOG.info((Object)("sync del group info: " + props));
                return props;
            }
            catch (Exception e) {
                LOG.error((Object)"auto sync_del group fail!", (Throwable)e);
            }
        }
        return null;
    }

    private Properties getResponseProperties(ResponsePacket responsePacket) {
        Properties props = new Properties();
        int tokenIndex = 0;
        int dataCount = responsePacket.getDataCountAsInt();
        int i = 1;
        while (i < dataCount) {
            tokenIndex = responsePacket.getData(i).indexOf(58);
            if (tokenIndex > 0) {
                props.setProperty(responsePacket.getData(i).substring(0, tokenIndex), responsePacket.getData(i).substring(tokenIndex + 1));
            }
            ++i;
        }
        return props;
    }

    @Override
    public SSOGroup getDelSSOGroup(String groupName) {
        Properties props = this.getDelGroup(groupName);
        return this.props2SSOGroup(props);
    }

    private Properties getNewGroup(String groupName) {
        block6: {
            ResponsePacket resp;
            block7: {
                block5: {
                    resp = this.getResponsePacket((byte)21, new String[]{this.agentName, groupName});
                    if (resp != null) break block5;
                    LOG.error((Object)("Group:" + groupName + "," + 21 + ",agentName:" + this.agentName + " is failed(resp == null)."));
                    return null;
                }
                if (resp.getErrCode() != 1) break block6;
                String revCoAppName = resp.getData((byte)0);
                if (this.agentName.equals(revCoAppName)) break block7;
                LOG.warn((Object)("expect coAppName=" + this.agentName + ", but received = " + revCoAppName));
                return null;
            }
            try {
                Properties props = this.getResponseProperties(resp);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("new group info: " + props));
                }
                return props;
            }
            catch (Exception e) {
                LOG.error((Object)"auto sync_add group fail!", (Throwable)e);
            }
        }
        return null;
    }

    private Properties getDelGroup(String groupName) {
        block5: {
            ResponsePacket resp;
            block6: {
                block4: {
                    resp = this.getResponsePacket((byte)22, new String[]{this.agentName, groupName});
                    if (resp != null) break block4;
                    return null;
                }
                if (resp.getErrCode() != 1) break block5;
                String revCoAppName = resp.getData((byte)0);
                if (this.agentName.equals(revCoAppName)) break block6;
                LOG.warn((Object)("expect coAppName=" + this.agentName + ", but received = " + revCoAppName));
                return null;
            }
            try {
                Properties props = this.getResponseProperties(resp);
                LOG.info((Object)("sync del group info: " + props));
                return props;
            }
            catch (Exception e) {
                LOG.error((Object)"auto sync_del group fail!", (Throwable)e);
            }
        }
        return null;
    }

    private Properties getUpdateGroup(String groupName) {
        block5: {
            ResponsePacket resp;
            block6: {
                block4: {
                    resp = this.getResponsePacket((byte)23, new String[]{this.agentName, groupName});
                    if (resp != null) break block4;
                    return null;
                }
                if (resp.getErrCode() != 1) break block5;
                String revCoAppName = resp.getData((byte)0);
                if (this.agentName.equals(revCoAppName)) break block6;
                LOG.warn((Object)("expect coAppName=" + this.agentName + ", but received = " + revCoAppName));
                return null;
            }
            try {
                Properties props = this.getResponseProperties(resp);
                LOG.info((Object)("update group info: " + props));
                return props;
            }
            catch (Exception e) {
                LOG.error((Object)"auto sync_update group fail!", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public boolean notifyTimeout(String sessionId) {
        ResponsePacket resp = null;
        try {
            resp = this.getResponsePacket((byte)3, new String[]{this.agentName, sessionId});
        }
        catch (Exception e) {
            LOG.error((Object)(String.valueOf(sessionId) + " timeout error!"), (Throwable)e);
            return false;
        }
        if (resp == null) {
            LOG.error((Object)(String.valueOf(sessionId) + " timeout error: resp=null!"));
            return false;
        }
        if (resp.getErrCode() == 1) {
            return true;
        }
        LOG.error((Object)(String.valueOf(sessionId) + " timeout fail!"));
        return false;
    }

    @Override
    public final void asyncNotifyTimeout(String sessionId) {
        if (this.asyncNotifier == null) {
            return;
        }
        this.asyncNotifier.addNotify(sessionId);
    }

    @Override
    public String getGlobalLoginUrl() {
        if (this.globalLoginUrl == null) {
            this.globalLoginUrl = this.getSSOURLfromIDS();
            LOG.info((Object)("globalLoginUrl=" + this.globalLoginUrl));
        }
        return this.globalLoginUrl;
    }

    @Override
    public String getProxyGlobalLoginUrl() {
        return this.proxyGlobalLoginUrl;
    }

    protected void getSameDomainSSOInfoFromIDS() {
        if (this.readSameDomainConfigFromLocal) {
            LOG.debug((Object)"Already read same domain sso config from trsids-agent.properties, so will not ask IDS Server again, return");
            return;
        }
        try {
            ResponsePacket resp = this.getResponsePacket((byte)92, new String[]{this.agentName});
            if (resp == null) {
                LOG.error((Object)"Get same domain info from IDS, response from IDS is null");
                return;
            }
            byte idsResponseCode = resp.getErrCode();
            LOG.debug((Object)("IDS Response code is: " + idsResponseCode));
            if (idsResponseCode == 1) {
                String idsSupportSDSSOString = resp.getData((byte)0);
                String coAppSupportSDSSOString = resp.getData((byte)1);
                String commonDomain = resp.getData((byte)2);
                String commonPath = resp.getData((byte)3);
                String idsPath = resp.getData((byte)4);
                LOG.info((Object)("Get message from ids success, idsSupportSDSSOString: " + idsSupportSDSSOString + "; coAppSupportSDSSOString: " + coAppSupportSDSSOString + ";commonDomain: " + commonDomain + ";commonPath: " + commonPath + ";idsPath: " + idsPath));
                this.sdSSOCommonCookieDomain = commonDomain;
                this.sdSSOCommonCookiePath = commonPath;
                this.sdSSOIDSCookiePath = idsPath;
                try {
                    this.idsSupportSDSSO = new Boolean(idsSupportSDSSOString);
                    this.appSupportSDSSO = new Boolean(coAppSupportSDSSOString);
                }
                catch (Exception e) {
                    this.idsSupportSDSSO = false;
                    this.appSupportSDSSO = false;
                    LOG.error((Object)"Change supportSDSSOString to boolean error, supportSDSSO set to false now", (Throwable)e);
                }
            } else {
                if (idsResponseCode == -1) {
                    LOG.error((Object)"AgentName sent to IDS Server is null, please check  agent.name is correct in your trsids-agengt.properties");
                    return;
                }
                if (idsResponseCode == -101) {
                    LOG.error((Object)("CoAppName[" + this.agentName + "] is not exist in IDS, please check agent.name is correct in your trsids-agengt.properties"));
                    return;
                }
                LOG.error((Object)"Get same domain info from IDS fail");
                return;
            }
            LOG.info((Object)("SameDomain parameter in Agent, IDS SupportSDSSO: " + this.idsSupportSDSSO + "; App supportSDSSO: " + this.appSupportSDSSO + ";sdSSOCommonCookieDomain: " + this.sdSSOCommonCookieDomain + ";sdSSOCommonCookiePath: " + this.sdSSOCommonCookiePath + ";sdSSOIDSCookiePath: " + this.sdSSOIDSCookiePath));
        }
        catch (Exception e) {
            LOG.error((Object)"Get same domain info from IDS error", (Throwable)e);
        }
    }

    public void updateSSOURL(String ssoUrl) {
        if (ssoUrl == null || ssoUrl.length() == 0) {
            this.globalLoginUrl = this.getSSOURLfromIDS();
            return;
        }
        this.globalLoginUrl = ssoUrl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSSOURLfromIDS() {
        try {
            ResponsePacket resp = this.getResponsePacket((byte)91, new String[]{this.agentName});
            if (resp != null && resp.getErrCode() == 1) {
                String ssoUrl = resp.getData((byte)0);
                if (StringHelper.isEmpty(ssoUrl)) {
                    LOG.error((Object)"Get SSOUrl from IDS is null, please login IDS Console to check whether sso url is configurated", new Throwable());
                    return null;
                }
                return ssoUrl;
            }
            LOG.error((Object)("fail to get SSOURL! agentName: " + this.agentName + ",resp: " + resp));
            throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6SSOURL!");
        }
        catch (IOException e) {
            LOG.error((Object)"fail to get SSOURL!", (Throwable)e);
            throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6SSOURL!", e);
        }
        catch (IdMException e) {
            LOG.error((Object)"fail to get SSOURL!", (Throwable)e);
            throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6SSOURL!", e);
        }
    }

    @Override
    public boolean isAllowAnonymous() {
        return this.allowAnonymous;
    }

    @Override
    public String getCoAppActorClassName() {
        return this.coAppActorClassName;
    }

    @Override
    public String getAgentName() {
        return this.agentName;
    }

    @Override
    public IWebCoAppActor getWebAppActor() {
        return this.appActor;
    }

    @Override
    public IServletAppActorV2 getServletAppActorV2() {
        return this.actorV2;
    }

    private IServletAppActorV2 createServletAppActorV2() {
        Object obj = null;
        try {
            obj = Class.forName(this.coAppActorClassName).newInstance();
        }
        catch (Throwable t) {
            System.err.println("createServletAppActor: [ " + this.coAppActorClassName + " ] fail!");
            t.printStackTrace(System.err);
            LOG.error((Object)("createServletAppActor: [ " + this.coAppActorClassName + " ] fail!"), t);
        }
        if (obj instanceof IServletAppActor) {
            return new ServletAppActorV2Wrapper(new LegacyActorAdapterV2(obj), this);
        }
        if (obj instanceof IWebCoAppActor) {
            return new ServletAppActorV2Wrapper(new LegacyActorAdapterV2(new LegacyActorAdapter(obj)), this);
        }
        if (obj instanceof IServletAppActorV2) {
            return new ServletAppActorV2Wrapper(obj, this);
        }
        LOG.error((Object)("created Actor type is unknown, coAppActorClassName: " + this.coAppActorClassName + ",type: " + obj));
        throw new RuntimeException("created Actor type is unknown, coAppActorClassName: " + this.coAppActorClassName + ",type: " + obj);
    }

    @Override
    public String[] getIgnoreUrlPrefixes() {
        return PropertyUtil.getPropertyAsStrAry(this.props, "ignoreUrl.prefix", ",");
    }

    @Override
    public String getLoginActionUri() {
        return PropertyUtil.getTrimString(this.props, "loginAction.uri", "/login");
    }

    String getLogoutUri() {
        return PropertyUtil.getTrimString(this.props, "logout.uri", "/logout.jsp");
    }

    public static void appendAgentLog4JConfig(String cfgFileInClassPath) {
        String agentLog4JFile = ResourceUtil.getFullPath(AgentBase.class, cfgFileInClassPath);
        if (agentLog4JFile != null) {
            PropertyConfigurator.configureAndWatch((String)agentLog4JFile);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append(super.toString());
        sb.append(". agentName=").append(this.agentName);
        sb.append("; props=").append(this.props);
        sb.append(". [buildinfo]=").append(AgentVersion.getReleaseInfo());
        return sb.toString();
    }

    public AgentBase(String cfgFile) throws IdMException {
        this.configFile = cfgFile;
    }

    @Override
    public boolean logout(String sessionId) throws IOException {
        boolean result;
        ResponsePacket resp = null;
        try {
            resp = this.getResponsePacket((byte)2, new String[]{this.agentName, sessionId});
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("logout fail! sessId=" + sessionId + ", err=" + e));
        }
        boolean bl = result = resp != null && resp.getErrCode() == 1;
        if (!result) {
            LOG.warn((Object)("logout fail! sessId=" + sessionId + ", resp=" + resp));
        }
        return result;
    }

    protected abstract TransferResult doTransfer(byte[] var1) throws IOException, ClientTransferException;

    protected abstract TransferResult doTransfer(byte[] var1, String var2) throws IOException, ClientTransferException;

    ResponsePacket getResponsePacket(byte cmd, String[] data) throws IOException, IdMException {
        return this.getResponsePacket(cmd, data, null);
    }

    ResponsePacket getResponsePacket(byte cmd, String[] data, String nodeKey) throws IOException, IdMException {
        ResponseResult responseResult = this.getResponseResult(cmd, data, nodeKey);
        if (responseResult == null) {
            LOG.warn((Object)("get responseResult is null by cmd[" + cmd + "], data[" + data + "], nodeKey[" + nodeKey + "]"));
            return null;
        }
        return responseResult.getResponsePacket();
    }

    ResponseResult getResponseResult(byte cmd, String[] data) throws IdMException, IOException {
        return this.getResponseResult(cmd, data, null);
    }

    ResponseResult getResponseResult(byte cmd, String[] data, String nodeKey, boolean shouldGetIdmServerCharset) throws IdMException, IOException {
        ResponsePacket resPacket;
        TransferResult tr;
        byte[] bytesResp;
        ProtocolPacket packet;
        RequestPacket req = new RequestPacket(cmd, data, null);
        if (shouldGetIdmServerCharset) {
            req = new RequestPacket(cmd, data, this.getIdmServerCharset());
        }
        if (!((packet = PacketUtil.parseFromBytes(bytesResp = (tr = this.doTransfer(req.toBytes(), nodeKey)).getBytes())) instanceof ResponsePacket)) {
            LOG.error((Object)("received: [" + packet + "] not a ResponsePacket! request cmd=" + cmd + ", data=" + StringHelper.toString(data) + "; bytesResp: [" + StringHelper.toString(bytesResp) + "]"), (Throwable)new Exception());
            throw new IOException("Received Packet is not a IDS ResponsePacket! [" + StringHelper.toString(bytesResp) + "]");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("receive packet = " + packet + " with shouldGetIdmServerCharset[" + shouldGetIdmServerCharset + "], idmServerCharset[" + this.idmServerCharset + "]"));
        }
        if (cmd != (resPacket = (ResponsePacket)packet).getProcessCommand()) {
            LOG.error((Object)("request/response not match! reqCmd=" + cmd + ", respCmd=" + resPacket.getProcessCommand()), (Throwable)new Exception());
        }
        return new ResponseResult(resPacket, tr.getNodeKey());
    }

    ResponseResult getResponseResult(byte cmd, String[] data, String nodeKey) throws IdMException, IOException {
        return this.getResponseResult(cmd, data, nodeKey, true);
    }

    protected abstract void onLoadProperties();

    void loadProperties(Properties props) {
        String agentName = props.getProperty("agent.name");
        String host = props.getProperty("idm.server.host");
        int port = PropertyUtil.getPropertyAsInt(props, "idm.server.port", 2005);
        this.init(agentName, host, port);
        this.nSocket = PropertyUtil.getPropertyAsInt(props, "idm.sockets.amount", 5);
        if (this.nSocket > 100) {
            this.nSocket = 100;
        } else if (this.nSocket < 1) {
            this.nSocket = 1;
        }
        this.onLoadProperties();
        this.allowAnonymous = "y".equals(PropertyUtil.getTrimString(props, "allow.anonymous", ""));
        this.coAppActorClassName = PropertyUtil.getTrimString(props, "coAppActor.className", "");
        this.squidUrl = this.parseSquidBaseUrl(props, "squid.baseUrl");
        this.anonymousFlag = "com.trs.idm.gSessionId." + agentName;
        this.continueLocalLoginIfUserNotFoundOnIDS = PropertyUtil.getPropertyAsBool(props, "sso.ifUserNotExistOnIDS.useLocalLoginLogic", false);
        this.selfLoginPageUserNameField = PropertyUtil.getTrimString(props, "sso.selfLoginPage.userName.field", "userName");
        this.selfLoginPagePasswordField = PropertyUtil.getTrimString(props, "sso.selfLoginPage.password.field", "password");
        this.coAppSelfLoginActionURL = PropertyUtil.getTrimString(props, "sso.ifUserNotExistOnIDS.selfLoginPage.action.url", "");
        this.needSavePostParamAndPostBack = PropertyUtil.getPropertyAsBool(props, "afterLoginOk.needPostBack", false);
        this.globalLoginUrl = PropertyUtil.getTrimString(props, "ssoUrl", null);
        this.proxyGlobalLoginUrl = PropertyUtil.getTrimString(props, "ssoUrl.proxy", null);
        this.socketCommunicationSessionSticky = PropertyUtil.getPropertyAsBool(props, "socket.sessionSticky", true);
        this.originalClientIPHttpHeaderToken = PropertyUtil.getTrimString(props, "http.headers.originalClientAddr", null);
        this.originalHostHttpHeader = PropertyUtil.getTrimString(props, "http.headers.originalHost", null);
        this.appFirstRedirectToIDSReturnUrlPrefix = PropertyUtil.getTrimString(props, "sso.crossdomain.first_redirect_surl_prefix", "");
        this.coAppVersion = PropertyUtil.getTrimString(props, "coApp.version", null);
        this.coAppType = PropertyUtil.getTrimString(props, "coApp.type", null);
        this.coAppRootUrl = PropertyUtil.getTrimString(props, "coApp.rootUrl", null);
        this.notifyUrl = PropertyUtil.getTrimString(props, "coApp.notifyUrl", null);
        this.agentFirstStart = PropertyUtil.getPropertyAsBool(props, "agent.first.start", false);
        this.groupSynchronize = PropertyUtil.getPropertyAsBool(props, "coApp.group.synchronization", false);
        this.userSynchronize = PropertyUtil.getPropertyAsBool(props, "coApp.user.synchronization", false);
        this.appAuthBy = PropertyUtil.getPropertyAsInt(props, "coApp.auth.by", -1);
        String idsSupportSDSSOString = PropertyUtil.getTrimString(props, "sso.samedomain.ids_supported", null);
        String appSupportSDSSOString = PropertyUtil.getTrimString(props, "sso.samedomain.agent_supported", null);
        if (!StringHelper.isEmpty(idsSupportSDSSOString) && !StringHelper.isEmpty(appSupportSDSSOString)) {
            this.idsSupportSDSSO = PropertyUtil.getPropertyAsBool(props, "sso.samedomain.ids_supported", false);
            this.appSupportSDSSO = PropertyUtil.getPropertyAsBool(props, "sso.samedomain.agent_supported", false);
            this.sdSSOCommonCookieDomain = PropertyUtil.getTrimString(props, "sso.samedomain.cookie_domain", null);
            this.sdSSOCommonCookiePath = PropertyUtil.getTrimString(props, "sso.samedomain.cookie_path", null);
            this.sdSSOIDSCookiePath = PropertyUtil.getTrimString(props, "sso.samedomain.ids_cookie_path", null);
            this.readSameDomainConfigFromLocal = true;
        }
    }

    void resetRTProps() throws IdMException {
        this.parseConfigFromFile();
        LOG.debug((Object)("reload agent properties[" + this.props + "]"));
        this.squidUrl = this.parseSquidBaseUrl(this.props, "squid.baseUrl");
    }

    private String parseSquidBaseUrl(Properties props, String key) {
        String baseUrl = PropertyUtil.getTrimString(props, key, "");
        if (baseUrl != null && baseUrl.endsWith("/")) {
            return baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }

    private void init(String coAppName, String host, int port) {
        if (StringHelper.isEmpty(coAppName)) {
            throw new RuntimeException("the config option 'agent.name' is empty!");
        }
        if (StringHelper.isEmpty(host)) {
            throw new RuntimeException("the config option 'idm.server.host' is empty!");
        }
        if (port <= 1024 || port > 65535) {
            throw new RuntimeException("the value of 'idm.server.port' is invalid: " + port + ". (should: 1024 < x < 65535)");
        }
        this.agentName = coAppName;
        this.encryptAgentName = Base64Util.encode(coAppName);
        this.host = host;
        this.port = port;
    }

    @Override
    public void setServerInfo(String serverInfo) {
        this.serverInfo = serverInfo;
    }

    @Override
    public void setSSOSwitch(boolean ssoSwitch) {
        this.switchOn = ssoSwitch;
    }

    @Override
    public SSOUser findSSOUser(String ssoSessId, String coSessId, String clientIp) throws IdMException, IOException {
        Properties props = this.findUserBySSOSessionId(ssoSessId, coSessId, clientIp);
        return this.props2SSOUser(props);
    }

    @Override
    public SSOUser findSSOUserByLocalSessionId(String sessionId) throws IOException, IdMException {
        Properties props = this.findUserInSession(sessionId);
        return this.props2SSOUser(props);
    }

    @Override
    public SSOUser findSSOUserFromNode(String ssoSessionId, String coSessionId) throws IdMException, IOException {
        if (ssoSessionId == null || coSessionId == null) {
            throw new IllegalArgumentException("ssoSessionId or coSessionId is null!");
        }
        String nodeKey = AgentBase.extractNodeKeyFromSSOSessionId(ssoSessionId);
        if (StringHelper.isEmpty(nodeKey)) {
            return this.findSSOUserByLocalSessionId(coSessionId);
        }
        ResponsePacket resp = null;
        try {
            resp = this.getResponsePacket((byte)1, new String[]{this.agentName, coSessionId}, nodeKey);
        }
        catch (IOException e) {
            LOG.error((Object)("findSSOUserFromNode() fail! so try normal findSSOUser(). ssoSessionId=" + ssoSessionId + ", coSessionId=" + coSessionId), (Throwable)e);
            return this.findSSOUserByLocalSessionId(coSessionId);
        }
        if (resp.getErrCode() == 11) {
            LOG.info((Object)("ssoSessionId=" + ssoSessionId + ", coSessionId=" + coSessionId + ", respCode=" + resp.getErrCode() + "! " + StringHelper.toString(resp.toBytes())));
            return null;
        }
        Properties props = this.parseUserProps(resp, coSessionId);
        return this.props2SSOUser(props);
    }

    public static String extractNodeKeyFromSSOSessionId(String ssoSessionId) {
        if (StringHelper.isEmpty(ssoSessionId) || "ssoTokenCreateNew".equals(ssoSessionId)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("get ssoSessionId[" + ssoSessionId + "] is empty, can not get nodeKey, return directly!"));
            }
            return null;
        }
        int pos = ssoSessionId.lastIndexOf(45) + 1;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("get pos[" + pos + "] by ssoSessionId[" + ssoSessionId + "]"));
        }
        if (pos <= 0 || pos == ssoSessionId.length() - 1) {
            return null;
        }
        String nodeKey = ssoSessionId.substring(pos);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("get nodeKey[" + nodeKey + "] by pos[" + pos + "] by ssoSessionId[" + ssoSessionId + "]"));
        }
        return nodeKey;
    }

    @Override
    public LoginResult loginUser(String ssoSessionId, String coSessionId, String userName, String passwd, String sourceName, String clientIP) {
        return this.loginUser(ssoSessionId, coSessionId, userName, passwd, sourceName, clientIP, null);
    }

    private LoginResult buildLoginResult(LoginResult lr, ResponsePacket resp, String ssoSessionId, String coSessionId, String userName, String passwd, String clientIP) {
        if (resp == null) {
            lr.setSuccess(false);
            lr.setFailInfo("\u5f97\u5230\u7684\u534f\u8bae\u54cd\u5e94\u5305\u4e3anull!");
            return lr;
        }
        String sdToken = null;
        if (resp.getErrCode() == 1) {
            String loginResultMsg;
            Properties props;
            lr.setSuccess(true);
            sdToken = resp.getData(0);
            if (SameDomainSSOHelper.isSDTokenValid(sdToken)) {
                lr.setSdToken(sdToken);
            }
            if ((props = this.getUserAsPropertiesFromReponse(resp, 2)) == null) {
                LOG.warn((Object)"User properties from IDSServer is null, so agent need to query userinfo by userName from IDS Server.");
            }
            if (props != null && props.size() > 0) {
                try {
                    SSOUser ssoUser = this.props2SSOUser(props);
                    lr.setSSOUser(ssoUser);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Turn User Properties to SSOUser error,this is maybe IDS Server version is lower than 3.5, User Properties is: " + props));
                }
            }
            if (!StringHelper.isEmpty(loginResultMsg = props.getProperty("LoginResultMsg"))) {
                lr.setFailInfoMessage(loginResultMsg);
            }
        }
        if (resp.getErrCode() != 1) {
            LOG.warn((Object)("errCode=" + resp.getErrCode() + "!(gId,coId,user,pwd,ip,loginErrcode,sdToken)=" + ssoSessionId + ',' + coSessionId + ',' + userName + ',' + passwd + ',' + clientIP + "," + resp.getData(1) + "," + sdToken));
            lr.setSuccess(false);
            lr.setFailInfo(resp.getData(0));
            String loginErrCode = resp.getData(1);
            if (loginErrCode == null) {
                lr.setFailCode(1000);
            } else {
                lr.setFailCode(StringHelper.parseInt(loginErrCode.trim()));
            }
        }
        return lr;
    }

    @Override
    public LoginResult loginUser(String gSessionId, String coSessionId, String userName, String passwd, String clientIP) {
        return this.loginUser(gSessionId, coSessionId, userName, passwd, null, clientIP);
    }

    boolean login(String gSessionId, String coSessionId, String userName, String passwd, String clientIP) {
        ResponsePacket resp;
        block6: {
            block5: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("gSessId=" + gSessionId + ", coSessId=" + coSessionId + ", userName=" + userName + ", passwd=" + passwd + ", ip=" + clientIP));
                }
                try {
                    resp = this.getResponsePacket((byte)4, new String[]{gSessionId, this.agentName, coSessionId, userName, passwd, clientIP});
                    if (resp != null) break block5;
                    LOG.error((Object)("resp==null! return false!(gId,coId,user,pwd,ip)=" + gSessionId + ',' + coSessionId + ',' + userName + ',' + passwd + ',' + clientIP));
                    return false;
                }
                catch (Exception e) {
                    LOG.error((Object)("login fail!(gId,coId,user,pwd,ip)=" + gSessionId + ',' + coSessionId + ',' + userName + ',' + passwd + ',' + clientIP), (Throwable)e);
                    return false;
                }
            }
            if (resp.getErrCode() != 1) break block6;
            return true;
        }
        LOG.warn((Object)("errCode=" + resp.getErrCode() + "!(gId,coId,user,pwd,ip)=" + gSessionId + ',' + coSessionId + ',' + userName + ',' + passwd + ',' + clientIP));
        return false;
    }

    @Override
    public SSOUser findLoginSSOUser(String ssoSessionId, String coSessionId) throws IdMException, IOException {
        if (coSessionId == null) {
            throw new IllegalArgumentException("coSessionId is null!");
        }
        ResponseResult rr = this.getResponseResult((byte)1, new String[]{this.agentName, coSessionId});
        ResponsePacket resp = rr.getResponsePacket();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("receive packet when findLoginSSOUser(ssoSessionId:" + ssoSessionId + "; coSessionId: " + coSessionId + ") = " + resp));
        }
        if (resp.getErrCode() == 10 || resp.getErrCode() == 11) {
            LOG.info((Object)("no-login user! nodeKey=" + rr.getNodeKey() + ", ssoSessionId=" + ssoSessionId + ", coSessionId=" + coSessionId + ", respCode=" + resp.getErrCode() + "! " + StringHelper.toString(resp.toBytes())));
            String[] nodeKeys = this.getOtherKnownNodeKeys(rr.getNodeKey());
            if (nodeKeys == null || nodeKeys.length == 0) {
                return null;
            }
            int i = 0;
            while (i < nodeKeys.length) {
                rr = this.getResponseResult((byte)1, new String[]{this.agentName, coSessionId}, nodeKeys[i]);
                resp = rr.getResponsePacket();
                if (resp.getErrCode() == 1) break;
                LOG.warn((Object)("choose another nodekey but still no-login user! nodeKey=" + nodeKeys[i] + ", ssoSessionId=" + ssoSessionId + ", coSessionId=" + coSessionId + ", respCode=" + resp.getErrCode()));
                ++i;
            }
        }
        Properties props = this.parseUserProps(resp, coSessionId);
        return this.props2SSOUser(props);
    }

    @Override
    public Properties findUserInSession(String sessionId) throws IOException, IdMException {
        if (sessionId == null) {
            throw new IllegalArgumentException("sessionId is null!");
        }
        ResponsePacket resp = this.getResponsePacket((byte)1, new String[]{this.agentName, sessionId});
        if (LOG.isDebugEnabled() && resp != null) {
            LOG.debug((Object)("receive response packet from byte position at[0] = " + resp.getData((byte)0) + " while find user by sessionId[" + sessionId + "]"));
        }
        if (resp.getErrCode() == 11) {
            LOG.info((Object)("coSessionId=" + sessionId + ", respCode=" + resp.getErrCode() + "! " + StringHelper.toString(resp.toBytes())));
            return null;
        }
        return this.parseUserProps(resp, sessionId);
    }

    private Properties parseUserProps(ResponsePacket resp, String sessionId) throws IdMException, IOException {
        if (resp == null) {
            throw new IdMException("\u5f97\u5230\u7684\u534f\u8bae\u54cd\u5e94\u5305\u4e3anull!");
        }
        if (resp.getErrCode() == 1) {
            String revCoSessId = resp.getData((byte)0);
            if (!sessionId.equals(revCoSessId)) {
                LOG.warn((Object)("expect sessId=" + sessionId + ", but recev=" + revCoSessId));
                LOG.warn((Object)("bodyLength=" + resp.getBodyLength() + ", allData=" + resp.getAllData()));
                return null;
            }
            Properties props = new Properties();
            int tokenIndex = 0;
            int dataCount = resp.getDataCountAsInt();
            int i = 1;
            while (i < dataCount) {
                tokenIndex = resp.getData(i).indexOf(58);
                if (tokenIndex > 0) {
                    props.setProperty(resp.getData(i).substring(0, tokenIndex), resp.getData(i).substring(tokenIndex + 1));
                }
                ++i;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("get user info: " + props));
            }
            return props;
        }
        if (resp.getErrCode() == 12) {
            throw new IdMException("\u7528\u6237\u6ca1\u6709\u8bbf\u95ee\u534f\u4f5c\u5e94\u7528\u7684\u8bb8\u53ef!");
        }
        if (resp.getErrCode() == 10) {
            return null;
        }
        if (resp.getErrCode() == 11) {
            return null;
        }
        LOG.error((Object)("sessId=" + sessionId + ", respCode=" + resp.getErrCode() + ", resp bytes: " + StringHelper.toString(resp.toBytes()) + ", resp string:" + resp.getAllData()));
        throw new IdMException("\u7528\u6237\u4e0d\u80fd\u767b\u5f55\u5e94\u7528, \u54cd\u5e94\u7801=" + resp.getErrCode());
    }

    @Override
    public Properties findUserBySSOSessionId(String ssoSessId, String coSessId, String clientIp) throws IOException, IdMException {
        ResponsePacket resp;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("cmd=10, ssoSessId=" + ssoSessId + ",coSessionId=" + coSessId));
        }
        if ((resp = this.getResponsePacket((byte)10, new String[]{this.agentName, ssoSessId, coSessId, clientIp})) == null) {
            throw new IdMException("\u5f97\u5230\u7684\u534f\u8bae\u54cd\u5e94\u5305\u4e3anull!");
        }
        if (resp.getErrCode() == 1) {
            String revCoSessId = resp.getData((byte)0);
            if (!coSessId.equals(revCoSessId)) {
                LOG.warn((Object)("expect sessId=" + coSessId + ", but recev=" + revCoSessId));
                return null;
            }
            return this.getUserAsPropertiesFromReponse(resp, 1);
        }
        if (resp.getErrCode() == 10) {
            throw new NoSuchSSOIDException(ssoSessId);
        }
        if (resp.getErrCode() == 11) {
            throw new IdMException("\u672a\u767b\u5f55\u6216\u975e\u6cd5IP! \u8bf7\u5230IDS\u7ba1\u7406\u53f0\u65e5\u5fd7\u7ba1\u7406\u4e2d\u67e5\u770b\u767b\u5f55\u5931\u8d25\u7684\u8bb0\u5f55!");
        }
        if (resp.getErrCode() == 12) {
            throw new IdMException("\u7528\u6237\u6ca1\u6709\u8bbf\u95ee\u534f\u4f5c\u5e94\u7528\u7684\u8bb8\u53ef!");
        }
        throw new IdMException("\u6ca1\u6709\u901a\u8fc7\u9a8c\u8bc1, \u8be6\u7ec6\u539f\u56e0\u8bf7\u5230IDS\u7ba1\u7406\u53f0\u65e5\u5fd7\u7ba1\u7406\u4e2d\u67e5\u770b\u767b\u5f55\u5931\u8d25\u7684\u8bb0\u5f55! resp.getErrCode()=" + resp.getErrCode());
    }

    @Override
    public boolean federalLogin(String gSessionId, String coSessionId, String userName, String clientIP) {
        block6: {
            ResponsePacket resp;
            block5: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("gSessId=" + gSessionId + ", coSessId=" + coSessionId + ", userName=" + userName + ", ip=" + clientIP));
                }
                try {
                    resp = this.getResponsePacket((byte)11, new String[]{gSessionId, this.agentName, coSessionId, userName, clientIP});
                    if (resp != null) break block5;
                    LOG.debug((Object)"resp==null! return false");
                    return false;
                }
                catch (Exception e) {
                    LOG.error((Object)("create IDS SSOSession fail!(gId,coId,user,pwd,ip)=" + gSessionId + ',' + coSessionId + ',' + userName + ',' + clientIP), (Throwable)e);
                    return false;
                }
            }
            if (resp.getErrCode() != 1) break block6;
            return true;
        }
        LOG.warn((Object)("create IDS SSOSession fail!(gId,coId,user,pwd,ip)=" + gSessionId + ',' + coSessionId + ',' + userName + ',' + clientIP));
        return false;
    }

    @Override
    public String findSSOID(String sessionId) throws IOException, IdMException {
        ResponsePacket resp;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("sessionId=" + sessionId));
        }
        if ((resp = this.getResponsePacket((byte)9, new String[]{this.agentName, sessionId})) == null) {
            throw new IdMException("\u5f97\u5230\u7684\u534f\u8bae\u54cd\u5e94\u5305\u4e3anull!");
        }
        if (resp.getErrCode() == 1) {
            String revCoSessId = resp.getData((byte)0);
            if (!sessionId.equals(revCoSessId)) {
                LOG.warn((Object)("expect sessId=" + sessionId + ", but recev=" + revCoSessId));
                return null;
            }
            return resp.getData((byte)1);
        }
        return null;
    }

    @Override
    public String findProxyUserNameAndPwd(String agentName, String userName, String sourceName) throws IOException, IdMException, IOException {
        ResponsePacket resp;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("agentName=" + agentName + ",userName=" + userName + ",sourceName=" + sourceName));
        }
        if ((resp = this.getResponsePacket((byte)14, new String[]{agentName, userName, sourceName})) == null) {
            throw new IdMException("\u5f97\u5230\u7684\u534f\u8bae\u54cd\u5e94\u5305\u4e3anull!");
        }
        if (resp.getErrCode() == 1) {
            String proxyUserName = resp.getData((byte)0);
            String proxyPassword = resp.getData((byte)1);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("proxyUserName=" + proxyUserName + ",proxyPassword=" + proxyPassword));
            }
            return String.valueOf(proxyUserName) + "-" + proxyPassword;
        }
        return null;
    }

    @Override
    public String getProperty(String key) {
        return PropertyUtil.getTrimString(this.props, key, "");
    }

    @Override
    public String getProperty(String key, String defValue) {
        return PropertyUtil.getTrimString(this.props, key, defValue);
    }

    @Override
    public int getPropertyAsInt(String key, int defValue) {
        return PropertyUtil.getPropertyAsInt(this.props, key, defValue);
    }

    AgentBase(String coAppName, String host, int port) {
        this.init(coAppName, host, port);
    }

    @Override
    public VerifyResult verifyUser(VerifyReqInfo vrInfo) {
        return this.verifyUser(vrInfo.getUserName(), vrInfo.getPassword(), vrInfo.getClientIP());
    }

    @Override
    public VerifyResult verifyUser(String userName, String passwd, String clientIP) {
        VerifyResult vrResult = new VerifyResult();
        ResponsePacket resp = null;
        try {
            resp = this.getResponsePacket((byte)12, new String[]{this.agentName, userName, passwd, clientIP});
        }
        catch (Exception e) {
            vrResult.setLegal(false);
            vrResult.setFailInfo(e.toString());
            LOG.error((Object)("verifyUser fail! user=" + userName), (Throwable)e);
            return vrResult;
        }
        if (resp == null) {
            vrResult.setLegal(false);
            vrResult.setFailInfo("\u5f97\u5230\u7684\u534f\u8bae\u54cd\u5e94\u5305\u4e3anull!");
            return vrResult;
        }
        if (resp.getErrCode() == 1) {
            vrResult.setLegal(true);
            Properties props = this.getResponseProperties(resp);
            LOG.debug((Object)("get verify user properties[" + props + "] by responsePacket[" + resp + "]"));
            vrResult.setUserName(userName);
            vrResult.setUserNickName(props.getProperty("nickName"));
            vrResult.setUserEmail(props.getProperty("email"));
        } else {
            vrResult.setLegal(false);
            vrResult.setFailInfo("\u65e0\u6548\u7528\u6237\u6216\u5bc6\u7801!");
        }
        return vrResult;
    }

    @Override
    public String buildParamsForSSOUrl(boolean useSSOPage, String coSessionId, HttpServletRequest req) {
        StringBuffer sb = new StringBuffer(256);
        String urlIfLoginSuccess = RequestUtil.getFullGetStr(req);
        LOG.debug((Object)("request.getRequestURL() with queryString: " + urlIfLoginSuccess));
        if (!StringHelper.isEmpty(this.squidUrl)) {
            StringBuffer buf = new StringBuffer(128);
            buf.append(this.squidUrl);
            buf.append(RequestUtil.getRelativePath(req));
            String queryStr = req.getQueryString();
            if (queryStr != null && queryStr.length() > 0) {
                buf.append('?').append(queryStr);
            }
            urlIfLoginSuccess = buf.toString();
        }
        if (RequestUtil.isReverseProxyRequest(req, this.getOriginalHostHttpHeader())) {
            urlIfLoginSuccess = RequestUtil.getOriginalUrlWithParam(req, this.getOriginalHostHttpHeader());
            LOG.info((Object)("This is an reverse proxy proxy, current requestURL: " + RequestUtil.getFullGetStr(req) + " ,originalURL: " + urlIfLoginSuccess));
        }
        if (!StringHelper.isEmpty(this.appFirstRedirectToIDSReturnUrlPrefix)) {
            urlIfLoginSuccess = this.buildSUrlByConfig(req);
        }
        if (!StringHelper.isEmpty(this.proxyGlobalLoginUrl)) {
            sb.append(this.proxyGlobalLoginUrl).append('?');
        } else {
            sb.append(this.globalLoginUrl).append('?');
        }
        sb.append("coAppName=").append(this.encryptAgentName);
        sb.append("&coSessionId=").append(Base64Util.encode(coSessionId));
        String surl = null;
        surl = useSSOPage ? new StringBuffer(160).append(urlIfLoginSuccess).append(urlIfLoginSuccess.indexOf(63) > 0 ? "&" : "?").append("xinhua.sso.page=1").toString() : urlIfLoginSuccess;
        String b64SUrl = Base64Util.encode(surl);
        if (sb.length() + b64SUrl.length() > 960) {
            surl = this.getTemporalSurl(req);
            req.getSession().setAttribute("tmpAppUrl", (Object)urlIfLoginSuccess);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("the URL larger than 1024 byte, the originalUrl = " + urlIfLoginSuccess + ", the redirect url = " + surl));
            }
        }
        sb.append("&surl=").append(b64SUrl);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The final page to return back: " + surl));
        }
        String finalUrlToRedirect = sb.toString();
        LOG.debug((Object)("The final url about to redirect: " + finalUrlToRedirect));
        return finalUrlToRedirect;
    }

    private String buildSUrlByConfig(HttpServletRequest req) {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(this.appFirstRedirectToIDSReturnUrlPrefix);
        strBuffer.append(req.getRequestURI());
        String queryString = req.getQueryString();
        if (!StringHelper.isEmpty(queryString)) {
            strBuffer.append("?");
            strBuffer.append(queryString);
        }
        String urlIfLoginSuccess = strBuffer.toString();
        return urlIfLoginSuccess;
    }

    private String getTemporalSurl(HttpServletRequest req) {
        return String.valueOf(RequestUtil.getContextRoot(req)) + "/idsAgents/GetLongUrlServlet";
    }

    @Override
    public String[] getLogoutURIs() {
        return StringHelper.split(PropertyUtil.getTrimString(this.props, "logout.uri", "/logout.jsp"), ",");
    }

    @Override
    public String[] getLoginActionURIs() {
        return StringHelper.split(PropertyUtil.getTrimString(this.props, "loginAction.uri", "/login"), ",");
    }

    @Override
    public String[] getRegUserURIs() {
        return StringHelper.split(PropertyUtil.getTrimString(this.props, "regUser.uri", "/regUser.jsp"), ",");
    }

    @Override
    public String getRegUserFullUrl() {
        StringBuffer regUserFullUrl = new StringBuffer();
        String globalLoginUrl = this.getGlobalLoginUrl();
        String idsContextUrl = globalLoginUrl.substring(0, globalLoginUrl.lastIndexOf(47));
        return regUserFullUrl.append(idsContextUrl).append("/admin/userhome").append("/select_regType.jsp").append("?").append("regFlg").append("=" + Base64Util.encode(this.getAgentName())).toString();
    }

    @Override
    public String getIdsContextPath() {
        if (this.globalLoginUrl == null) {
            LOG.error((Object)"Agent cannot get IDS Context path");
            throw new RuntimeException("Agent cannot get IDS Context path");
        }
        return StringHelper.replaceStr(this.globalLoginUrl, "/LoginServlet", "").trim();
    }

    @Override
    public String buildSSOUrlWithSign(String coAppName, String coSessionId, String userName, String surl, String clientIP) {
        StringBuffer sf = new StringBuffer(256);
        if (StringHelper.isEmpty(coAppName) || StringHelper.isEmpty(coSessionId) || StringHelper.isEmpty(userName) || StringHelper.isEmpty(clientIP)) {
            throw new RuntimeException("coSessionId not allow null");
        }
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String data = String.valueOf(coSessionId) + userName + clientIP;
        String signs = DataSecurityFactory.getDefaultDataSecurity().sign(data);
        sf.append(this.getIdsContextPath()).append("/gLogin4CoApp");
        sf.append("?coAppName=").append(Base64Util.encode(coAppName));
        sf.append("&coSessionId=").append(Base64Util.encode(coSessionId));
        sf.append("&userName=").append(Base64Util.encode(userName));
        sf.append("&surl=").append(Base64Util.encode(surl));
        sf.append("&clientIP=").append(clientIP);
        sf.append("&sign=").append(signs);
        sf.append("&timeStamp=").append(timeStamp);
        return sf.toString();
    }

    public String buildSSOUrlWithSignV2(String method, String coAppName, String coSessionId, String userName, String surl, String clientIP) {
        StringBuffer sf = new StringBuffer(256);
        if (StringHelper.isEmpty(method) || StringHelper.isEmpty(coAppName) || StringHelper.isEmpty(coSessionId) || StringHelper.isEmpty(userName) || StringHelper.isEmpty(clientIP)) {
            throw new RuntimeException("param not allow null");
        }
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String data = String.valueOf(coSessionId) + userName + clientIP;
        String signs = "";
        try {
            signs = DataSecurityFactory.getDefaultDataSecurity().sign(data);
        }
        catch (Exception e) {
            LOG.warn((Object)("create singns error" + e.getMessage()));
        }
        sf.append(this.getIdsContextPath()).append("/gService4CoApp");
        sf.append("?method=").append(method);
        sf.append("&coAppName=").append(Base64Util.encode(coAppName));
        sf.append("&coSessionId=").append(Base64Util.encode(coSessionId));
        sf.append("&userName=").append(Base64Util.encode(userName));
        sf.append("&surl=").append(Base64Util.encode(surl));
        sf.append("&clientIP=").append(clientIP);
        sf.append("&sign=").append(signs);
        sf.append("&timeStamp=").append(timeStamp);
        return sf.toString();
    }

    @Override
    public int getMaxClients() {
        return this.nSocket;
    }

    public void addServerNodeKey(String nodeKey) {
        if (nodeKey == null || nodeKey.length() == 0) {
            return;
        }
        this.serverNodes.add(nodeKey);
    }

    public String[] getAllKnownNodeKeys() {
        return this.serverNodes.toArray(new String[0]);
    }

    String[] getOtherKnownNodeKeys(String nodeKey) {
        String[] allNodes = this.serverNodes.toArray(new String[0]);
        if (nodeKey == null) {
            return allNodes;
        }
        ArrayList<String> list = new ArrayList<String>(2);
        int i = 0;
        while (i < allNodes.length) {
            if (!nodeKey.equals(allNodes[i])) {
                list.add(allNodes[i]);
            }
            ++i;
        }
        return list.toArray(new String[0]);
    }

    @Override
    public String getAnonymousFlag() {
        return this.anonymousFlag;
    }

    public String[] getHosts() {
        return this.hostIPs;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public boolean continueLocalLoginIfUserNotFoundOnIDS() {
        return this.continueLocalLoginIfUserNotFoundOnIDS;
    }

    @Override
    public String getCoAppSelfLoginActionURL() {
        return this.coAppSelfLoginActionURL;
    }

    @Override
    public String getCoAppSelfLoginUserNameField() {
        return this.selfLoginPageUserNameField;
    }

    @Override
    public String getCoAppSelfLoginPagePasswordField() {
        return this.selfLoginPagePasswordField;
    }

    @Override
    public boolean needSavePostParamAndPostBack() {
        return this.needSavePostParamAndPostBack;
    }

    @Override
    public boolean isSSOServerAlive() {
        return this.serverStatusWatcher.isSSOServerAlive();
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public IAgentPropertiesValidator getPropertiesValidator() {
        return this.agentPropertiesValidator;
    }

    @Override
    public String getCoSessionIdFlag() {
        return "com.trs.idm.coSessionId";
    }

    @Override
    public boolean useSSO() {
        return this.switchOn;
    }

    @Override
    public boolean supportSameDomainSSO() {
        return this.appSupportSDSSO;
    }

    @Override
    public String getSDSSOCookieDomain() {
        return this.sdSSOCommonCookieDomain;
    }

    @Override
    public String getSDSSOCookiePath() {
        return this.sdSSOCommonCookiePath;
    }

    @Override
    public String getSDSSOIDSCookiePath() {
        return this.sdSSOIDSCookiePath;
    }

    @Override
    public LoginResult loginUserForSameDomainSSO(String userName, String password, String sourceName, String coSessionId, String clientIP) {
        return this.loginUserForSameDomainSSO(userName, password, sourceName, coSessionId, clientIP, null);
    }

    private Properties getUserAsPropertiesFromReponse(ResponsePacket resp, int startPos) {
        if (resp == null) {
            LOG.warn((Object)"Response is null , can not get User properties, so return null");
            return null;
        }
        Properties props = new Properties();
        int tokenIndex = 0;
        int dataCount = resp.getDataCountAsInt();
        int i = startPos;
        while (i < dataCount) {
            tokenIndex = resp.getData(i).indexOf(58);
            if (tokenIndex > 0) {
                props.setProperty(resp.getData(i).substring(0, tokenIndex), resp.getData(i).substring(tokenIndex + 1));
            }
            ++i;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("get user info: " + props));
        }
        return props;
    }

    @Override
    public boolean idsServerSupportSameDomainSSO() {
        return this.idsSupportSDSSO;
    }

    @Override
    public boolean isSocketCommunicationSessionSticky() {
        return this.socketCommunicationSessionSticky;
    }

    public SocketAddr[] getIDSConnectAddrs() {
        return this.socketAddrs;
    }

    @Override
    public void setProperties(Properties props) {
        this.props = props;
    }

    @Override
    public String getOriginalClientIPHttpHeader() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("get originalClientIPHttpHeaderToken: " + this.originalClientIPHttpHeaderToken));
        }
        return this.originalClientIPHttpHeaderToken;
    }

    @Override
    public String getOriginalHostHttpHeader() {
        LOG.debug((Object)("Get original request host  http header: " + this.originalHostHttpHeader));
        return this.originalHostHttpHeader;
    }

    @Override
    public String getLoginActionMethod() {
        return PropertyUtil.getTrimString(this.props, "loginAction.method", "");
    }

    @Override
    public int getAuthBy() {
        ResponsePacket resp;
        block7: {
            if (this.appAuthBy != -1) {
                LOG.debug((Object)("get appAuthBy[" + this.appAuthBy + "] from coApp[" + this.agentName + "]"));
                return this.appAuthBy;
            }
            resp = null;
            try {
                resp = this.getResponsePacket((byte)94, new String[]{this.agentName});
                if (resp != null) break block7;
                LOG.error((Object)"Get coApp authBy info from IDS, response from IDS is null");
                return 0;
            }
            catch (Exception e) {
                LOG.error((Object)"error while get coapp authBy type info from IDS", (Throwable)e);
                return this.getDefaultAppAuthBy();
            }
        }
        if (resp.getErrCode() == 1) {
            String respData = resp.getData((byte)0);
            this.appAuthBy = Integer.parseInt(respData);
            LOG.debug((Object)("get coApp authBy message from ids, respData: " + respData));
            return this.appAuthBy;
        }
        if (resp.getErrCode() == -1) {
            LOG.error((Object)"AgentName sent to IDS Server is null or can not get response from IDS Server, please check IDS Server and make sure  agent.name is correct in your trsids-agent.properties");
            return this.getDefaultAppAuthBy();
        }
        if (resp.getErrCode() == -101) {
            LOG.error((Object)("CoAppName[" + this.agentName + "] is not exist in IDS, please check agent.name is correct in your trsids-agent.properties"));
            return this.getDefaultAppAuthBy();
        }
        LOG.error((Object)"Get coapp authBy type info from IDS fail");
        return this.getDefaultAppAuthBy();
    }

    private int getDefaultAppAuthBy() {
        this.appAuthBy = 0;
        return this.appAuthBy;
    }

    @Override
    public boolean isInitAndStarted() {
        return this.inited;
    }

    @Override
    public Properties getProperties() {
        return this.props;
    }

    @Override
    public boolean updateProperties(Map properties) throws IOException, IdMException {
        ConfigFileModifier fileModifier = new ConfigFileModifier(this.getClass().getResource("/trsids-agent.properties"));
        fileModifier.modifyProperties(properties);
        try {
            fileModifier.saveModifies();
        }
        catch (IOException e) {
            LOG.error((Object)("get error while update agent properties file by properties[" + properties + "]"), (Throwable)e);
            throw new IOException("\u66f4\u65b0Agent\u914d\u7f6e\u6587\u4ef6\u5931\u8d25!");
        }
        try {
            this.resetRTProps();
        }
        catch (IdMException e) {
            LOG.error((Object)("get error while reset agent properties[" + properties + "]"), (Throwable)e);
            throw new IdMException("\u66f4\u65b0Agent\u914d\u7f6e\u5931\u8d25!", e);
        }
        return true;
    }

    @Override
    public boolean exist(String coAppName) throws IOException, IdMException {
        if (StringHelper.isEmpty(coAppName)) {
            LOG.info((Object)("get coAppName[" + coAppName + "] is empty, so use agentName[" + this.agentName + "] instead"));
            coAppName = this.agentName;
        }
        ResponsePacket resp = null;
        try {
            resp = this.getResponsePacket((byte)104, new String[]{this.agentName});
        }
        catch (Exception e) {
            LOG.error((Object)"auto sync_add user fail!", (Throwable)e);
            return false;
        }
        if (resp == null) {
            return false;
        }
        if (resp.getErrCode() == 1) {
            String respData = resp.getData((byte)0);
            LOG.debug((Object)("notify ids to config user synchronize, respData: " + respData));
            return Boolean.parseBoolean(respData);
        }
        if (resp.getErrCode() == -1) {
            LOG.error((Object)("AgentName[" + coAppName + "] sent to IDS Server is null or can not get response from IDS Server, please check IDS Server and make sure agent.name is correct in your trsids-agent.properties"));
            return false;
        }
        LOG.error((Object)("notify ids to config user synchronize fail, detailInfo:" + resp));
        return false;
    }

    @Override
    public String getAppCharset() {
        LOG.debug((Object)("get agent charset[" + this.appCharset + "]"));
        return this.appCharset;
    }

    @Override
    public String getIdmServerCharset() {
        if (!StringHelper.isEmpty(this.idmServerCharset)) {
            LOG.debug((Object)("get idmServerCharset[" + this.idmServerCharset + "], so return directly!"));
            return this.idmServerCharset;
        }
        ResponsePacket resp = null;
        ResponseResult respResult = null;
        try {
            respResult = this.getResponseResult((byte)105, new String[]{this.agentName}, null, false);
        }
        catch (IdMException e) {
            LOG.error((Object)("Error with command[105]:" + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)("Error with command[105]:" + e.getMessage()), (Throwable)e);
        }
        if (respResult == null) {
            LOG.error((Object)"can not get idmServerCharset from IDS Server, return GBK directly!");
            return "GBK";
        }
        resp = respResult.getResponsePacket();
        if (resp == null) {
            LOG.error((Object)"can not get idmServerCharset from IDS Server, return GBK directly!");
            return "GBK";
        }
        if (resp.getErrCode() == 1) {
            LOG.info((Object)("get idmServerCharset from IDS Server, respData: " + resp.getData(0)));
            this.idmServerCharset = resp.getData(0);
        } else if (resp.getErrCode() == -1) {
            LOG.error((Object)("error while get idmServerCharset from IDS Server, errCode[" + resp.getErrCode() + "], so use GBK direcly!"));
            this.idmServerCharset = "GBK";
        } else if (resp.getErrCode() == -101) {
            LOG.error((Object)("error while get idmServerCharset from IDS Server, errCode[" + resp.getErrCode() + "], so use GBK direcly!"));
            this.idmServerCharset = "GBK";
        } else {
            LOG.error((Object)("can not get idmServerCharset from IDS Server with errCode[" + resp.getErrCode() + "], so use GBK direcly!"));
            this.idmServerCharset = "GBK";
        }
        return this.idmServerCharset;
    }

    @Override
    public boolean refresh(String ssoToken, String coSessionId, String clientIp) throws IdMException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("get coApp[" + this.agentName + "] ssoToken[" + ssoToken + "] with coSessionId[" + coSessionId + "], clientIp[" + clientIp + "] to refresh"));
        }
        if (StringHelper.isEmpty(ssoToken)) {
            throw new IdMException(1011, "ssoToken can not be empty!");
        }
        ResponsePacket resp = null;
        try {
            resp = this.getResponsePacket((byte)82, new String[]{this.agentName, ssoToken, coSessionId, clientIp});
        }
        catch (IOException e) {
            throw new IdMException(1000, e.getMessage());
        }
        if (resp == null) {
            throw new IdMException(1000, "\u5f97\u5230\u7684\u534f\u8bae\u54cd\u5e94\u5305\u4e3anull!");
        }
        String respSsoToken = resp.getData(0);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("get respSsoToken[" + respSsoToken + "] with code[" + 1 + "]"));
        }
        if (resp.getErrCode() == 1) {
            return true;
        }
        String refreshErrMsg = resp.getData(1);
        LOG.info((Object)("refresh respSsoToken[" + respSsoToken + "] failed, errCode[" + resp.getErrCode() + "], refreshErrMsg[" + refreshErrMsg + "]"));
        throw new IdMException(resp.getErrCode(), refreshErrMsg);
    }

    @Override
    public String loginUser(String ssoToken, String coSessionId, String clientIp) throws IdMException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("get coApp[" + this.agentName + "] ssoToken[" + ssoToken + "] with coSessionId[" + coSessionId + "], clientIp[" + clientIp + "] to refresh"));
        }
        if (StringHelper.isEmpty(ssoToken) || "ssoTokenCreateNew".equals(ssoToken)) {
            throw new IdMException(10, "ssoToken[" + ssoToken + "] is not correct!");
        }
        if (StringHelper.isEmpty(coSessionId)) {
            throw new IdMException(1011, "coSessionId can not be empty!");
        }
        ResponsePacket resp = null;
        try {
            resp = this.getResponsePacket((byte)83, new String[]{this.agentName, ssoToken, coSessionId, clientIp});
        }
        catch (IOException e) {
            throw new IdMException(1000, e.getMessage());
        }
        if (resp == null) {
            throw new IdMException(1000, "\u5f97\u5230\u7684\u534f\u8bae\u54cd\u5e94\u5305\u4e3anull!");
        }
        LoginResult lr = new LoginResult();
        if (resp.getErrCode() == 1) {
            String respSsoToken = resp.getData(0);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("get respSsoToken[" + respSsoToken + "] with code[" + 1 + "]"));
            }
            if ((lr = this.buildLoginResult(lr, resp, ssoToken, coSessionId, null, null, clientIp)) == null) {
                throw new IdMException(1000, "\u5f97\u5230\u7684\u534f\u8bae\u54cd\u5e94\u5305\u4e3anull!");
            }
            return JSONUtil.toJSON(lr);
        }
        String refreshErrMsg = resp.getData(2);
        throw new IdMException(resp.getErrCode(), refreshErrMsg);
    }

    @Override
    public String getAllowedCoApps(String sessionId) throws IdMException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("get coApp[" + this.agentName + "] sessionId[" + sessionId + "]  to get allowed coApps"));
        }
        if (StringHelper.isEmpty(sessionId)) {
            throw new IdMException(1011, "sessionId is empty");
        }
        ResponsePacket resp = null;
        try {
            resp = this.getResponsePacket((byte)106, new String[]{sessionId, this.agentName});
        }
        catch (IOException e) {
            throw new IdMException(1000, e.getMessage());
        }
        if (resp == null) {
            throw new IdMException(1000, "\u54cd\u5e94\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (resp.getErrCode() == 1) {
            String result = resp.getData(0);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("get result[" + result + "] respCode is [" + resp.getErrCode() + "]"));
            }
            return result;
        }
        String errMessage = resp.getData(0);
        throw new IdMException(resp.getErrCode(), errMessage);
    }

    @Override
    public String getCoAppInfo(String sessionId, String appName, int startPos, int maxResult) throws IdMException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("get coApp [" + appName + "] from sessionId [" + sessionId + "]"));
        }
        if (StringHelper.isEmpty(sessionId)) {
            throw new IdMException(1011, "sessionId is empty");
        }
        if (StringHelper.isEmpty(this.agentName)) {
            throw new IdMException(1011, "appName is empty");
        }
        if (StringHelper.isEmpty(appName)) {
            appName = "N/A";
        }
        ResponsePacket resp = null;
        String startPosStr = Integer.toString(startPos);
        String maxResultStr = Integer.toString(maxResult);
        try {
            resp = this.getResponsePacket((byte)107, new String[]{sessionId, this.agentName, appName, startPosStr, maxResultStr});
        }
        catch (IOException e) {
            throw new IdMException(1000, e.getMessage());
        }
        if (resp == null) {
            throw new IdMException(1000, "\u54cd\u5e94\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (resp.getErrCode() == 1) {
            String result = resp.getData(0);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("get result[" + result + "] respCode is [" + resp.getErrCode() + "]"));
            }
            return result;
        }
        String errMessage = resp.getData(0);
        throw new IdMException(resp.getErrCode(), errMessage);
    }

    public String[] getHostIPs() {
        return this.hostIPs;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    @Override
    public boolean addReminder(Map<String, Object> reminderInfos) throws IdMException {
        if (reminderInfos == null || reminderInfos.size() < 0) {
            throw new IdMException(-1, "\u5f85\u529e\u4e8b\u9879\u4fe1\u606f\u4e3a\u7a7a!");
        }
        String infos = StringHelper.Map2String(reminderInfos, "|", "~");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("reminder infos  to json [" + infos + "]"));
        }
        ResponsePacket resp = null;
        try {
            resp = this.getResponsePacket((byte)108, new String[]{this.agentName, infos});
        }
        catch (IOException e) {
            throw new IdMException(1000, e.getMessage());
        }
        if (resp == null) {
            throw new IdMException(1000, "\u54cd\u5e94\u4fe1\u606f\u4e3a\u7a7a!");
        }
        if (resp.getErrCode() == 1) {
            String result = resp.getData(0);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("get result[" + result + "] respCode is [" + resp.getErrCode() + "]"));
            }
            return new Boolean(result);
        }
        String errMessage = resp.getData(0);
        throw new IdMException(resp.getErrCode(), errMessage);
    }

    protected boolean notifyIdsToAddCoApp() {
        ResponsePacket resp;
        boolean result;
        block10: {
            ResponseResult responseResult;
            block9: {
                if (!this.agentFirstStart) {
                    LOG.error((Object)("get agentFirstStart[" + this.agentFirstStart + "] is false, can not notify ids to add coApp and admin user, so return false directly!"));
                    return false;
                }
                result = false;
                resp = null;
                responseResult = this.getResponseResult((byte)101, new String[]{this.agentName, this.coAppType, this.coAppVersion, this.coAppRootUrl, this.notifyUrl}, null, false);
                if (responseResult != null) break block9;
                LOG.error((Object)"fail to notify IDS Server to add coApp and adminUser, get responseResult is null");
                return false;
            }
            resp = responseResult.getResponsePacket();
            if (resp != null) break block10;
            LOG.error((Object)"fail to notify IDS Server to add coApp and adminUser, get response is null");
            return false;
        }
        try {
            if (resp.getErrCode() == 1) {
                String respData = resp.getData(0);
                result = Boolean.parseBoolean(respData);
                LOG.info((Object)("notify ids to add coApp and admin user success, respData: " + respData + ", result:" + result + "by agentName[" + this.agentName + "], coAppType[" + this.coAppType + "], coAppVersion[" + this.coAppVersion + "], notifyUrl[" + this.notifyUrl + "], coAppRootUrl[" + this.coAppRootUrl + "]"));
            } else {
                LOG.error((Object)("notify ids to add coApp and adminuser failed, resp:" + resp));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"notify ids to add coApp and admin user failed!", (Throwable)e);
        }
        if (result) {
            this.closeAgentSynchronizeConfig("agent.first.start");
            LOG.info((Object)("notify ids to add coApp[" + this.agentName + "] and adminUser successfully, so config agent.first.start as false!"));
        }
        if (!result) {
            LOG.error((Object)("fail to notify IDS Server to add coApp and adminUser by agentName[" + this.agentName + "], coAppType[" + this.coAppType + "], coAppVersion[" + this.coAppVersion + "], notifyUrl[" + this.notifyUrl + "], coAppRootUrl[" + this.coAppRootUrl + "]"));
        }
        return result;
    }

    protected boolean shouldNotifyIdsToAddCoApp() {
        if (this.agentFirstStart && this.isPortalApp()) {
            LOG.info((Object)("should notify ids to add coApp by agentFirstStart[" + this.agentFirstStart + "], isPortalApp[" + this.isPortalApp() + "], appType[" + this.coAppType + "]"));
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("should not notify ids to add coApp by agentFirstStart[" + this.agentFirstStart + "], isPortalApp[" + this.isPortalApp() + "], appType[" + this.coAppType + "]"));
        }
        return false;
    }

    private boolean isPortalApp() {
        return "portal".equalsIgnoreCase(this.coAppType) || "portalpub".equalsIgnoreCase(this.coAppType) || "wcm".equalsIgnoreCase(this.coAppType);
    }

    protected boolean notifyIdsToConfigGroupSync() {
        ResponsePacket resp;
        block8: {
            ResponseResult responseResult;
            block7: {
                if (!this.groupSynchronize) {
                    LOG.error((Object)("get userSynchronize[" + this.userSynchronize + "] is false, can not notify ids to config group synchronization, so return false directly!"));
                    return false;
                }
                resp = null;
                try {
                    responseResult = this.getResponseResult((byte)102, new String[]{this.agentName, this.notifyUrl, this.coAppType}, null, false);
                    if (responseResult != null) break block7;
                    LOG.error((Object)"notify ids to config group synchronization fail, responseResult is null!");
                    return false;
                }
                catch (Exception e) {
                    LOG.error((Object)("notify ids to config group synchronization fail, resp:" + resp), (Throwable)e);
                    LOG.error((Object)"notify ids to config group synchronize fail!");
                    return false;
                }
            }
            resp = responseResult.getResponsePacket();
            if (resp != null) break block8;
            LOG.error((Object)"notify ids to config group synchronization fail, resp is null!");
            return false;
        }
        if (resp.getErrCode() == 1) {
            String respData = resp.getData(0);
            boolean respDataBoolean = Boolean.parseBoolean(respData);
            if (respDataBoolean) {
                this.closeAgentSynchronizeConfig("coApp.group.synchronization");
            }
            LOG.info((Object)("notify ids to config group synchronize, respData: " + respData + ", result:" + respDataBoolean));
            return respDataBoolean;
        }
        LOG.error((Object)("notify ids to config group synchronize fail, detailInfo:" + resp));
        return false;
    }

    protected boolean notifyIdsToConfigUserSync() {
        ResponsePacket resp;
        block6: {
            ResponseResult responseResult;
            block5: {
                resp = null;
                try {
                    responseResult = this.getResponseResult((byte)103, new String[]{this.agentName, this.notifyUrl, this.coAppType}, null, false);
                    if (responseResult != null) break block5;
                    LOG.error((Object)"notify ids to config group synchronization fail, responseResult is null!");
                    return false;
                }
                catch (Exception e) {
                    LOG.error((Object)("notify ids to config user synchronize failed by agentName[" + this.agentName + "], notifyUrl[" + this.notifyUrl + "], coAppType[" + this.coAppType + "]"), (Throwable)e);
                    LOG.error((Object)("notify ids to config user synchronize failed by agentName[" + this.agentName + "], notifyUrl[" + this.notifyUrl + "], coAppType[" + this.coAppType + "]"));
                    return false;
                }
            }
            resp = responseResult.getResponsePacket();
            if (resp != null) break block6;
            LOG.error((Object)"notify ids to config group synchronization fail, response is null!");
            return false;
        }
        if (resp.getErrCode() == 1) {
            String respData = resp.getData(0);
            boolean respDataBoolean = Boolean.parseBoolean(respData);
            this.closeAgentSynchronizeConfig("coApp.user.synchronization");
            LOG.info((Object)("notify ids to config user synchronize, respDataBoolean[" + respDataBoolean + "], respData[" + respData + "], agentName[" + this.agentName + "], notifyUrl[" + this.notifyUrl + "], coAppType[" + this.coAppType + "]"));
            return respDataBoolean;
        }
        LOG.error((Object)("notify ids to config user synchronize fail, detailInfo:" + resp));
        return false;
    }

    private void closeAgentSynchronizeConfig(String configKey) {
        ConfigFileModifier fileModifier = new ConfigFileModifier(this.getClass().getResource("/trsids-agent.properties"));
        fileModifier.modifyProperty(configKey, false);
        try {
            fileModifier.saveModifies();
        }
        catch (IOException e) {
            LOG.error((Object)("Save agent properties failed:" + e.getMessage()), (Throwable)e);
        }
        try {
            this.resetRTProps();
        }
        catch (IdMException e) {
            LOG.error((Object)("Reset agent properties failed:" + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public String restoreOriginAccessUrl(HttpServletRequest req) {
        boolean isReverseProxyRequest;
        String requestUrl;
        String originalUrl = RequestUtil.getParameterIndirect(req, "com.trs.app.originUrl");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("get originalUrl[" + originalUrl + "]"));
        }
        if (!StringHelper.isEmpty(originalUrl)) {
            return UrlUtil.decode(originalUrl);
        }
        String qryStr = req.getQueryString();
        String string = requestUrl = StringHelper.isEmpty(qryStr) ? req.getRequestURI() : String.valueOf(req.getRequestURI()) + "?" + qryStr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("get requestUrl[" + requestUrl + "] by requestURI[" + req.getRequestURI() + "], qryStr[" + qryStr + "]"));
        }
        if (isReverseProxyRequest = RequestUtil.isReverseProxyRequest(req, this.getOriginalHostHttpHeader())) {
            requestUrl = RequestUtil.getOriginalUrlWithParam(req, this.getOriginalHostHttpHeader());
            LOG.info((Object)("This is an reverse proxy proxy, get originalURL[" + requestUrl + "] by current requestURL: " + RequestUtil.getFullGetStr(req)));
        }
        requestUrl = StringHelper.substringByFirstOccurance(requestUrl, "", "?");
        if (StringHelper.isEmpty(qryStr)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("queryString [" + qryStr + "] is empty, so return requestUrl [" + requestUrl + "]."));
            }
            return requestUrl;
        }
        String newQryStr = this.rebuildQueryString(qryStr);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("after rebuild queryString by IDS params, queryString [" + newQryStr + "], old [" + qryStr + "], requestUrl [" + requestUrl + "]"));
        }
        return String.valueOf(requestUrl) + "?" + newQryStr;
    }

    private String rebuildQueryString(String queryString) {
        if (StringHelper.isEmpty(queryString)) {
            return queryString;
        }
        String idsAppended1 = "agMode";
        String idsAppended2 = "com.trs.idm.gSessionId";
        Map queryMap = StringHelper.String2Map(queryString, "&", "=");
        HashMap returnMap = new HashMap();
        for (String key : queryMap.keySet()) {
            Object valueObj = queryMap.get(key);
            if (idsAppended1.equals(key) || idsAppended2.equals(key)) continue;
            returnMap.put(key, valueObj);
        }
        return StringHelper.Map2String(returnMap, "&", "=");
    }

    @Override
    public LoginResult loginUser(String ssoSessionId, String coSessionId, String userName, String passwd, String sourceName, String clientIP, FormValues extraValues) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("user login, userName=" + userName + ",sourceName=" + sourceName + ",gSessionId=" + ssoSessionId + ",coSessionId=" + coSessionId + ",clientIP=" + clientIP));
        }
        if (StringHelper.isEmpty(sourceName)) {
            sourceName = "ids_internal";
        }
        if (StringHelper.isEmpty(ssoSessionId)) {
            ssoSessionId = "ssoTokenCreateNew";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("agent can not get ssoToken, so ask idmServer to create new with token[" + ssoSessionId + "]"));
            }
        }
        LoginResult lr = new LoginResult();
        if (StringHelper.isEmpty(userName)) {
            lr.setSuccess(false);
            lr.setFailInfo("\u60a8\u7684\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return lr;
        }
        if (StringHelper.isEmpty(passwd)) {
            lr.setSuccess(false);
            lr.setFailInfo("\u60a8\u7684\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return lr;
        }
        String verifyCode = "";
        if (extraValues != null) {
            verifyCode = extraValues.getParamValue("TRSIDSVerifyCode");
        }
        ResponsePacket resp = null;
        try {
            String nodeKey = AgentBase.extractNodeKeyFromSSOSessionId(ssoSessionId);
            resp = !StringHelper.isEmpty(nodeKey) && this.isSocketCommunicationSessionSticky() ? this.getResponsePacket((byte)4, new String[]{ssoSessionId, this.agentName, coSessionId, userName, passwd, clientIP, sourceName, verifyCode}, nodeKey) : this.getResponsePacket((byte)4, new String[]{ssoSessionId, this.agentName, coSessionId, userName, passwd, clientIP, sourceName, verifyCode});
        }
        catch (Exception e) {
            LOG.error((Object)("login fail!(gId,coId,user,pwd,ip)=" + ssoSessionId + ',' + coSessionId + ',' + userName + ',' + passwd + ',' + clientIP), (Throwable)e);
            lr.setSuccess(false);
            lr.setFailInfo(e.toString());
            return lr;
        }
        return this.buildLoginResult(lr, resp, ssoSessionId, coSessionId, userName, passwd, clientIP);
    }

    @Override
    public LoginResult loginUserForSameDomainSSO(String userName, String password, String sourceName, String coSessionId, String clientIP, FormValues extraValues) {
        LOG.info((Object)("About to login in IDS, CMD=ProtocolConst.CMD_LOGIN_USER_FOR_SAMEDOMAIN_SSO , userName: " + userName + "; sourceName:" + sourceName + "; coSessionId: " + coSessionId + "; clientIP: " + clientIP));
        LoginResult lr = new LoginResult();
        if (StringHelper.isEmpty(userName) || StringHelper.isEmpty(password)) {
            LOG.debug((Object)("userName =" + userName + ", userName or password can not be null"));
            lr.setSuccess(false);
            lr.setFailInfo("\u60a8\u7684\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return lr;
        }
        if (StringHelper.isEmpty(sourceName)) {
            sourceName = "ids_internal";
        }
        String verifyCode = "";
        if (extraValues != null) {
            verifyCode = extraValues.getParamValue("TRSIDSVerifyCode");
        }
        ResponsePacket resp = null;
        try {
            resp = this.getResponsePacket((byte)26, new String[]{this.agentName, userName, password, sourceName, coSessionId, clientIP, verifyCode});
        }
        catch (Exception e) {
            LOG.error((Object)("login for same domain sso fail!appName[" + this.agentName + "],userName[" + userName + "],sourceName[" + sourceName + "],coSessionId[" + coSessionId + "],clientIP[" + clientIP + "]"));
            lr.setSuccess(false);
            lr.setFailInfo(e.toString());
            LOG.info((Object)("LoginResult is: " + lr));
            return lr;
        }
        return this.buildLoginResult(lr, resp, null, coSessionId, userName, password, clientIP);
    }

    @Override
    public String getRequestServerName(HttpServletRequest request) {
        if (request == null) {
            LOG.info((Object)"request is null ,return empty string.");
            return "";
        }
        if (!RequestUtil.isReverseProxyRequest(request, this.originalHostHttpHeader)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not reverseProxyRequest, return default [" + request.getServerName() + "], originalHostHttpHeader [" + this.originalHostHttpHeader + "]."));
            }
            return request.getServerName();
        }
        String serverNameByProxy = RequestUtil.getOriginalHost(request, this.originalHostHttpHeader);
        if (StringHelper.isEmpty(serverNameByProxy)) {
            serverNameByProxy = request.getServerName();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("return [" + serverNameByProxy + "] as serverName ."));
        }
        return serverNameByProxy;
    }
}

