/*
 * Decompiled with CFR 0.152.
 */
package com.trs.client;

import com.trs.client.ClassInfo;
import com.trs.client.Date;
import com.trs.client.SectionInfo;
import com.trs.client.TRSConnection;
import com.trs.client.TRSException;
import com.trs.client.TRSField;
import com.trs.client.TRSHitPoint;
import com.trs.client.TRSJNIV61;
import com.trs.client.TRSRecord;
import com.trs.client.TRSUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ResourceBundle;
import java.util.Vector;

public class TRSResultSet {
    private TRSConnection m_conn = null;
    private volatile long m_hSelect = 0L;
    private boolean m_bWordSelect = false;
    private int m_iResultID = 0;
    private int m_iTotalSteps = 0;
    private int m_iSectionNum = 0;
    private int m_iStatisticNum = 0;
    private int m_iClassNum = 0;
    private long m_lRecordNum = 0L;
    private long m_lValidNum = 0L;
    private long m_lHitPointsNum = 0L;
    private int m_iReadSize = 16;
    private boolean m_bPartReport = false;
    private boolean m_bEstimateEnd = false;
    private String m_sCurWhereExpr = null;
    private String m_sLastWhereExpr = null;
    private boolean m_bInvalidColumnIgnore = false;
    private String m_sInvalidColumnValue = "";
    private boolean m_bRecordInfoReady = false;
    private int m_iCurSectionNo = -1;
    private long m_lCurRecordNo = -1L;
    private ResultSectionColumnInfo[] m_aCurColumnInfo = null;
    private Vector m_vCurRecordValues = new Vector();
    private Vector m_vCachedColumnInfo = new Vector();
    private ResultRecordInfo m_oCurRecordInfo = new ResultRecordInfo();
    private ResultIndexWordInfo m_oCurIndexWordInfo = new ResultIndexWordInfo();
    private static ResourceBundle m_oBundle = ResourceBundle.getBundle("com.trs.client.resouce.format");

    private String getRecordValues() throws TRSException {
        String _strRecordValues = null;
        String _strColumnValue = null;
        int i = 0;
        while (i < this.m_vCurRecordValues.size()) {
            _strColumnValue = (String)this.m_vCurRecordValues.elementAt(i);
            if (_strColumnValue != null) {
                _strRecordValues = _strRecordValues == null ? _strColumnValue : String.valueOf(_strRecordValues) + this.m_conn.m_cDivider + _strColumnValue;
            }
            ++i;
        }
        if (_strRecordValues == null) {
            throw TRSException.New(500017, "");
        }
        return _strRecordValues;
    }

    private void updateSectionInfo(int iSectionNo) throws TRSException {
        this.m_aCurColumnInfo = (ResultSectionColumnInfo[])this.m_vCachedColumnInfo.elementAt(iSectionNo);
        if (this.m_aCurColumnInfo != null) {
            return;
        }
        ResultSectionInfo _oSectInfo = new ResultSectionInfo();
        TRSJNIV61.TRS_Result_GetSectionInfo(this.m_hSelect, iSectionNo, _oSectInfo);
        if (_oSectInfo.iColumnNum == 0 || _oSectInfo.strColumns == null || _oSectInfo.strColumns.length() == 0) {
            throw TRSException.New(500024, "");
        }
        this.m_iCurSectionNo = iSectionNo;
        this.m_aCurColumnInfo = new ResultSectionColumnInfo[_oSectInfo.iColumnNum];
        this.m_vCachedColumnInfo.setElementAt(this.m_aCurColumnInfo, iSectionNo);
        String[] _saColumnNameSplits = TRSUtils.split(_oSectInfo.strColumns, ";");
        if (_saColumnNameSplits == null || _saColumnNameSplits.length != _oSectInfo.iColumnNum) {
            throw TRSException.New(500025, "");
        }
        int i = 0;
        while (i < _oSectInfo.iColumnNum) {
            this.m_aCurColumnInfo[i] = new ResultSectionColumnInfo();
            this.m_aCurColumnInfo[i].strName = _saColumnNameSplits[i];
            int _iPos = this.m_aCurColumnInfo[i].strName.indexOf(44);
            if (_iPos != -1) {
                this.m_aCurColumnInfo[i].strAlias = this.m_aCurColumnInfo[i].strName.substring(_iPos + 1);
                this.m_aCurColumnInfo[i].strName = this.m_aCurColumnInfo[i].strName.substring(0, _iPos);
            }
            ++i;
        }
    }

    private boolean updateRecordInfo() throws TRSException {
        if (this.m_hSelect == 0L) {
            throw TRSException.New(500018, "");
        }
        if (this.m_lCurRecordNo == -1L) {
            throw TRSException.New(500019, String.valueOf(this.m_lCurRecordNo));
        }
        if (this.m_bRecordInfoReady) {
            return true;
        }
        int _iResult = 0;
        int _iOldSection = this.m_oCurRecordInfo.iSectionNo;
        if (this.m_bWordSelect) {
            _iResult = TRSJNIV61.TRS_Result_GetIndexWordInfo(this.m_hSelect, this.m_lCurRecordNo, this.m_oCurIndexWordInfo);
        } else {
            _iResult = TRSJNIV61.TRS_Result_GetRecordInfo(this.m_hSelect, this.m_lCurRecordNo, this.m_oCurRecordInfo.iSectionNo, this.m_oCurRecordInfo);
            this.m_vCurRecordValues.setSize(this.m_oCurRecordInfo.iColumnNum);
            if (this.m_bPartReport) {
                if (this.m_oCurRecordInfo.bEstimateEnd) {
                    this.m_bEstimateEnd = true;
                }
                if (this.m_oCurRecordInfo.lEstimateNew != 0L) {
                    this.m_lRecordNum = this.m_oCurRecordInfo.lEstimateNew;
                }
                if (this.m_oCurRecordInfo.lEstimateValid != 0L) {
                    this.m_lValidNum = this.m_oCurRecordInfo.lEstimateValid;
                }
                if (_iResult == -18500) {
                    return false;
                }
            }
        }
        if (_iResult < 0) {
            throw this.m_conn.newTRSException();
        }
        if (_iOldSection != this.m_oCurRecordInfo.iSectionNo) {
            this.updateSectionInfo(this.m_oCurRecordInfo.iSectionNo);
        }
        this.m_bRecordInfoReady = true;
        return true;
    }

    private boolean isValidColumnNo(int iColNo) throws TRSException {
        if (iColNo >= 0 && iColNo < this.m_oCurRecordInfo.iColumnNum) {
            return true;
        }
        if (!this.m_bInvalidColumnIgnore) {
            throw TRSException.New(500021, String.valueOf(iColNo));
        }
        return false;
    }

    long getHandle() {
        return this.m_hSelect;
    }

    void close_internal() {
        if (this.m_hSelect == 0L) {
            return;
        }
        TRSJNIV61.TRS_Result_Close(this.m_hSelect);
        this.m_hSelect = 0L;
        this.m_bWordSelect = false;
        this.m_lRecordNum = 0L;
        this.m_lValidNum = 0L;
        this.m_lHitPointsNum = 0L;
        this.m_iClassNum = 0;
        this.m_iSectionNum = 0;
        this.m_iStatisticNum = 0;
        this.m_lCurRecordNo = -1L;
        this.m_iCurSectionNo = -1;
        this.m_aCurColumnInfo = null;
        this.m_bRecordInfoReady = false;
        this.m_vCachedColumnInfo.clear();
        this.m_vCurRecordValues.clear();
        this.m_oCurIndexWordInfo.reset();
        this.m_oCurRecordInfo.reset();
        this.m_sLastWhereExpr = this.m_sCurWhereExpr;
        this.m_sCurWhereExpr = null;
    }

    public TRSResultSet() {
    }

    public TRSResultSet(TRSConnection conn) throws TRSException {
        if (conn == null) {
            throw TRSException.New(500002, "");
        }
        this.m_conn = conn;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public void executeSelect(String strSources, String strWhere, String strSortMethod, boolean bContinue) throws TRSException {
        this.executeSelect(strSources, strWhere, strSortMethod, "", null, 0, 115, bContinue);
    }

    public void executeSelect(String strSources, String strWhere, boolean bContinue) throws TRSException {
        this.executeSelect(strSources, strWhere, "RELEVANCE", "", null, 0, 115, bContinue);
    }

    public void executeSelect(String strSources, String strWhere, String strSortMethod, String strStat, String strDefautCols, int iOption, int iHitPointType, boolean bContinue) throws TRSException {
        String _strLastWhere;
        String string = strSources = strSources != null ? strSources.trim() : "";
        if (this.m_conn == null) {
            throw TRSException.New(500002, "");
        }
        this.close();
        String _strCurWhere = strWhere != null ? strWhere.trim() : "";
        String string2 = _strLastWhere = this.m_sLastWhereExpr != null ? this.m_sLastWhereExpr.trim() : "";
        if (bContinue && _strLastWhere.length() != 0) {
            if (_strCurWhere.length() == 0) {
                _strCurWhere = _strLastWhere;
            } else {
                _strLastWhere = "(" + _strLastWhere + ")";
                _strCurWhere = "(" + _strCurWhere + ")";
                _strCurWhere = String.valueOf(_strLastWhere) + " and " + _strCurWhere;
            }
        }
        this.m_hSelect = TRSJNIV61.TRS_ExecuteSelectRecord(this.m_conn.getHandle(), strSources, _strCurWhere, strSortMethod, strStat, strDefautCols, iOption, iHitPointType, this);
        if (this.m_hSelect == 0L) {
            throw this.m_conn.newTRSException();
        }
        this.m_sCurWhereExpr = _strCurWhere;
        this.m_conn.addOpenedResultSet(this);
        this.m_vCachedColumnInfo.setSize(this.m_iSectionNum);
    }

    public void executeSelectWord(String strName, String strOwner, String strExpr) throws TRSException {
        this.close();
        this.m_hSelect = TRSJNIV61.TRS_ExecuteSelectWordEx(this.m_conn.getHandle(), strName, strOwner, strExpr, "", 0, this);
        if (this.m_hSelect == 0L) {
            throw this.m_conn.newTRSException();
        }
        this.m_iSectionNum = 1;
        this.m_sCurWhereExpr = strExpr;
        this.m_conn.addOpenedResultSet(this);
        this.m_vCachedColumnInfo.setSize(this.m_iSectionNum);
    }

    public void executeSelectWord(String strName, String strOwner, String strExpr, String strSortMethod, int iPruneLimit) throws TRSException {
        this.close();
        this.m_hSelect = TRSJNIV61.TRS_ExecuteSelectWordEx(this.m_conn.getHandle(), strName, strOwner, strExpr, strSortMethod, iPruneLimit, this);
        if (this.m_hSelect == 0L) {
            throw this.m_conn.newTRSException();
        }
        this.m_iSectionNum = 1;
        this.m_sCurWhereExpr = strExpr;
        this.m_conn.addOpenedResultSet(this);
        this.m_vCachedColumnInfo.setSize(this.m_iSectionNum);
    }

    public void clearBuffer(int[] iRecords) throws TRSException {
        int _iResult;
        if (this.m_hSelect == 0L) {
            return;
        }
        long[] _laRecords = null;
        if (iRecords != null && iRecords.length != 0) {
            _laRecords = new long[iRecords.length];
            int i = 0;
            while (i < iRecords.length) {
                _laRecords[i] = iRecords[i];
                ++i;
            }
        }
        if ((_iResult = TRSJNIV61.TRS_Result_ClearBuffer(this.m_hSelect, _laRecords)) < 0) {
            throw this.m_conn.newTRSException();
        }
    }

    public void close() {
        this.close_internal();
        if (this.m_conn != null) {
            this.m_conn.removeOpenedResultSet(this);
        }
    }

    public int sortResult(String strSortMethod, boolean bMixEnable) throws TRSException {
        if (this.m_hSelect == 0L) {
            return 0;
        }
        int _iResult = TRSJNIV61.TRS_Result_SortResult(this.m_hSelect, strSortMethod, bMixEnable, this);
        if (_iResult < 0) {
            throw this.m_conn.newTRSException();
        }
        this.m_iClassNum = 0;
        return _iResult;
    }

    public int lockupResult(int[] iaRecords) throws TRSException {
        return 0;
    }

    public void setReadOptions(String strSummarySet, String strDetailSet, String strMultiSep, int iHitType, int iURLToFile) throws TRSException {
        if (this.m_hSelect == 0L) {
            return;
        }
        int _iResult = TRSJNIV61.TRS_Result_SetReadOptions(this.m_hSelect, strSummarySet, strDetailSet, strMultiSep, iHitType, iURLToFile);
        if (_iResult < 0) {
            throw this.m_conn.newTRSException();
        }
    }

    public void setErrorMode(int iErrMode) throws TRSException {
        this.m_bInvalidColumnIgnore = iErrMode == 1;
        int _ret = TRSJNIV61.TRS_SetResultOption(this.getHandle(), "IGNOREMISCOL", this.m_bInvalidColumnIgnore ? "TRUE" : "FALSE");
        if (_ret < 0) {
            throw this.m_conn.newTRSException();
        }
    }

    public void setErrorMode(int iErrMode, String sErrValue) throws TRSException {
        this.setErrorMode(iErrMode);
        this.m_sInvalidColumnValue = sErrValue;
    }

    public void setReadOptions(int iHitType, String strSummarySet, String strMultiSep) throws TRSException {
        this.setReadOptions(strSummarySet, null, strMultiSep, iHitType, -1);
    }

    public void setBufferSize(int iBufferSize, int iReadSize) throws TRSException {
        int _iResult;
        if (this.m_hSelect == 0L) {
            return;
        }
        if (this.m_bPartReport && !this.m_bEstimateEnd) {
            ++iBufferSize;
            ++iReadSize;
        }
        if ((_iResult = TRSJNIV61.TRS_Result_SetBufferSize(this.m_hSelect, iBufferSize, iReadSize, -1, true)) < 0) {
            throw this.m_conn.newTRSException();
        }
        if (iReadSize > 0) {
            this.m_iReadSize = iReadSize;
        }
    }

    public void setConnection(TRSConnection conn) throws NullPointerException {
        if (conn == null) {
            throw new NullPointerException();
        }
        this.m_conn = conn;
    }

    public void setCutSize(int iNewCutSize, boolean bClear) throws TRSException {
        if (this.m_hSelect == 0L) {
            return;
        }
        int _iResult = TRSJNIV61.TRS_Result_SetBufferSize(this.m_hSelect, -1, -1, iNewCutSize, bClear);
        if (_iResult < 0) {
            throw this.m_conn.newTRSException();
        }
    }

    public boolean isClosed() {
        return this.m_hSelect == 0L;
    }

    public boolean isNull(int iColNo) throws TRSException {
        this.updateRecordInfo();
        if (!this.isValidColumnNo(iColNo)) {
            return false;
        }
        int _iMultiCount = TRSJNIV61.TRS_Result_GetMultiCount(this.m_hSelect, this.m_lCurRecordNo, iColNo);
        return _iMultiCount == 0;
    }

    public boolean isNull(String strColName) throws TRSException {
        return this.isNull(this.findColumn(strColName));
    }

    public int getPage() {
        return (int)this.m_lCurRecordNo / this.m_iReadSize + 1;
    }

    public int getPageCount() {
        return (int)((this.m_lValidNum + (long)this.m_iReadSize - 1L) / (long)this.m_iReadSize);
    }

    public int getPageSize() {
        return this.m_iReadSize;
    }

    public void setPageSize(int iPageSize) {
        if (iPageSize <= 0) {
            return;
        }
        this.m_iReadSize = iPageSize;
    }

    public void setPage(int iPage) throws TRSException {
        this.moveTo(0, (iPage - 1) * this.m_iReadSize);
    }

    public void delete() throws TRSException {
        this.updateRecordInfo();
        TRSRecord _oRecInfo = this.getRecord();
        String _strBaseName = _oRecInfo.strBaseName;
        String _strBaseOwner = _oRecInfo.strBaseOwner;
        String _strRecordWhere = "DOCID=" + _oRecInfo.lRecordID;
        int _iResult = this.m_conn.executeDelete(_strBaseName, _strBaseOwner, _strRecordWhere, true);
        if (_iResult < 0) {
            throw this.m_conn.newTRSException();
        }
        TRSJNIV61.TRS_Result_ClearBuffer(this.m_hSelect, null);
    }

    public int delete(String strWhere, boolean bFastEnable) throws TRSException {
        if (strWhere == null || strWhere.length() == 0) {
            throw TRSException.New(500026, "");
        }
        this.updateRecordInfo();
        TRSRecord _oRecInfo = this.getRecord();
        String _strBaseName = _oRecInfo.strBaseName;
        String _strBaseOwner = _oRecInfo.strBaseOwner;
        int _iResult = this.m_conn.executeDelete(_strBaseName, _strBaseOwner, strWhere, bFastEnable);
        if (_iResult < 0) {
            throw this.m_conn.newTRSException();
        }
        TRSJNIV61.TRS_Result_ClearBuffer(this.m_hSelect, null);
        return _iResult;
    }

    public boolean update() throws TRSException {
        return this.update(null) > 0;
    }

    public int update(String strWhere) throws TRSException {
        int _iResult;
        this.updateRecordInfo();
        TRSRecord _oRecInfo = this.getRecord();
        String _strBaseName = _oRecInfo.strBaseName;
        String _strBaseOwner = _oRecInfo.strBaseOwner;
        String _strRecordValues = this.getRecordValues();
        if (strWhere == null || strWhere.length() == 0) {
            strWhere = "DOCID=" + _oRecInfo.lRecordID;
        }
        if ((_iResult = this.m_conn.executeUpdate(_strBaseName, _strBaseOwner, _strRecordValues, strWhere)) < 0) {
            throw this.m_conn.newTRSException();
        }
        this.m_vCurRecordValues.clear();
        this.m_vCurRecordValues.setSize(this.m_oCurRecordInfo.iColumnNum);
        TRSJNIV61.TRS_Result_ClearBuffer(this.m_hSelect, null);
        return _iResult;
    }

    public void setString(int iColumnNo, String strNewValue) throws TRSException {
        this.updateRecordInfo();
        if (!this.isValidColumnNo(iColumnNo)) {
            return;
        }
        String _strColumName = this.getColumnName(iColumnNo);
        String _strRecordValues = String.valueOf(_strColumName) + "=" + strNewValue;
        this.m_vCurRecordValues.setSize(this.m_oCurRecordInfo.iColumnNum);
        this.m_vCurRecordValues.setElementAt(_strRecordValues, iColumnNo);
    }

    public void setString(String strColumnName, String strNewValue) throws TRSException {
        this.setString(this.findColumn(strColumnName), strNewValue);
    }

    public int saveResult(String strFileName, String strColumns, String strRecords, int iFormat, int iSourceMode) throws TRSException {
        if (this.m_hSelect == 0L) {
            throw TRSException.New(500018, String.valueOf(this.m_hSelect));
        }
        int _iResult = TRSJNIV61.TRS_Result_SaveResult(this.m_hSelect, strFileName, strColumns, strRecords, iFormat, iSourceMode);
        if (_iResult < 0) {
            throw this.m_conn.newTRSException();
        }
        return _iResult;
    }

    public int insert() throws TRSException {
        this.updateRecordInfo();
        String _strBaseName = this.m_oCurRecordInfo.strName;
        String _strBaseOwner = this.m_oCurRecordInfo.strOwner;
        String _strRecordValues = this.getRecordValues();
        int _iResult = this.m_conn.executeInsert(_strBaseName, _strBaseOwner, _strRecordValues);
        if (_iResult <= 0) {
            throw this.m_conn.newTRSException();
        }
        this.m_vCurRecordValues.clear();
        this.m_vCurRecordValues.setSize(this.m_oCurRecordInfo.iColumnNum);
        return _iResult;
    }

    public boolean moveFirst() throws TRSException {
        return this.moveTo(0, 0L);
    }

    public boolean moveLast() throws TRSException {
        return this.moveTo(0, this.m_lValidNum - 1L);
    }

    public boolean moveNext() throws TRSException {
        return this.moveTo(0, this.m_lCurRecordNo + 1L);
    }

    public boolean movePrevious() throws TRSException {
        return this.moveTo(0, this.m_lCurRecordNo - 1L);
    }

    public boolean moveTo(int iMoveFlag, long lNewNo) throws TRSException {
        switch (iMoveFlag) {
            case 0: {
                break;
            }
            case 1: {
                lNewNo = this.m_lCurRecordNo + lNewNo;
                break;
            }
            default: {
                return false;
            }
        }
        if (lNewNo < 0L) {
            return false;
        }
        this.m_vCurRecordValues.clear();
        this.m_bRecordInfoReady = false;
        if (this.m_bPartReport && !this.m_bEstimateEnd) {
            this.m_lCurRecordNo = lNewNo;
            if (!this.updateRecordInfo()) {
                return false;
            }
        }
        if (lNewNo >= this.m_lValidNum) {
            return false;
        }
        if (lNewNo == this.m_lCurRecordNo) {
            return true;
        }
        this.m_lCurRecordNo = lNewNo;
        return true;
    }

    public long getPosition() {
        return this.m_lCurRecordNo;
    }

    public int classResult(String strColumn, String strValues, int iPruneStore, String strSortMethod, boolean bMixEnable, boolean bAscentSort) throws TRSException {
        return this.classResult(strColumn, strValues, iPruneStore, strSortMethod, bMixEnable, bAscentSort ? 1 : 0);
    }

    public int classResult(String strColumn, String strValues, int iPruneStore, String strSortMethod, boolean bMixEnable, int iOption) throws TRSException {
        if (this.m_hSelect == 0L) {
            throw TRSException.New(500018, String.valueOf(this.m_hSelect));
        }
        this.m_iClassNum = TRSJNIV61.TRS_Result_ClassResult(this.m_hSelect, strColumn, strValues, iPruneStore, strSortMethod, bMixEnable, iOption, this);
        if (this.m_iClassNum < 0) {
            throw this.m_conn.newTRSException();
        }
        return this.m_iClassNum;
    }

    public int getClassCount() {
        return this.m_iClassNum;
    }

    public ClassInfo getClassInfo(int iClassNo) throws TRSException {
        if (this.m_hSelect == 0L) {
            throw TRSException.New(500018, String.valueOf(this.m_hSelect));
        }
        ClassInfo _oClassInfo = new ClassInfo();
        int _iResult = TRSJNIV61.TRS_Result_GetClassInfo(this.m_hSelect, iClassNo, _oClassInfo);
        if (_iResult < 0) {
            throw this.m_conn.newTRSException();
        }
        return _oClassInfo;
    }

    public TRSHitPoint[] getHitPoints(int iColNo) throws TRSException {
        this.updateRecordInfo();
        if (!this.isValidColumnNo(iColNo)) {
            return null;
        }
        int _iColumnType = this.getColumnType(iColNo);
        if (_iColumnType != 0 && _iColumnType != 67 && _iColumnType != 68) {
            return null;
        }
        String[] _strHitPointProperties = TRSJNIV61.TRS_Result_GetHitPoints(this.m_hSelect, this.m_lCurRecordNo, iColNo);
        if (_strHitPointProperties == null) {
            throw this.m_conn.newTRSException();
        }
        if (_strHitPointProperties.length <= 0) {
            return null;
        }
        int _iHitPointCount = _strHitPointProperties.length;
        TRSHitPoint[] _oaHitPoints = new TRSHitPoint[_iHitPointCount];
        int i = 0;
        while (i < _iHitPointCount) {
            _oaHitPoints[i] = new TRSHitPoint();
            String[] _saPropertySplits = TRSUtils.split(_strHitPointProperties[i], "\u0001");
            _oaHitPoints[i].iSegment = TRSUtils.getIntPropertValue(_saPropertySplits, "SEGMENT");
            _oaHitPoints[i].iSentence = TRSUtils.getIntPropertValue(_saPropertySplits, "SENTENCE");
            _oaHitPoints[i].iPosition = TRSUtils.getIntPropertValue(_saPropertySplits, "POSITION");
            _oaHitPoints[i].iLength = TRSUtils.getIntPropertValue(_saPropertySplits, "LENGTH");
            _oaHitPoints[i].iBeginRow = TRSUtils.getIntPropertValue(_saPropertySplits, "BEGINROW");
            _oaHitPoints[i].iBeginCol = TRSUtils.getIntPropertValue(_saPropertySplits, "BEGINCOL");
            _oaHitPoints[i].iEndRow = TRSUtils.getIntPropertValue(_saPropertySplits, "ENDROW");
            _oaHitPoints[i].iEndCol = TRSUtils.getIntPropertValue(_saPropertySplits, "ENDCOL");
            _oaHitPoints[i].iStart = TRSUtils.getIntPropertValue(_saPropertySplits, "START");
            _oaHitPoints[i].iLength = TRSUtils.getIntPropertValue(_saPropertySplits, "LENGTH");
            _oaHitPoints[i].iCStart = TRSUtils.getIntPropertValue(_saPropertySplits, "CSTART");
            _oaHitPoints[i].iCLength = TRSUtils.getIntPropertValue(_saPropertySplits, "CLENGTH");
            _oaHitPoints[i].iBlank = TRSUtils.getIntPropertValue(_saPropertySplits, "BLANK");
            ++i;
        }
        return _oaHitPoints;
    }

    public TRSHitPoint[] getHitPoints(String strColumnName) throws TRSException {
        return this.getHitPoints(this.findColumn(strColumnName));
    }

    public String getSummaryStringWithCutsize(int iColNo, int iCutsize, String strHitColorValue) throws TRSException {
        return this.getStringWithCutsize(iColNo, iCutsize, strHitColorValue);
    }

    public String getSummaryStringWithCutsize(String strColumnName, int iCutsize, String strHitColorValue) throws TRSException {
        return this.getSummaryStringWithCutsize(this.findColumn(strColumnName), iCutsize, strHitColorValue);
    }

    public String getString(int iColNo, String strHitColor) throws TRSException {
        this.updateRecordInfo();
        if (!this.isValidColumnNo(iColNo)) {
            return this.m_sInvalidColumnValue;
        }
        String _strValue = TRSJNIV61.TRS_Result_GetDetailWithHitPoints(this.m_hSelect, this.m_lCurRecordNo, iColNo, 0, strHitColor);
        if (_strValue == null) {
            throw this.m_conn.newTRSException();
        }
        return _strValue;
    }

    public String getString(String strColumnName, String strHitColor) throws TRSException {
        return this.getString(this.findColumn(strColumnName), strHitColor);
    }

    public String getString(String strSrcValue, int iColNo, String strHitColor) throws TRSException {
        if (strSrcValue == null || strSrcValue.length() == 0) {
            return null;
        }
        this.updateRecordInfo();
        if (!this.isValidColumnNo(iColNo)) {
            return this.m_sInvalidColumnValue;
        }
        String _strValue = TRSJNIV61.TRS_Result_AddHitPoints(this.m_hSelect, this.m_lCurRecordNo, iColNo, strSrcValue, strHitColor);
        if (_strValue == null) {
            throw this.m_conn.newTRSException();
        }
        return _strValue;
    }

    public String getString(String strSRC, String strColumnName, String strHitColor) throws TRSException {
        return this.getString(strSRC, this.findColumn(strColumnName), strHitColor);
    }

    public String getStringWithCutsize(int iColNo, int iCutsize, String strHitColor) throws TRSException {
        this.updateRecordInfo();
        if (!this.isValidColumnNo(iColNo)) {
            return this.m_sInvalidColumnValue;
        }
        String _strValue = TRSJNIV61.TRS_Result_GetDetailWithHitPoints(this.m_hSelect, this.m_lCurRecordNo, iColNo, iCutsize, strHitColor);
        if (_strValue == null) {
            throw this.m_conn.newTRSException();
        }
        return _strValue;
    }

    public String getStringWithCutsize(String strColumnName, int iCutsize, String strHitColor) throws TRSException {
        return this.getStringWithCutsize(this.findColumn(strColumnName), iCutsize, strHitColor);
    }

    public int getResultID() {
        return this.m_iResultID;
    }

    public long getTotalHitPoint() {
        return this.m_lHitPointsNum;
    }

    public int getTotalSteps() {
        return this.m_iTotalSteps;
    }

    public String getWhereExpression() {
        return this.m_sCurWhereExpr;
    }

    public int getSectionNum() {
        return this.m_iSectionNum;
    }

    public int getSectionCount() {
        return this.m_iSectionNum;
    }

    public double getStatistic(int iSectionNo, int iStatisNo) throws TRSException {
        if (this.m_hSelect == 0L) {
            throw TRSException.New(500018, String.valueOf(this.m_hSelect));
        }
        double _dResult = TRSJNIV61.TRS_Result_GetStatisticInfo(this.m_hSelect, iSectionNo, iStatisNo);
        if (_dResult < 0.0) {
            throw this.m_conn.newTRSException();
        }
        return _dResult;
    }

    public int getStatisticNum() {
        return this.m_iStatisticNum;
    }

    public int getStatisticCount() {
        return this.m_iStatisticNum;
    }

    public long getRecordCount() {
        return this.getValidCount();
    }

    public long getRecordCount(int iOption) {
        if (iOption != 0) {
            return this.m_lRecordNum;
        }
        return this.getValidCount();
    }

    public long getValidCount() {
        return this.m_lValidNum;
    }

    public int findColumn(String strColumnName) throws TRSException {
        if (strColumnName == null || strColumnName.equals("")) {
            throw TRSException.New(500020, "");
        }
        this.updateRecordInfo();
        int i = 0;
        while (i < this.m_aCurColumnInfo.length) {
            if (this.m_aCurColumnInfo[i] != null) {
                String _sColumnName = this.m_aCurColumnInfo[i].strName;
                if (_sColumnName.equalsIgnoreCase(strColumnName)) {
                    return i;
                }
                String _sColumnAlias = this.m_aCurColumnInfo[i].strAlias;
                if (_sColumnAlias != null) {
                    if (!_sColumnAlias.endsWith(",")) {
                        _sColumnAlias = String.valueOf(_sColumnAlias) + ",";
                    }
                    while (_sColumnAlias != null) {
                        int _iPos = _sColumnAlias.indexOf(44);
                        if (_iPos == -1) break;
                        String _sColumnTemp = _sColumnAlias.substring(0, _iPos);
                        _sColumnAlias = _sColumnAlias.substring(_iPos + 1);
                        if (!_sColumnTemp.equalsIgnoreCase(strColumnName)) continue;
                        return i;
                    }
                }
            }
            ++i;
        }
        if (!this.m_bInvalidColumnIgnore) {
            throw TRSException.New(500021, strColumnName);
        }
        return -1024;
    }

    public int getColumnCount() throws TRSException {
        this.updateRecordInfo();
        return this.m_aCurColumnInfo.length;
    }

    public String getColumnName(int iColNo) throws TRSException {
        this.updateRecordInfo();
        if (!this.isValidColumnNo(iColNo)) {
            return "";
        }
        return this.m_aCurColumnInfo[iColNo].strName;
    }

    public int getColumnType(int iColNo) throws TRSException {
        this.updateRecordInfo();
        if (!this.isValidColumnNo(iColNo)) {
            return 0;
        }
        if (this.m_aCurColumnInfo[iColNo].iColumnType != 0) {
            return this.m_aCurColumnInfo[iColNo].iColumnType;
        }
        int _iResult = TRSJNIV61.TRS_Result_GetColumnInfo(this.m_hSelect, this.m_lCurRecordNo, iColNo, -1, null);
        if (_iResult < 0) {
            throw this.m_conn.newTRSException();
        }
        this.m_aCurColumnInfo[iColNo].iColumnType = _iResult;
        return _iResult;
    }

    public int getColumnType(String strColName) throws TRSException {
        return this.getColumnType(this.findColumn(strColName));
    }

    public TRSRecord getRecord() throws TRSException {
        this.updateRecordInfo();
        ResultRecordInfo _oRecInfo = this.m_oCurRecordInfo;
        TRSRecord _oRecord = new TRSRecord();
        _oRecord.lRecordID = _oRecInfo.lRecordID;
        _oRecord.lViewID = _oRecInfo.lViewID;
        _oRecord.lBaseID = _oRecInfo.lBaseID;
        _oRecord.iSection = _oRecInfo.iSectionNo;
        _oRecord.strName = _oRecInfo.strName;
        _oRecord.strOwner = _oRecInfo.strOwner;
        _oRecord.iColumnNum = _oRecInfo.iColumnNum;
        _oRecord.bCryptDenied = _oRecInfo.bIsCrypted;
        _oRecord.bDeleted = _oRecInfo.bIsDeleted;
        _oRecord.lfRelevance = _oRecInfo.lfRelevance;
        String _strBaseName = TRSJNIV61.TRS_Result_GetRecordBase(this.m_hSelect, this.m_lCurRecordNo);
        if (_strBaseName != null) {
            _oRecord.strBaseName = _strBaseName;
            _oRecord.strBaseOwner = "";
            int _iPos = _strBaseName.indexOf(46);
            if (_iPos >= 0) {
                _oRecord.strBaseName = _strBaseName.substring(_iPos + 1);
                _oRecord.strBaseOwner = _strBaseName.substring(0, _iPos);
            }
        }
        return _oRecord;
    }

    public long getRecordID() throws TRSException {
        this.updateRecordInfo();
        return this.m_oCurRecordInfo.lRecordID;
    }

    public long getRecordSect() throws TRSException {
        this.updateRecordInfo();
        return this.m_iCurSectionNo;
    }

    public int setReadOption(String sPropName, String sPropValue, int iPropValue) throws TRSException {
        int iResult;
        if (sPropValue == null || sPropValue.length() == 0) {
            sPropValue = String.valueOf(iPropValue);
        }
        if ((iResult = TRSJNIV61.TRS_SetResultOption(this.m_hSelect, sPropName, sPropValue)) < 0) {
            throw this.m_conn.newTRSException();
        }
        return iResult;
    }

    public double getRelevance() throws TRSException {
        this.updateRecordInfo();
        return this.m_oCurRecordInfo.lfRelevance;
    }

    public int getBinaryObjectCount(int iColNo) throws TRSException {
        this.updateRecordInfo();
        if (!this.isValidColumnNo(iColNo)) {
            return 0;
        }
        int _iColumnType = this.getColumnType(iColNo);
        int _iMultiCount = TRSJNIV61.TRS_Result_GetMultiCount(this.m_hSelect, this.m_lCurRecordNo, iColNo);
        switch (_iColumnType) {
            case 68: {
                return _iMultiCount == 2 ? 1 : 0;
            }
            case 69: {
                return _iMultiCount;
            }
        }
        return 0;
    }

    public int getBinaryObjectCount(String strColumnName) throws TRSException {
        return this.getBinaryObjectCount(this.findColumn(strColumnName));
    }

    public int getBinaryObjectRealCount(int iColNo) throws TRSException {
        this.updateRecordInfo();
        if (!this.isValidColumnNo(iColNo)) {
            return 0;
        }
        int _iColumnType = this.getColumnType(iColNo);
        int _iMultiCount = TRSJNIV61.TRS_Result_GetMultiCount(this.m_hSelect, this.m_lCurRecordNo, iColNo);
        switch (_iColumnType) {
            case 68: {
                String _sContentType = this.getContentType(iColNo, _iMultiCount - 1);
                return _sContentType != null && !_sContentType.equals("text/plain") ? 1 : 0;
            }
            case 69: {
                return _iMultiCount;
            }
        }
        return 0;
    }

    public int getBinaryObjectRealCount(String strColumnName) throws TRSException {
        return this.getBinaryObjectRealCount(this.findColumn(strColumnName));
    }

    public InputStream getBinaryStream(int iColNo, int iMultiIndex) throws TRSException {
        File file;
        String _strFileName;
        this.updateRecordInfo();
        if (!this.isValidColumnNo(iColNo)) {
            return null;
        }
        int _iColType = this.getColumnType(iColNo);
        if (_iColType == 0) {
            return null;
        }
        if ((_iColType == 68 || _iColType == 69) && (_strFileName = this.getFile(iColNo, iMultiIndex)) != null && _strFileName.length() != 0 && (file = new File(_strFileName)).exists()) {
            try {
                return new FileInputStream(_strFileName);
            }
            catch (FileNotFoundException e) {
                throw new TRSException(e.getMessage());
            }
        }
        byte[] _baResult = this.getBytes(iColNo, iMultiIndex);
        if (_baResult != null) {
            return new ByteArrayInputStream(_baResult);
        }
        return null;
    }

    public InputStream getBinaryStream(String strColumnName, int iMultiIndex) throws TRSException {
        return this.getBinaryStream(this.findColumn(strColumnName), iMultiIndex);
    }

    public byte[] getBytes(int iColNo, int iMutiIndex) throws TRSException {
        this.updateRecordInfo();
        if (!this.isValidColumnNo(iColNo)) {
            return null;
        }
        byte[] _baResult = TRSJNIV61.TRS_Result_GetBytes(this.m_hSelect, this.m_lCurRecordNo, iColNo, iMutiIndex);
        if (_baResult == null) {
            throw this.m_conn.newTRSException();
        }
        if (_baResult.length == 0) {
            return null;
        }
        return _baResult;
    }

    public byte[] getBytes(String strColumnName, int iMutiIndex) throws TRSException {
        return this.getBytes(this.findColumn(strColumnName), iMutiIndex);
    }

    public int getColumnMultiValue(int iColNo) throws TRSException {
        this.updateRecordInfo();
        if (!this.isValidColumnNo(iColNo)) {
            return 0;
        }
        int _iResult = TRSJNIV61.TRS_Result_GetMultiCount(this.m_hSelect, this.m_lCurRecordNo, iColNo);
        if (_iResult < 0) {
            throw this.m_conn.newTRSException();
        }
        return _iResult;
    }

    public int getColumnMultiValue(String strColumnName) throws TRSException {
        return this.getColumnMultiValue(this.findColumn(strColumnName));
    }

    public String getContentFormat(int iColNo, int iMultiIndex) throws TRSException {
        this.updateRecordInfo();
        if (!this.isValidColumnNo(iColNo)) {
            return "";
        }
        int _iColType = this.getColumnType(iColNo);
        if (_iColType == 0) {
            return "BIT";
        }
        if (_iColType != 68 && _iColType != 69) {
            return "TEXT";
        }
        String _sContentFormat = TRSJNIV61.TRS_Result_GetContentFormat(this.m_hSelect, this.m_lCurRecordNo, iColNo, iMultiIndex);
        if (_sContentFormat == null) {
            throw this.m_conn.newTRSException();
        }
        return _sContentFormat;
    }

    public String getContentFormat(String strColumnName, int iMultiIndex) throws TRSException {
        return this.getContentFormat(this.findColumn(strColumnName), iMultiIndex);
    }

    public String getContentType(int iColNo, int iMultiIndex) throws TRSException {
        this.updateRecordInfo();
        if (!this.isValidColumnNo(iColNo)) {
            return "";
        }
        int _iColType = this.getColumnType(iColNo);
        if (_iColType == 0) {
            return "application/octet_stream";
        }
        if (_iColType != 68 && _iColType != 69) {
            return "text/plain";
        }
        String _sFileExt = null;
        String _sContentType = null;
        String _sFileName = TRSJNIV61.TRS_Result_GetFileName(this.m_hSelect, this.m_lCurRecordNo, iColNo, iMultiIndex);
        if (_sFileName == null) {
            throw this.m_conn.newTRSException();
        }
        int _iPos = _sFileName.lastIndexOf(46);
        if (_iPos >= 0) {
            _sFileExt = _sFileName.substring(_iPos + 1);
        }
        if (_sFileExt != null && _sFileExt.length() > 0) {
            try {
                _sContentType = m_oBundle.getString(_sFileExt.toLowerCase());
                return _sContentType;
            }
            catch (Exception ignore) {
                _sContentType = "application/octet-stream";
            }
        }
        if ((_sContentType = TRSJNIV61.TRS_Result_GetContentType(this.m_hSelect, this.m_lCurRecordNo, iColNo, iMultiIndex)) == null) {
            throw this.m_conn.newTRSException();
        }
        return _sContentType;
    }

    public String getContentType(String strColumnName, int iMultiIndex) throws TRSException {
        return this.getContentType(this.findColumn(strColumnName), iMultiIndex);
    }

    public TRSField getField(int iColNo, int iMultiIndex) throws TRSException {
        this.updateRecordInfo();
        if (!this.isValidColumnNo(iColNo)) {
            return null;
        }
        TRSField _oField = new TRSField();
        int _iResult = TRSJNIV61.TRS_Result_GetColumnInfo(this.m_hSelect, this.m_lCurRecordNo, iColNo, iMultiIndex, _oField);
        if (_iResult < 0) {
            throw this.m_conn.newTRSException();
        }
        return _oField;
    }

    public TRSField getField(String strColumnName, int iMultiIndex) throws TRSException {
        return this.getField(this.findColumn(strColumnName), iMultiIndex);
    }

    public String getIndexWord() throws TRSException {
        this.updateRecordInfo();
        return this.m_oCurIndexWordInfo.strWord;
    }

    public int getIndexWordFrequence() throws TRSException {
        this.updateRecordInfo();
        return (int)this.m_oCurIndexWordInfo.lFrequence;
    }

    public int getIndexWordHitNum() throws TRSException {
        this.updateRecordInfo();
        return (int)this.m_oCurIndexWordInfo.lHitNum;
    }

    public int getIndexWordIndentNum() throws TRSException {
        this.updateRecordInfo();
        return (int)this.m_oCurIndexWordInfo.lIndentNum;
    }

    public Date getDate(int iColNo) throws TRSException {
        int _iColType = this.getColumnType(iColNo);
        if (_iColType == 0) {
            return null;
        }
        if (_iColType != 64) {
            throw TRSException.New(500022, "DATE," + String.valueOf(_iColType));
        }
        String _strValue = this.getString(iColNo);
        if (_strValue == null || _strValue.length() == 0) {
            return null;
        }
        return new Date(_strValue);
    }

    public Date getDate(String strColumnName) throws TRSException {
        return this.getDate(this.findColumn(strColumnName));
    }

    public String getFile(int iColNo, int iMultiValue) throws TRSException {
        this.updateRecordInfo();
        if (!this.isValidColumnNo(iColNo)) {
            return "";
        }
        int _iColType = this.getColumnType(iColNo);
        if (_iColType == 0) {
            return null;
        }
        if (_iColType != 68 && _iColType != 69) {
            throw TRSException.New(500022, "DOCUMENT or BIT");
        }
        String _strValue = TRSJNIV61.TRS_Result_GetFileName(this.m_hSelect, this.m_lCurRecordNo, iColNo, iMultiValue);
        if (_strValue == null) {
            throw this.m_conn.newTRSException();
        }
        return _strValue;
    }

    public String getFile(String strColumnName, int iMultiValue) throws TRSException {
        return this.getFile(this.findColumn(strColumnName), iMultiValue);
    }

    public float getFloat(int iColNo) throws TRSException {
        String _strValue;
        block4: {
            _strValue = this.getString(iColNo);
            if (!this.m_bInvalidColumnIgnore || _strValue != null && _strValue.length() != 0) break block4;
            return 0.0f;
        }
        try {
            return Float.parseFloat(_strValue);
        }
        catch (NumberFormatException e) {
            throw new TRSException(e.getMessage());
        }
        catch (TRSException e) {
            throw e;
        }
    }

    public float getFloat(String strColumnName) throws TRSException {
        return this.getFloat(this.findColumn(strColumnName));
    }

    public int getInt(int iColNo) throws TRSException {
        String _strValue;
        block6: {
            try {
                _strValue = this.getString(iColNo);
                if (!this.m_bInvalidColumnIgnore || _strValue != null && _strValue.length() != 0) break block6;
                return 0;
            }
            catch (NumberFormatException e) {
                try {
                    return (int)this.getFloat(iColNo);
                }
                catch (NumberFormatException ex) {
                    throw new TRSException(ex.toString());
                }
            }
        }
        if (_strValue.length() == 0) {
            throw TRSException.New(500023, "");
        }
        return Integer.parseInt(_strValue);
    }

    public int getInt(String strColumnName) throws TRSException {
        return this.getInt(this.findColumn(strColumnName));
    }

    public SectionInfo getSectionInfo(int iSectionNo) throws TRSException {
        if (this.m_hSelect == 0L) {
            throw TRSException.New(500018, "");
        }
        ResultSectionInfo _oSection = new ResultSectionInfo();
        int _iResult = TRSJNIV61.TRS_Result_GetSectionInfo(this.m_hSelect, iSectionNo, _oSection);
        if (_iResult < 0) {
            throw this.m_conn.newTRSException();
        }
        SectionInfo _oRetSection = new SectionInfo();
        _oRetSection.strName = _oSection.strName;
        _oRetSection.strOwner = _oSection.strOwner;
        _oRetSection.iType = _oSection.iObjectType;
        _oRetSection.iColumnNum = _oSection.iColumnNum;
        _oRetSection.strColumns = _oSection.strColumns;
        _oRetSection.iRecordNum = (int)_oSection.lRecordNum;
        _oRetSection.iHitPointNum = (int)_oSection.lHitPointNum;
        return _oRetSection;
    }

    public String getString(int iColNo) throws TRSException {
        this.updateRecordInfo();
        if (!this.isValidColumnNo(iColNo)) {
            return this.m_sInvalidColumnValue;
        }
        String _strValue = TRSJNIV61.TRS_Result_GetDetail(this.m_hSelect, this.m_lCurRecordNo, iColNo, 0);
        if (_strValue == null) {
            throw this.m_conn.newTRSException();
        }
        return _strValue;
    }

    public String getString(String strColumnName) throws TRSException {
        return this.getString(this.findColumn(strColumnName));
    }

    public Date getSummaryDate(int iColNo) throws TRSException {
        String _strValue;
        block6: {
            int _iColType;
            block5: {
                _iColType = this.getColumnType(iColNo);
                if (_iColType != 0) break block5;
                return null;
            }
            if (_iColType != 64) {
                throw TRSException.New(500022, "DATE," + String.valueOf(_iColType));
            }
            _strValue = this.getSummaryString(iColNo);
            if (_strValue != null && _strValue.length() != 0) break block6;
            return null;
        }
        return new Date(_strValue);
    }

    public Date getSummaryDate(String strColumnName) throws TRSException {
        return this.getSummaryDate(this.findColumn(strColumnName));
    }

    public float getSummaryFloat(int iColNo) throws TRSException {
        try {
            String _strValue = this.getSummaryString(iColNo);
            return Float.parseFloat(_strValue);
        }
        catch (NumberFormatException e) {
            throw new TRSException(e.getMessage());
        }
        catch (TRSException e) {
            throw e;
        }
    }

    public float getSummaryFloat(String strColumnName) throws TRSException {
        return this.getSummaryFloat(this.findColumn(strColumnName));
    }

    public int getSummaryInt(int iColNo) throws TRSException {
        try {
            String _strValue = this.getSummaryString(iColNo);
            if (_strValue.length() == 0) {
                throw TRSException.New(500023, "");
            }
            return Integer.parseInt(_strValue);
        }
        catch (NumberFormatException e) {
            try {
                return (int)this.getSummaryFloat(iColNo);
            }
            catch (NumberFormatException ex) {
                throw new TRSException(ex.toString());
            }
        }
    }

    public int getSummaryInt(String strColumnName) throws TRSException {
        return this.getSummaryInt(this.findColumn(strColumnName));
    }

    public String getSummaryString(int iColNo) throws TRSException {
        return this.getString(iColNo);
    }

    public String getSummaryString(String strColumnName) throws TRSException {
        return this.getSummaryString(this.findColumn(strColumnName));
    }

    public long GetPhysicsID(long RecordNo) throws TRSException {
        if (this.moveTo(0, RecordNo)) {
            return this.getRecordID();
        }
        return -1L;
    }

    public String GetBaseOwner() throws TRSException {
        TRSRecord _rec = this.getRecord();
        if (_rec != null) {
            return _rec.strBaseOwner;
        }
        return "";
    }

    public String GetRecOwner() throws TRSException {
        return this.GetBaseOwner();
    }

    public String GetBaseName() throws TRSException {
        TRSRecord _rec = this.getRecord();
        if (_rec != null) {
            return _rec.strBaseName;
        }
        return "";
    }

    public String GetRecName() throws TRSException {
        return this.GetBaseName();
    }

    public void executePick(String strName, String strOwner, String strWhereExpr, String strSortMethod, int StartRank, int LimitNum) throws TRSException {
        strWhereExpr = strWhereExpr != null ? strWhereExpr.trim() : "";
        long hSelect = TRSJNIV61.TRS_ExecutePickRecord(this.m_conn.getHandle(), strName, strOwner, strWhereExpr, strSortMethod, StartRank, LimitNum, this);
        if (hSelect == 0L) {
            throw this.m_conn.newTRSException();
        }
        this.m_sCurWhereExpr = strWhereExpr;
        this.m_conn.addOpenedResultSet(this);
        this.m_vCachedColumnInfo.setSize(this.m_iSectionNum);
    }

    public static final class ResultIndexWordInfo {
        public String strWord = null;
        public long lHitNum = 0L;
        public long lFrequence = 0L;
        public long lIndentNum = 0L;

        ResultIndexWordInfo() {
            this.reset();
        }

        void reset() {
            this.lHitNum = 0L;
            this.lFrequence = 0L;
            this.lIndentNum = 0L;
        }
    }

    public static final class ResultRecordInfo {
        public String strName = null;
        public String strOwner = null;
        public int iSectionNo = -1;
        public int iColumnNum = 0;
        public long lRecordID = 0L;
        public long lViewID = 0L;
        public long lBaseID = 0L;
        public double lfRelevance = 0.0;
        public boolean bIsDeleted = false;
        public boolean bIsCrypted = false;
        public long lEstimateNew = 0L;
        public long lEstimateValid = 0L;
        public boolean bEstimateEnd = false;

        ResultRecordInfo() {
            this.reset();
        }

        void reset() {
            this.iSectionNo = -1;
            this.iColumnNum = 0;
            this.lRecordID = 0L;
        }
    }

    public static final class ResultSectionColumnInfo {
        public String strName = null;
        public String strAlias = null;
        public int iColumnType = 0;

        ResultSectionColumnInfo() {
            this.reset();
        }

        void reset() {
            this.iColumnType = 0;
        }
    }

    public static final class ResultSectionInfo {
        public String strName = null;
        public String strOwner = null;
        public String strColumns = null;
        public int iColumnNum = 0;
        public int iObjectType = 0;
        public long lRecordNum = 0L;
        public long lHitPointNum = 0L;

        ResultSectionInfo() {
            this.reset();
        }

        void reset() {
            this.iColumnNum = 0;
            this.iObjectType = 0;
            this.lRecordNum = 0L;
            this.lHitPointNum = 0L;
        }
    }
}

