/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.impl.transport;

import com.trs.infra.cluster.ClusterMessage;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.impl.ClusterSenderBase;
import com.trs.infra.cluster.io.TransportTracer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import org.apache.log4j.Logger;

public class SenderByMulticast
extends ClusterSenderBase {
    private static final Logger s_logger;
    private long sendBytes;
    private int sendBytesHalf;
    private MulticastSocket sendSocket;
    private DatagramPacket dataPacket;
    private TransportTracer transportTracer;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.impl.transport.SenderByMulticast");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public SenderByMulticast() {
        super("SenderByMulticast");
    }

    public Member getRemoteMember() {
        return null;
    }

    protected void sendMessage(ClusterMessage message) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Be to send message:" + message));
        }
        int retry = 0;
        while (retry < this.getMaxRetry()) {
            try {
                byte[] buffer = this.dataPacket.getData();
                int dataLength = message.flush(buffer, 0);
                DatagramPacket packet = this.dataPacket;
                packet.setAddress(null);
                packet.setPort(0);
                packet.setLength(dataLength);
                this.sendSocket.send(packet);
                this.incSendBytes(dataLength);
                TransportTracer tracer = this.transportTracer;
                if (tracer == null) break;
                tracer.trace(buffer, 0, dataLength);
                break;
            }
            catch (Exception e) {
                s_logger.error((Object)("Send  '" + message + "' failed, retry=" + retry), (Throwable)e);
                ++retry;
            }
        }
    }

    protected long getSendBytes() {
        return this.sendBytes + (long)this.sendBytesHalf;
    }

    private final void incSendBytes(int value) {
        int temp = this.sendBytesHalf + value;
        if (temp > 0) {
            this.sendBytesHalf = temp;
            return;
        }
        this.sendBytesHalf = 0;
        this.sendBytes = this.sendBytes + (long)this.sendBytesHalf + (long)value;
    }

    protected void startup() {
        try {
            new RuntimeException("who call me").printStackTrace();
            throw new RuntimeException("who call me");
        }
        catch (IOException e) {
            String info = "SenderByMulticast startup failed";
            s_logger.fatal((Object)info, (Throwable)e);
            throw new RuntimeException(info, e);
        }
    }

    protected void cleanup() {
        try {
            this.sendSocket.close();
        }
        catch (Exception e) {
            s_logger.error((Object)"SenderByMulticast cleanup failed", (Throwable)e);
        }
        this.dataPacket = null;
        this.sendSocket = null;
    }
}

