/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.pool;

import com.eprobiti.trs.TRSConnection;
import com.trs.cis4.pool.ConnectionManager;
import com.trs.cis4.pool.TrsDbConfig;
import com.trs.cis4.util.ExceptionUtil;

public class TrsDbConnectionPool {
    private static String m_sDriver;
    private static ConnectionManager connectionManager;

    static {
        connectionManager = null;
        m_sDriver = "com.eprobiti.trs.TRSConnection";
        try {
            Class.forName(m_sDriver);
        }
        catch (ClassNotFoundException e) {
            System.out.println(e);
        }
        connectionManager = new ConnectionManager();
        Thread t = new Thread((Runnable)connectionManager, "DBManager");
        t.setDaemon(true);
        t.start();
    }

    public static void main(String[] args) {
        try {
            TRSConnection conn = TrsDbConnectionPool.dbConnect();
            System.out.println(conn.isValid());
            TrsDbConnectionPool.dbDisConnect(conn);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public static TRSConnection dbConnect() throws ExceptionUtil {
        TRSConnection conn = connectionManager.dbConnect();
        if (conn == null) {
            TrsDbConfig bean = new TrsDbConfig();
            throw new ExceptionUtil(0, "\u8fde\u63a5TRSServer\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01", "HOST:" + bean.getServerhost() + " PORT:" + bean.getServerport() + " INSTANCE:" + bean.getInstance());
        }
        return conn;
    }

    public static int dbDisConnect(TRSConnection conn) {
        return connectionManager.dbDisConnect(conn);
    }

    public static int forceDisConnect() {
        return connectionManager.forceDisConnect();
    }

    public ConnectionManager getConnectionManager() {
        return connectionManager;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        TrsDbConnectionPool.connectionManager = connectionManager;
    }
}

