/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.discover.util;

import com.trs.infra.discover.DiscoveryFactory;
import com.trs.infra.discover.IDiscovery;
import javax.servlet.ServletContext;

public final class DiscoveryServletHelper {
    public static final String IncludeLibrary = "DiscoveryIncludeLibrary";
    public static final String ExcludeLibrary = "DiscoveryExcludeLibrary";
    public static final String IncludeDirectory = "DiscoveryIncludeDirectory";
    public static final String ExcludeDirectory = "DiscoveryExcludeDirectory";
    private static IDiscovery s_oGlobalDiscovery = null;

    public static IDiscovery getDiscovery() {
        return s_oGlobalDiscovery;
    }

    public static void setDiscovery(IDiscovery ds) {
        s_oGlobalDiscovery = ds;
    }

    static final synchronized void initDiscovery(ServletContext sc) {
        if (s_oGlobalDiscovery != null) {
            return;
        }
        IDiscovery ds = DiscoveryFactory.create(sc);
        if (ds != null) {
            s_oGlobalDiscovery = ds;
        }
    }

    static final synchronized void destroyDiscovery() {
        if (s_oGlobalDiscovery == null) {
            return;
        }
        s_oGlobalDiscovery.cleanup();
        s_oGlobalDiscovery = null;
    }

    private DiscoveryServletHelper() {
    }
}

