/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.discover;

import com.trs.infra.discover.IDiscovery;
import com.trs.infra.discover.impl.FactoryByFiles;
import com.trs.infra.discover.impl.FactoryByServlet;
import java.io.File;
import javax.servlet.ServletContext;

public abstract class DiscoveryFactory {
    public static final IDiscovery create(File[] libs) {
        return DiscoveryFactory.create(libs, null);
    }

    public static final IDiscovery create(File[] libs, File[] dirs) {
        return DiscoveryFactory.getInstance(libs, dirs).build();
    }

    public static final IDiscovery create(ServletContext sc) {
        return DiscoveryFactory.getInstance(sc).build();
    }

    public static final DiscoveryFactory getInstance(File[] libs, File[] dirs) {
        return new FactoryByFiles(libs, dirs);
    }

    public static final DiscoveryFactory getInstance(ServletContext sc) {
        return new FactoryByServlet(sc);
    }

    protected DiscoveryFactory() {
    }

    public abstract IDiscovery build();
}

