/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding.soapenc;

import java.io.IOException;
import java.io.Writer;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QNameSerializer
implements Serializer,
Deserializer {
    static /* synthetic */ Class class$org$apache$soap$util$xml$QName;

    public void marshall(String inScopeEncStyle, Class javaType, Object src, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
        sink.write('<' + context.toString());
        QName qName = (QName)src;
        String prefix = nsStack.getPrefixFromURI(qName.getNamespaceURI(), sink);
        QName elementType = xjmr.queryElementType(javaType, "http://schemas.xmlsoap.org/soap/encoding/");
        String schemaInstanceURI = xjmr instanceof SOAPMappingRegistry ? ((SOAPMappingRegistry)xjmr).getSchemaURI() + "-instance" : "http://www.w3.org/2001/XMLSchema-instance";
        String xsiNSPrefix = nsStack.getPrefixFromURI(schemaInstanceURI, sink);
        String elementTypeNSPrefix = nsStack.getPrefixFromURI(elementType.getNamespaceURI(), sink);
        sink.write(' ' + xsiNSPrefix + ':' + "type" + "=\"" + elementTypeNSPrefix + ':' + elementType.getLocalPart() + '\"');
        sink.write('>' + prefix + ':' + qName.getLocalPart());
        sink.write("</" + context.toString() + '>');
    }

    public Bean unmarshall(String inScopeEncStyle, QName elementType, Node src, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException {
        Element root = (Element)src;
        String value = DOMUtils.getChildCharacterData(root);
        int idx = value.indexOf(":");
        if (idx <= 0) {
            throw new IllegalArgumentException("No NamespaceURI while deserializing QName");
        }
        String prefix = value.substring(0, idx);
        String uri = DOMUtils.getNamespaceURIFromPrefix(src, prefix);
        QName qName = new QName(uri, value.substring(idx + 1));
        return new Bean(class$org$apache$soap$util$xml$QName == null ? (class$org$apache$soap$util$xml$QName = QNameSerializer.class$("org.apache.soap.util.xml.QName")) : class$org$apache$soap$util$xml$QName, qName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

