/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.event.TitleChangeEvent;
import org.jfree.chart.title.Title;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.Size2D;
import org.jfree.ui.Spacer;
import org.jfree.ui.VerticalAlignment;

public class ImageTitle
extends Title {
    private Image image;
    private int height;
    private int width;

    public ImageTitle(Image image) {
        this(image, image.getHeight(null), image.getWidth(null), Title.DEFAULT_POSITION, Title.DEFAULT_HORIZONTAL_ALIGNMENT, Title.DEFAULT_VERTICAL_ALIGNMENT, Title.DEFAULT_SPACER);
    }

    public ImageTitle(Image image, RectangleEdge position, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        this(image, image.getHeight(null), image.getWidth(null), position, horizontalAlignment, verticalAlignment, Title.DEFAULT_SPACER);
    }

    public ImageTitle(Image image, int height, int width, RectangleEdge position, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, Spacer spacer) {
        super(position, horizontalAlignment, verticalAlignment, spacer);
        if (image == null) {
            throw new NullPointerException("ImageTitle(..): Image argument is null.");
        }
        this.image = image;
        this.height = height;
        this.width = width;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        if (image == null) {
            throw new NullPointerException("ImageTitle.setImage (..): Image must not be null.");
        }
        this.image = image;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public void draw(Graphics2D g2, Rectangle2D titleArea) {
        RectangleEdge position = this.getPosition();
        if (position == RectangleEdge.TOP || position == RectangleEdge.BOTTOM) {
            this.drawHorizontal(g2, titleArea);
        } else if (position == RectangleEdge.LEFT || position == RectangleEdge.RIGHT) {
            this.drawVertical(g2, titleArea);
        } else {
            throw new RuntimeException("ImageTitle.draw(...) - invalid title position.");
        }
    }

    public float getPreferredWidth(Graphics2D g2, float height) {
        Spacer spacer = this.getSpacer();
        float result = (float)spacer.getAdjustedWidth((double)this.width);
        return result;
    }

    public float getPreferredHeight(Graphics2D g2, float width) {
        Spacer spacer = this.getSpacer();
        float result = (float)spacer.getAdjustedHeight((double)this.height);
        return result;
    }

    protected Size2D drawHorizontal(Graphics2D g2, Rectangle2D chartArea) {
        double startY = 0.0;
        double topSpace = 0.0;
        double bottomSpace = 0.0;
        double leftSpace = 0.0;
        double rightSpace = 0.0;
        Spacer spacer = this.getSpacer();
        topSpace = spacer.getTopSpace((double)this.height);
        bottomSpace = spacer.getBottomSpace((double)this.height);
        leftSpace = spacer.getLeftSpace((double)this.width);
        rightSpace = spacer.getRightSpace((double)this.width);
        startY = this.getPosition() == RectangleEdge.TOP ? chartArea.getY() + topSpace : chartArea.getY() + chartArea.getHeight() - bottomSpace - (double)this.height;
        HorizontalAlignment horizontalAlignment = this.getHorizontalAlignment();
        double startX = 0.0;
        if (horizontalAlignment == HorizontalAlignment.CENTER) {
            startX = chartArea.getX() + leftSpace + chartArea.getWidth() / 2.0 - (double)(this.width / 2);
        } else if (horizontalAlignment == HorizontalAlignment.LEFT) {
            startX = chartArea.getX() + leftSpace;
        } else if (horizontalAlignment == HorizontalAlignment.RIGHT) {
            startX = chartArea.getX() + chartArea.getWidth() - rightSpace - (double)this.width;
        }
        g2.drawImage(this.image, (int)startX, (int)startY, this.width, this.height, null);
        return new Size2D(chartArea.getWidth() + leftSpace + rightSpace, (double)this.height + topSpace + bottomSpace);
    }

    protected Size2D drawVertical(Graphics2D g2, Rectangle2D chartArea) {
        double startX = 0.0;
        double topSpace = 0.0;
        double bottomSpace = 0.0;
        double leftSpace = 0.0;
        double rightSpace = 0.0;
        Spacer spacer = this.getSpacer();
        if (spacer != null) {
            topSpace = spacer.getTopSpace((double)this.height);
            bottomSpace = spacer.getBottomSpace((double)this.height);
            leftSpace = spacer.getLeftSpace((double)this.width);
            rightSpace = spacer.getRightSpace((double)this.width);
        }
        startX = this.getPosition() == RectangleEdge.LEFT ? chartArea.getX() + leftSpace : chartArea.getMaxX() - rightSpace - (double)this.width;
        VerticalAlignment alignment = this.getVerticalAlignment();
        double startY = 0.0;
        if (alignment == VerticalAlignment.CENTER) {
            startY = chartArea.getMinY() + topSpace + chartArea.getHeight() / 2.0 - (double)(this.height / 2);
        } else if (alignment == VerticalAlignment.TOP) {
            startY = chartArea.getMinY() + topSpace;
        } else if (alignment == VerticalAlignment.BOTTOM) {
            startY = chartArea.getMaxY() - bottomSpace - (double)this.height;
        }
        g2.drawImage(this.image, (int)startX, (int)startY, this.width, this.height, null);
        return new Size2D(chartArea.getWidth() + leftSpace + rightSpace, (double)this.height + topSpace + bottomSpace);
    }
}

