/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.event;

import com.aliyun.oss.event.ProgressEvent;
import com.aliyun.oss.event.ProgressEventType;
import com.aliyun.oss.event.ProgressListener;

public class ProgressPublisher {
    public static void publishProgress(ProgressListener listener, ProgressEventType eventType) {
        if (listener == ProgressListener.NOOP || listener == null || eventType == null) {
            return;
        }
        listener.progressChanged(new ProgressEvent(eventType));
    }

    public static void publishRequestContentLength(ProgressListener listener, long bytes) {
        ProgressPublisher.publishByteCountEvent(listener, ProgressEventType.REQUEST_CONTENT_LENGTH_EVENT, bytes);
    }

    public static void publishRequestBytesTransferred(ProgressListener listener, long bytes) {
        ProgressPublisher.publishByteCountEvent(listener, ProgressEventType.REQUEST_BYTE_TRANSFER_EVENT, bytes);
    }

    public static void publishResponseContentLength(ProgressListener listener, long bytes) {
        ProgressPublisher.publishByteCountEvent(listener, ProgressEventType.RESPONSE_CONTENT_LENGTH_EVENT, bytes);
    }

    public static void publishResponseBytesTransferred(ProgressListener listener, long bytes) {
        ProgressPublisher.publishByteCountEvent(listener, ProgressEventType.RESPONSE_BYTE_TRANSFER_EVENT, bytes);
    }

    private static void publishByteCountEvent(ProgressListener listener, ProgressEventType eventType, long bytes) {
        if (listener == ProgressListener.NOOP || listener == null || bytes <= 0L) {
            return;
        }
        listener.progressChanged(new ProgressEvent(eventType, bytes));
    }
}

