/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent;

import com.trs.idm.exception.IdMException;
import com.trs.idm.interact.TransferUtil;
import com.trs.idm.interact.agent.AgentVersion;
import com.trs.idm.interact.agent.IClientTransfer;
import com.trs.idm.interact.agent.IDSSocketFactory;
import com.trs.idm.interact.protocol.PacketUtil;
import com.trs.idm.interact.protocol.ProtocolPacket;
import com.trs.idm.interact.protocol.RequestPacket;
import com.trs.idm.interact.protocol.ResponsePacket;
import com.trs.idm.util.CloseUtil;
import com.trs.idm.util.EnvUtil;
import com.trs.idm.util.PropertyUtil;
import com.trs.idm.util.SocketUtil;
import com.trs.idm.util.StringHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ClientTransferV2
implements IClientTransfer {
    private static final Logger LOG = Logger.getLogger(ClientTransferV2.class);
    private static final String DUMMY_SSL = "dummySSL";
    private static final String PLAIN_SOCKET = "plain";
    private static final String UNKNOW_INFO = "unknow";
    public static final int MAX_RESPONSE = Short.MAX_VALUE;
    private static final int EOF_CHAR = 25;
    private String agentName;
    private String host;
    private int port;
    private Properties props;
    private Socket socket;
    protected volatile boolean isStarting = false;
    protected volatile boolean isStopping = false;
    private String serverInfo;
    private String nodeKeyOfIDSServer;
    private String idmServerCharset;

    public ClientTransferV2(String host, int port, String agentName, String serverInfo, Properties props) {
        this.host = host;
        this.port = port;
        this.agentName = agentName;
        this.serverInfo = StringHelper.isEmpty(serverInfo) ? UNKNOW_INFO : serverInfo;
        this.props = props;
    }

    public void recycle() {
        CloseUtil.closeSocket(this.socket);
        this.socket = null;
        LOG.debug((Object)("recycle socket[ " + this.socket + " ]"));
    }

    public void initCoAppConfig() throws IOException {
        String logoutUri = PropertyUtil.getTrimString(this.props, "logout.uri", "/logout.jsp");
        String allowGuest = PropertyUtil.getTrimString(this.props, "allow.anonymous", "n");
        String loginActionUri = PropertyUtil.getTrimString(this.props, "loginAction.uri", "/login");
        String loginUserNameField = PropertyUtil.getTrimString(this.props, "sso.selfLoginPage.userName.field", "userName");
        String loginPasswordField = PropertyUtil.getTrimString(this.props, "sso.selfLoginPage.password.field", "password");
        String ifUserNotExistOnIDSUseCoAppLoigc = PropertyUtil.getTrimString(this.props, "sso.ifUserNotExistOnIDS.useLocalLoginLogic", "false");
        String actorClass = PropertyUtil.getTrimString(this.props, "coAppActor.className", "unkown");
        String afterLoginOkGoToUrl = PropertyUtil.getTrimString(this.props, "afterLoginOk.gotoUrl", "notConfigure");
        String afterLoginFailGoToUrl = PropertyUtil.getTrimString(this.props, "afterLoginFail.gotoUrl", "notConfigure");
        String ssoUrl = PropertyUtil.getTrimString(this.props, "ssoUrl", "notConfigure");
        String switchOn = PropertyUtil.getTrimString(this.props, "sso.on", "true");
        RequestPacket req = null;
        Object[] initParameters = new String[]{this.agentName, logoutUri, allowGuest, this.serverInfo, EnvUtil.getJavaEnvInfo(), AgentVersion.getReleaseInfo(), AgentVersion.getSourceLocation(), System.getProperty("os.name", "unkown"), System.getProperty("user.name", "unkown"), System.getProperty("user.dir", "unkown"), loginActionUri, loginUserNameField, loginPasswordField, ifUserNotExistOnIDSUseCoAppLoigc, actorClass, afterLoginOkGoToUrl, afterLoginFailGoToUrl, ssoUrl, switchOn};
        try {
            req = new RequestPacket(81, (String[])initParameters, null);
            LOG.info((Object)("send init parameters to IDS, parameters are: " + StringHelper.toString(initParameters, true, ";")));
        }
        catch (IdMException e) {
            LOG.error((Object)"this exception should NOT happen!", (Throwable)e);
            throw new RuntimeException(e);
        }
        ResponsePacket resp = null;
        try {
            byte[] bytesResp = this.getResponse(req.toBytes());
            ProtocolPacket packet = PacketUtil.parseFromBytes(bytesResp);
            if (!(packet instanceof ResponsePacket)) {
                LOG.error((Object)("received: [" + packet + "] not a ResponsePacket! IDS Server: [" + this.host + ":" + this.port + "]"));
                throw new IOException("Received is not a IDS ResponsePacket!");
            }
            resp = (ResponsePacket)packet;
            if (resp.getErrCode() == -116) {
                throw new IOException("the coAppName:[" + this.agentName + "] has not passed audit on IDS Server: [" + this.host + ":" + this.port + "] by errCode[" + resp.getErrCode() + "]");
            }
            if (resp.getErrCode() != 1) {
                throw new IOException("the coAppName:[" + this.agentName + "] not exist on IDS Server: [" + this.host + ":" + this.port + "] by errCode[" + resp.getErrCode() + "]");
            }
        }
        catch (IOException e) {
            this.recycle();
            throw e;
        }
        this.nodeKeyOfIDSServer = resp.getData(0);
        this.idmServerCharset = resp.getData(1);
        LOG.info((Object)(String.valueOf(this.agentName) + " connected IDS, localSocketAddr=" + this.socket.getLocalSocketAddress() + ", idsSocketAddr=" + this.host + ":" + this.port + ", nodeKeyOfIDSServer=" + this.nodeKeyOfIDSServer + ", idmServerCharset=" + this.idmServerCharset));
    }

    public void init() throws IOException {
        if (this.isStarting || this.isStopping) {
            return;
        }
        this.isStarting = true;
        this.recycle();
        try {
            this.socket = this.createSocket(this.host, this.port);
            LOG.debug((Object)("create socket by host[" + this.host + "], port[" + this.port + "]"));
        }
        catch (IOException e) {
            LOG.error((Object)("fail to connect IDS Server: [" + this.host + ":" + this.port + "]"), (Throwable)e);
            this.recycle();
            this.isStarting = false;
            throw e;
        }
        int soTimeout = PropertyUtil.getPropertyAsInt(this.props, "soTimeout", 150000);
        if (soTimeout < 15000 || soTimeout > 300000) {
            soTimeout = 150000;
        }
        SocketUtil.setTimeout(this.socket, soTimeout);
        SocketUtil.setTcpNoDelay(this.socket, true);
        LOG.info((Object)SocketUtil.getSocketDetail(this.socket));
        this.isStarting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getResponse(byte[] request) throws IOException {
        if (!this.isSocketAlive()) {
            throw new IOException("socket not alive: " + this);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("send req=" + StringHelper.toString(request)));
        }
        byte[] resp = null;
        try {
            ClientTransferV2 clientTransferV2 = this;
            synchronized (clientTransferV2) {
                this.sendRequestBytes(request, this.socket.getOutputStream());
                resp = this.readResponseBytes(this.socket.getInputStream());
            }
        }
        catch (IOException e) {
            LOG.error((Object)("getResponse failed.Socket:" + SocketUtil.getSocketDetail(this.socket)), (Throwable)e);
            this.recycle();
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("return resp=" + StringHelper.toString(resp)));
        }
        return resp;
    }

    protected Socket createSocket(String host, int port) throws UnknownHostException, IOException {
        String socketType = PropertyUtil.getTrimString(this.props, "socketType", PLAIN_SOCKET);
        if (PLAIN_SOCKET.equals(socketType)) {
            return new Socket(host, port);
        }
        return IDSSocketFactory.createSSLSocket(host, port, DUMMY_SSL.equals(socketType));
    }

    public void close() {
        if (this.isStopping) {
            return;
        }
        this.isStopping = true;
        this.recycle();
        this.isStopping = false;
    }

    protected byte[] readResponseBytes(InputStream inStream) throws IOException {
        int eofChar;
        byte[] result = null;
        byte[] head = TransferUtil.readBytes(inStream, 16);
        short bodyLenth = PacketUtil.parseBodyLength(head);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("response head=" + StringHelper.toString(head) + ", bodyLen=" + bodyLenth));
        }
        if (bodyLenth > 0) {
            byte[] body = TransferUtil.readBytes(inStream, bodyLenth);
            result = new byte[head.length + body.length];
            System.arraycopy(head, 0, result, 0, head.length);
            System.arraycopy(body, 0, result, head.length, body.length);
        }
        if ((eofChar = inStream.read()) != 25) {
            LOG.error((Object)("invalid protocol eof char: " + eofChar));
        }
        return result == null ? head : result;
    }

    protected void sendRequestBytes(byte[] bytes, OutputStream outStream) throws IOException {
        outStream.write(bytes);
        outStream.write(25);
        outStream.flush();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSocketAlive() {
        return this.socket != null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("agentName=").append(this.agentName);
        sb.append(';').append("socket=").append(this.socket);
        sb.append(';').append(" idsHost=").append(this.host).append(":").append(this.port);
        sb.append(';').append(" nodeKey=").append(this.nodeKeyOfIDSServer);
        sb.append(';').append(super.toString());
        return sb.toString();
    }

    public String getNodeKeyOfIDSServer() {
        return this.nodeKeyOfIDSServer;
    }
}

