/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.gateway.logic.impl;

import com.trs.cis4.gateway.bean.AgentConfig;
import com.trs.cis4.gateway.dao.IRobotDAO;
import com.trs.cis4.gateway.helper.ConfigHelper;
import com.trs.cis4.gateway.logic.IBaseLogic;
import com.trs.cis4.gateway.logic.util.RobotCacheHashtable;
import com.trs.cis4.socket.config.RobotConfig;
import com.trs.cis4.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseLogicImpl
implements IBaseLogic {
    private Logger log = Logger.getLogger(this.getClass());
    protected RobotConfig robotConfig;
    protected IRobotDAO robotDAO;

    public void setRobotDAO(IRobotDAO robotDAO) {
        this.robotDAO = robotDAO;
    }

    @Override
    public void setRobotConfig(RobotConfig robotConfig) {
        this.robotConfig = robotConfig;
        if (this.robotDAO != null) {
            this.robotDAO.setRobotConfig(robotConfig);
        }
    }

    @Override
    public List<AgentConfig> getConfig() throws ExceptionUtil {
        List<AgentConfig> catalogs = RobotCacheHashtable.getAgentConfigs(this.getRobotStr());
        if (catalogs != null) {
            return catalogs;
        }
        return this.downloadConfig();
    }

    @Override
    public List<AgentConfig> downloadConfig() throws ExceptionUtil {
        String config;
        List<AgentConfig> catalogs = new ArrayList<AgentConfig>();
        if (this.checkMachineCode() && (config = this.robotDAO.downloadConfig()) != null && !config.equals("")) {
            String _config = "<?xml version=\"1.0\" encoding=\"GBK\" ?>\r\n<INFO>\r\n" + config.trim() + "\r\n</INFO>";
            catalogs = ConfigHelper.stringToObjects(_config);
        }
        RobotCacheHashtable.setAgentConfigs(this.getRobotStr(), catalogs);
        return RobotCacheHashtable.getAgentConfigs(this.getRobotStr());
    }

    protected boolean checkMachineCode() throws ExceptionUtil {
        String rMac;
        boolean download = true;
        String robotHost = this.robotConfig.getRobothost();
        if (!(robotHost.equals("127.0.0.1") || robotHost.toLowerCase().equals("localhost") || (rMac = this.robotDAO.getMachineCode()).equalsIgnoreCase(this.robotConfig.getMachineCode()))) {
            download = false;
            this.log.error((Object)("\u8fdc\u7a0b\u670d\u52a1\u5668\u5730\u5740(" + robotHost + ")\u673a\u5668\u7801\u9a8c\u8bc1\u9519\u8bef\uff01"));
        }
        return download;
    }

    @Override
    public int getReturnCode() throws ExceptionUtil {
        return this.robotDAO.getReturnCode();
    }

    @Override
    public String getReturnLog() throws ExceptionUtil {
        return this.robotDAO.getReturnLog();
    }

    @Override
    public String getSystemLog() throws ExceptionUtil {
        return this.robotDAO.getSystemLog();
    }

    private String getRobotStr() throws ExceptionUtil {
        return this.robotDAO.getRobotParams().getRobotConfig().getRobotid();
    }
}

